/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.library.endpoints;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="authorization-endpoint")
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class AuthorizationEndpoint
implements Comparable<AuthorizationEndpoint> {
    @XmlAttribute
    private int priority = 0;
    @XmlAttribute
    private String infrastructure;
    @XmlAttribute(name="cacheValidityInMillis")
    long clientCacheValidity = 600000L;
    @XmlElement
    private String host;
    @XmlElement
    private int port;
    @XmlElement(name="secure")
    private boolean secureConnection = false;

    protected AuthorizationEndpoint() {
    }

    public AuthorizationEndpoint(String infrastructure, int priority, String host, int port) {
        this.infrastructure = infrastructure;
        this.host = host;
        this.priority = priority;
        this.port = port;
    }

    protected String getInfrastructure() {
        return this.infrastructure;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPriority() {
        return this.priority;
    }

    public long getClientCacheValidity() {
        return this.clientCacheValidity;
    }

    public boolean isSecureConnection() {
        return this.secureConnection;
    }

    public void setSecureConnection(boolean secureConnection) {
        this.secureConnection = secureConnection;
    }

    @Override
    public int compareTo(AuthorizationEndpoint o) {
        return this.priority - o.priority;
    }

    public String toString() {
        return "AuthorizationEndpoint [infrastructure= " + this.infrastructure + " priority=" + this.priority + ", host=" + this.host + ", port=" + this.port + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.infrastructure == null ? 0 : this.infrastructure.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + this.priority;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthorizationEndpoint other = (AuthorizationEndpoint)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.infrastructure == null ? other.infrastructure != null : !this.infrastructure.equals(other.infrastructure)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return this.priority == other.priority;
    }
}

