/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.container;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gcube.common.security.credentials.Credentials;
import org.gcube.smartgears.configuration.ProxyAddress;
import org.gcube.smartgears.configuration.container.BaseConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.configuration.container.Site;
import org.gcube.smartgears.handlers.container.ContainerHandler;
import org.gcube.smartgears.handlers.container.lifecycle.AccountingManager;
import org.gcube.smartgears.handlers.container.lifecycle.ContainerProfileManager;
import org.gcube.smartgears.persistence.LocalPersistence;
import org.gcube.smartgears.persistence.PersistenceWriter;
import org.gcube.smartgears.security.AuthorizationProviderFactory;
import org.gcube.smartgears.security.defaults.DefaultAuthorizationProvider;
import org.gcube.smartgears.security.defaults.DefaultAuthorizationProviderFactory;
import org.gcube.smartgears.utils.Utils;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class ContainerConfigurationBinder {
    public ContainerConfiguration load(InputStream stream) {
        try {
            Profile.Section siteSection;
            Profile.Section propertiesSection;
            Ini configurator = new Ini(stream);
            ContainerConfiguration conf = new ContainerConfiguration();
            Profile.Section nodeSection = (Profile.Section)configurator.get((Object)"node");
            if (nodeSection != null) {
                BaseConfiguration nodeConf = new BaseConfiguration();
                nodeSection.to((Object)nodeConf);
                conf.setBaseConfiguration(nodeConf);
            }
            if ((propertiesSection = (Profile.Section)configurator.get((Object)"properties")) != null) {
                conf.setProperties(propertiesSection.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
            if ((siteSection = (Profile.Section)configurator.get((Object)"site")) != null) {
                Site siteConf = new Site();
                siteSection.to((Object)siteConf);
                conf.setSite(siteConf);
            }
            this.initAuthorizationPart(configurator, conf);
            this.initPersistencePart(configurator, conf);
            this.initProxyPart(configurator, conf);
            String location = Utils.home() + "/state";
            File dir = new File(location);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            conf.setAccountingFallbackLocation(location);
            return conf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initProxyPart(Ini configurator, ContainerConfiguration conf) throws Exception {
        Profile.Section proxySection = (Profile.Section)configurator.get((Object)"proxy");
        if (proxySection != null) {
            ProxyAddress proxyConf = new ProxyAddress();
            proxySection.to((Object)proxyConf);
            conf.setProxy(proxyConf);
        }
    }

    private void initPersistencePart(Ini configurator, ContainerConfiguration conf) throws Exception {
        Profile.Section persistenceSection = (Profile.Section)configurator.get((Object)"persistence");
        if (persistenceSection != null) {
            PersistenceWriter persistenceWriter;
            String type = (String)persistenceSection.get((Object)"class");
            if (type == null) {
                throw new Exception("ini file error: type not found in \"persistence\" section");
            }
            try {
                Object persistenceImpl = Class.forName(type).newInstance();
                persistenceWriter = (PersistenceWriter)PersistenceWriter.class.cast(persistenceImpl);
            }
            catch (Exception e) {
                throw new Exception("ini file error: invalid persistence type in \"persistence\" section", e);
            }
            persistenceSection.to((Object)persistenceWriter);
            conf.setPersistenceManager(persistenceWriter);
        } else {
            String location = Utils.home() + "/state";
            File dir = new File(location);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            conf.setPersistenceManager(new LocalPersistence(location));
        }
    }

    private void initAuthorizationPart(Ini configurator, ContainerConfiguration conf) throws Exception {
        Profile.Section authorizationSection = (Profile.Section)configurator.get((Object)"authorization");
        if (authorizationSection != null) {
            Credentials credentials;
            AuthorizationProviderFactory<DefaultAuthorizationProvider> authProviderFactory;
            String provider = (String)authorizationSection.get((Object)"factory");
            if (provider != null) {
                try {
                    Object authProviderImpl = Class.forName(provider).newInstance();
                    authProviderFactory = (AuthorizationProviderFactory)AuthorizationProviderFactory.class.cast(authProviderImpl);
                }
                catch (Exception e) {
                    throw new Exception("ini file error: invalid provider type in \"authorization\" section", e);
                }
            } else {
                authProviderFactory = new DefaultAuthorizationProviderFactory();
            }
            authorizationSection.to((Object)authProviderFactory, "factory.");
            String type = (String)authorizationSection.get((Object)"credentials.class");
            if (type == null) {
                throw new Exception("ini file error: credentials type not found in \"authorization\" section");
            }
            try {
                Object credentialsImpl = Class.forName(type).newInstance();
                credentials = (Credentials)Credentials.class.cast(credentialsImpl);
            }
            catch (Exception e) {
                throw new Exception("ini file error: invalid credentials type in \"authorization\" section", e);
            }
            authorizationSection.to((Object)credentials, "credentials.");
            DefaultAuthorizationProvider authProvider = authProviderFactory.connect(credentials);
            conf.setAuthorizationProvider(authProvider);
        }
    }

    public List<ContainerHandler> bindHandlers(ClassLoader classloader) {
        LinkedList<ContainerHandler> handlers = new LinkedList<ContainerHandler>();
        handlers.add(new AccountingManager());
        handlers.add(new ContainerProfileManager());
        handlers.addAll(this.scanForContainerHadlers(classloader));
        return handlers;
    }

    private List<? extends ContainerHandler> scanForContainerHadlers(ClassLoader classloader) throws RuntimeException {
        return Collections.emptyList();
    }
}

