/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.managers;

import java.util.List;
import org.gcube.common.events.Observes;
import org.gcube.smartgears.configuration.container.ContainerHandlers;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.handlers.container.ContainerHandler;
import org.gcube.smartgears.handlers.container.ContainerLifecycleEvent;
import org.gcube.smartgears.handlers.container.ContainerPipeline;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.lifecycle.container.ContainerState;
import org.gcube.smartgears.provider.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerManager {
    private static Logger log = LoggerFactory.getLogger(ContainerManager.class);
    public static ContainerManager instance = new ContainerManager();
    private ContainerContext context;
    private ContainerPipeline pipeline;

    private ContainerManager() {
    }

    public ContainerContext start() {
        log.info("starting container management");
        this.context = null;
        try {
            this.context = ProviderFactory.provider().containerContext();
            this.context.configuration().validate();
            ContainerHandlers handlers = ProviderFactory.provider().containerHandlers();
            log.trace("managing container lifecycle with {}", handlers.get());
            this.startHandlers(handlers.get());
            this.context.lifecycle().moveTo(ContainerState.active);
            return this.context;
        }
        catch (RuntimeException e) {
            log.error("cannot manage container (see cause)", (Throwable)e);
            if (this.context != null) {
                this.context.lifecycle().moveTo(ContainerState.failed);
            }
            throw e;
        }
    }

    public void manage(ApplicationContext app) {
        app.events().subscribe((Object)this);
    }

    @Observes(value={"failure", "stop"}, kind=Observes.Kind.critical)
    void monitorApplication(ApplicationLifecycle lifecycle) {
        if (!this.context.lifecycle().tryMoveTo(ContainerState.partActive)) {
            log.warn("container could not become part-active after failure of application");
        }
    }

    public void stop() {
        if (this.context == null) {
            return;
        }
        log.info("stopping container management");
        try {
            this.context.lifecycle().tryMoveTo(ContainerState.stopped);
            this.stopHandlers();
            log.info("stopping container  events");
            this.context.events().stop();
        }
        catch (RuntimeException e) {
            log.warn("cannot stop container management (see cause)", (Throwable)e);
        }
    }

    private void startHandlers(List<ContainerHandler> handlers) {
        try {
            this.pipeline = new ContainerPipeline(handlers);
            this.pipeline.forward(new ContainerLifecycleEvent.Start(this.context));
        }
        catch (RuntimeException e) {
            this.context.lifecycle().tryMoveTo(ContainerState.failed);
            throw e;
        }
    }

    private void stopHandlers() {
        if (this.pipeline == null) {
            return;
        }
        ContainerPipeline returnPipeline = this.pipeline.reverse();
        returnPipeline.forward(new ContainerLifecycleEvent.Stop(this.context));
    }
}

