/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.persistence;

import java.io.File;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.events.impl.Utils;
import org.gcube.common.validator.annotations.NotNull;
import org.gcube.smartgears.persistence.Persistence;

@XmlRootElement(name="persistence")
public class DefaultPersistence
implements Persistence {
    @XmlAttribute(name="location")
    @NotNull
    private String location;

    public DefaultPersistence() {
    }

    public DefaultPersistence(String location) {
        Utils.notNull((Object)location);
        this.location = location;
        this.validate();
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public File file(String path) {
        Utils.notNull((String)"relative path", (Object)path);
        return new File(this.location, path);
    }

    void afterUnmarshal(Unmarshaller u, Object parent) {
        this.validate();
    }

    public void validate() {
        File locationDir = new File(this.location);
        if (!(locationDir.exists() && locationDir.isDirectory() && locationDir.canRead() && locationDir.canWrite())) {
            throw new IllegalStateException("invalid node configuration: home " + this.location + " does not exist or is not a directory or cannot be accessed in read/write mode");
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultPersistence other = (DefaultPersistence)obj;
        return !(this.location == null ? other.location != null : !this.location.equals(other.location));
    }

    public String toString() {
        return "local persistence in " + this.location;
    }
}

