/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.publisher;

import java.util.List;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.RegistryPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherImpl;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopedPublisherImpl
implements ScopedPublisher {
    private RegistryPublisher registryPublisher;
    private static final Logger log = LoggerFactory.getLogger(ScopedPublisherImpl.class);

    protected ScopedPublisherImpl() {
        this.registryPublisher = new RegistryPublisherImpl();
    }

    protected ScopedPublisherImpl(RegistryPublisher rp) {
        this.registryPublisher = rp;
    }

    @Override
    public <T extends Resource> T create(T resource, List<String> scopes) throws RegistryNotFoundException {
        String currentScope = ScopeProvider.instance.get();
        boolean created = false;
        for (String scope : scopes) {
            ScopeProvider.instance.set(scope);
            if (!created) {
                log.info("call to registryPublisher create method with scope " + scope);
                resource = this.registryPublisher.create(resource);
                created = true;
                continue;
            }
            log.info("call to registryPublisher update method resource " + resource.id() + " with scope " + scope);
            resource = this.registryPublisher.update(resource);
        }
        ScopeProvider.instance.set(currentScope);
        return resource;
    }

    @Override
    public <T extends Resource> T update(T resource) throws RegistryNotFoundException {
        return this.registryPublisher.update(resource);
    }

    @Override
    public <T extends Resource> T remove(T resource, List<String> scopes) throws RegistryNotFoundException {
        String currentScope = ScopeProvider.instance.get();
        for (String scope : scopes) {
            ScopeProvider.instance.set(scope);
            this.registryPublisher.remove(resource);
        }
        ScopeProvider.instance.set(currentScope);
        return resource;
    }
}

