/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.lifecycle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.provider.ProviderFactory;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilePublisher {
    private static final Logger log = LoggerFactory.getLogger(ProfilePublisher.class);
    private final ScopedPublisher publisher;
    private final ApplicationContext context;

    public ProfilePublisher(ApplicationContext context) {
        this.context = context;
        this.publisher = ProviderFactory.provider().publisherFor(context);
    }

    public void addTo(Collection<String> scopes) {
        Utils.notEmpty("scopes", scopes);
        GCoreEndpoint profile = this.context.profile(GCoreEndpoint.class);
        HashSet<String> newscopes = new HashSet<String>(scopes);
        if (!newscopes.isEmpty()) {
            try {
                log.info("publishing {} in scopes {}", (Object)this.context.name(), newscopes);
                profile = (GCoreEndpoint)this.publisher.create((Resource)profile, new ArrayList<String>(newscopes));
                this.sharePublished(profile);
            }
            catch (Exception e) {
                Utils.rethrowUnchecked(e);
            }
        }
    }

    public void update() {
        GCoreEndpoint profile = this.context.profile(GCoreEndpoint.class);
        log.info("publishing {} in scopes {}", (Object)this.context.name(), (Object)profile.scopes().asCollection());
        try {
            profile = (GCoreEndpoint)this.publisher.update((Resource)profile);
            this.sharePublished(profile);
        }
        catch (Exception e) {
            Utils.rethrowUnchecked(e);
        }
    }

    public void removeFrom(Collection<String> scopes) {
        GCoreEndpoint profile = this.context.profile(GCoreEndpoint.class);
        log.info("removing {} from scopes {}", (Object)this.context.name(), scopes);
        try {
            ArrayList<String> list = new ArrayList<String>(scopes);
            profile = (GCoreEndpoint)this.publisher.remove((Resource)profile, list);
            this.update();
        }
        catch (Exception e) {
            Utils.rethrowUnchecked(e);
        }
    }

    private void sharePublished(GCoreEndpoint profile) {
        this.context.events().fire((Object)profile, new String[]{"published"});
    }
}

