/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.persistence.couchdb;

import java.util.Map;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.gcube.accounting.datamodel.BasicUsageRecord;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.persistence.AccountingPersistenceBackend;
import org.gcube.accounting.persistence.AccountingPersistenceConfiguration;
import org.gcube.common.couchdb.connector.HttpCouchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingPersistenceCouchDB
extends AccountingPersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(AccountingPersistenceCouchDB.class);
    protected HttpCouchClient httpCouchClient;
    protected static final String DB_NAME = "dbName";

    public void close() throws Exception {
    }

    protected void prepareConnection(AccountingPersistenceConfiguration configuration) throws Exception {
        logger.debug("Preparing Connection for {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        this.httpCouchClient = new HttpCouchClient(configuration.getUri().toURL().toString(), configuration.getProperty(DB_NAME), configuration.getUsername(), configuration.getPassword());
    }

    protected void createItem(JsonNode node, String id) throws Exception {
        this.httpCouchClient.put(node.toString(), id);
    }

    protected void reallyAccount(UsageRecord usageRecord) throws Exception {
        JsonNode node = AccountingPersistenceCouchDB.usageRecordToJsonNode(usageRecord);
        this.createItem(node, usageRecord.getId());
    }

    public static JsonNode usageRecordToJsonNode(UsageRecord usageRecord) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.valueToTree((Object)usageRecord.getResourceProperties());
        return node;
    }

    public static UsageRecord jsonNodeToUsageRecord(JsonNode jsonNode) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Map result = (Map)mapper.convertValue((Object)jsonNode, Map.class);
        UsageRecord usageRecord = BasicUsageRecord.getUsageRecord((Map)result);
        return usageRecord;
    }
}

