/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;

final class SymmetricKey {
    private static Key key;
    private static String keyAlgorithm;

    private SymmetricKey() {
    }

    protected static Key getKey() throws InvalidKeyException {
        if (key == null) {
            SymmetricKey.load();
        }
        return key;
    }

    private static void load() throws InvalidKeyException {
        byte[] rawKey;
        String keyFileName = null;
        try {
            keyFileName = SymmetricKey.getKeyFileName();
            InputStream is = SymmetricKey.class.getResourceAsStream("/" + keyFileName);
            rawKey = SymmetricKey.getBytesFromStream(is);
        }
        catch (Exception e) {
            System.out.println("Unable to load the Key " + keyFileName + " from the classpath");
            e.printStackTrace();
            throw new InvalidKeyException("Unable to load the Key " + keyFileName + " from the classpath");
        }
        try {
            key = new SecretKeySpec(rawKey, 0, rawKey.length, keyAlgorithm);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidKeyException();
        }
    }

    private static byte[] getBytesFromStream(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        byte[] rawKey = buffer.toByteArray();
        return rawKey;
    }

    protected static String getKeyFileName() throws InvalidKeyException {
        ScopeBean bean;
        String keyFile = null;
        String scope = ScopeProvider.instance.get();
        if (scope != null) {
            bean = new ScopeBean(scope);
            if (bean.is(ScopeBean.Type.VRE)) {
                bean = bean.enclosingScope();
            }
        } else {
            throw new InvalidKeyException(" invalid key for scope: " + scope);
        }
        String name = bean.name();
        keyFile = name + ".gcubekey";
        return keyFile;
    }

    static {
        keyAlgorithm = "AES";
    }
}

