/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers;

import java.util.ArrayList;
import java.util.List;
import org.gcube.smartgears.handlers.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Pipeline<E, H extends Handler<E>> {
    private static Logger log = LoggerFactory.getLogger(Pipeline.class);
    private final List<H> handlers;
    private int cursor = 0;

    public Pipeline(List<H> handlers) {
        this.handlers = new ArrayList<H>(handlers);
    }

    public List<H> handlers() {
        return new ArrayList<H>(this.handlers);
    }

    public void forward(E event) {
        if (this.cursor >= this.handlers.size()) {
            this.reset();
            return;
        }
        Handler handler = (Handler)this.handlers.get(this.cursor);
        ++this.cursor;
        try {
            log.trace("executing handler {} with event {} ", (Object)handler, event);
            handler.onEvent(event);
        }
        catch (RuntimeException e) {
            this.reset();
            throw e;
        }
        this.forward(event);
    }

    private void reset() {
        this.cursor = 0;
    }
}

