/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.library.provider;

import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.library.BannedService;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UserInfo {
    private String userName;
    private List<String> roles;
    private List<BannedService> bannedServices;

    protected UserInfo() {
    }

    public UserInfo(String userName, List<String> roles, List<BannedService> bannedServices) {
        this.userName = userName;
        this.roles = roles;
        this.bannedServices = bannedServices;
    }

    public String getUserName() {
        return this.userName;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public List<BannedService> getBannedServices() {
        return this.bannedServices;
    }

    public boolean isTokenBannedForService(BannedService service) {
        return this.bannedServices.contains(service);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.roles == null ? 0 : this.roles.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserInfo other = (UserInfo)obj;
        if (this.roles == null ? other.roles != null : !this.roles.equals(other.roles)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public String toString() {
        return "UserInfo [userName=" + this.userName + ", roles=" + this.roles + "]";
    }
}

