/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.gcube.common.clients.Plugin;
import org.gcube.common.clients.exceptions.DiscoveryException;
import org.gcube.common.clients.queries.Query;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class LegacyQuery
implements Query<EndpointReference> {
    private static String classFormat = "$resource/Profile/ServiceClass/text() eq '%1s'";
    private static String nameFormat = "$resource/Profile/ServiceName/text() eq '%1s'";
    private static String statusFormat = "$resource/Profile/DeploymentData/Status/text() eq 'ready'";
    private static String containsFormat = "contains($entry/string(),'%1s')";
    private static DiscoveryClient<String> client = ICFactory.client();
    private final SimpleQuery query;

    public LegacyQuery(Plugin<?, ?> plugin) {
        this.query = ICFactory.queryFor(GCoreEndpoint.class).addCondition(String.format(classFormat, plugin.serviceClass())).addCondition(String.format(nameFormat, plugin.serviceName())).addCondition(String.format(statusFormat, new Object[0])).addVariable("$entry", "$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint").addCondition(String.format(containsFormat, plugin.name())).setResult("$entry/text()");
    }

    public LegacyQuery addVariable(String name, String range) {
        this.query.addVariable(name, range);
        return this;
    }

    public LegacyQuery addCondition(String condition) {
        this.query.addCondition(condition);
        return this;
    }

    public LegacyQuery addNamespace(String prefix, URI uri) {
        this.query.addNamespace(prefix, uri);
        return this;
    }

    public List<EndpointReference> fire() throws DiscoveryException {
        ArrayList<EndpointReference> refs = new ArrayList<EndpointReference>();
        try {
            List addresses = client.submit((org.gcube.resources.discovery.client.queries.api.Query)this.query);
            for (String address : addresses) {
                refs.add((EndpointReference)new W3CEndpointReferenceBuilder().address(address).build());
            }
        }
        catch (org.gcube.resources.discovery.client.api.DiscoveryException ex) {
            throw new DiscoveryException((Throwable)ex);
        }
        return refs;
    }

    public String toString() {
        return this.query.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LegacyQuery other = (LegacyQuery)obj;
        return !(this.query == null ? other.query != null : !this.query.equals(other.query));
    }
}

