/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers;

import java.util.ArrayList;
import java.util.List;
import org.gcube.smartgears.handlers.Handler;

public abstract class Pipeline<E, H extends Handler<E>> {
    private final List<H> handlers;
    private int cursor = 0;

    public Pipeline(List<H> handlers) {
        this.handlers = new ArrayList<H>(handlers);
    }

    public List<H> handlers() {
        return new ArrayList<H>(this.handlers);
    }

    public void forward(E event) {
        if (this.cursor >= this.handlers.size()) {
            this.reset();
            return;
        }
        Handler handler = (Handler)this.handlers.get(this.cursor);
        ++this.cursor;
        try {
            handler.onEvent(event);
        }
        catch (RuntimeException e) {
            this.reset();
            throw e;
        }
        this.forward(event);
    }

    private void reset() {
        this.cursor = 0;
    }
}

