/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.lang.reflect.Array;
import java.util.ArrayList;
import rx.Observable;
import rx.annotations.Experimental;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.internal.operators.NotificationLite;
import rx.subjects.Subject;
import rx.subjects.SubjectSubscriptionManager;

public final class AsyncSubject<T>
extends Subject<T, T> {
    final SubjectSubscriptionManager<T> state;
    volatile Object lastValue;
    private final NotificationLite<T> nl = NotificationLite.instance();

    public static <T> AsyncSubject<T> create() {
        final SubjectSubscriptionManager state = new SubjectSubscriptionManager();
        state.onTerminated = new Action1<SubjectSubscriptionManager.SubjectObserver<T>>(){

            @Override
            public void call(SubjectSubscriptionManager.SubjectObserver<T> o) {
                Object v = state.get();
                NotificationLite nl = state.nl;
                o.accept(v, nl);
                if (v == null || !nl.isCompleted(v) && !nl.isError(v)) {
                    o.onCompleted();
                }
            }
        };
        return new AsyncSubject(state, state);
    }

    protected AsyncSubject(Observable.OnSubscribe<T> onSubscribe, SubjectSubscriptionManager<T> state) {
        super(onSubscribe);
        this.state = state;
    }

    @Override
    public void onCompleted() {
        if (this.state.active) {
            Object last = this.lastValue;
            if (last == null) {
                last = this.nl.completed();
            }
            for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.terminate(last)) {
                if (last == this.nl.completed()) {
                    bo.onCompleted();
                    continue;
                }
                bo.onNext(this.nl.getValue(last));
                bo.onCompleted();
            }
        }
    }

    @Override
    public void onError(Throwable e) {
        if (this.state.active) {
            Object n = this.nl.error(e);
            ArrayList<Throwable> errors = null;
            for (SubjectSubscriptionManager.SubjectObserver<T> bo : this.state.terminate(n)) {
                try {
                    bo.onError(e);
                }
                catch (Throwable e2) {
                    if (errors == null) {
                        errors = new ArrayList<Throwable>();
                    }
                    errors.add(e2);
                }
            }
            Exceptions.throwIfAny(errors);
        }
    }

    @Override
    public void onNext(T v) {
        this.lastValue = this.nl.next(v);
    }

    @Override
    public boolean hasObservers() {
        return this.state.observers().length > 0;
    }

    @Override
    @Experimental
    public boolean hasValue() {
        Object v = this.lastValue;
        Object o = this.state.get();
        return !this.nl.isError(o) && this.nl.isNext(v);
    }

    @Override
    @Experimental
    public boolean hasThrowable() {
        Object o = this.state.get();
        return this.nl.isError(o);
    }

    @Override
    @Experimental
    public boolean hasCompleted() {
        Object o = this.state.get();
        return o != null && !this.nl.isError(o);
    }

    @Override
    @Experimental
    public T getValue() {
        Object v = this.lastValue;
        Object o = this.state.get();
        if (!this.nl.isError(o) && this.nl.isNext(v)) {
            return this.nl.getValue(v);
        }
        return null;
    }

    @Override
    @Experimental
    public Throwable getThrowable() {
        Object o = this.state.get();
        if (this.nl.isError(o)) {
            return this.nl.getError(o);
        }
        return null;
    }

    @Override
    @Deprecated
    @Experimental
    public T[] getValues(T[] a) {
        Object v = this.lastValue;
        Object o = this.state.get();
        if (!this.nl.isError(o) && this.nl.isNext(v)) {
            T val = this.nl.getValue(v);
            if (a.length == 0) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
            }
            a[0] = val;
            if (a.length > 1) {
                a[1] = null;
            }
        } else if (a.length > 0) {
            a[0] = null;
        }
        return a;
    }
}

