/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.dcp;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.AbstractGenericHandler;
import com.couchbase.client.core.endpoint.ResponseStatusConverter;
import com.couchbase.client.core.endpoint.dcp.DCPConnection;
import com.couchbase.client.core.endpoint.kv.KeyValueStatus;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.dcp.AbstractDCPRequest;
import com.couchbase.client.core.message.dcp.AbstractDCPResponse;
import com.couchbase.client.core.message.dcp.ControlParameter;
import com.couchbase.client.core.message.dcp.DCPRequest;
import com.couchbase.client.core.message.dcp.FailoverLogEntry;
import com.couchbase.client.core.message.dcp.GetFailoverLogRequest;
import com.couchbase.client.core.message.dcp.GetFailoverLogResponse;
import com.couchbase.client.core.message.dcp.MutationMessage;
import com.couchbase.client.core.message.dcp.OpenConnectionRequest;
import com.couchbase.client.core.message.dcp.OpenConnectionResponse;
import com.couchbase.client.core.message.dcp.RemoveMessage;
import com.couchbase.client.core.message.dcp.SnapshotMarkerMessage;
import com.couchbase.client.core.message.dcp.StreamEndMessage;
import com.couchbase.client.core.message.dcp.StreamRequestRequest;
import com.couchbase.client.core.message.dcp.StreamRequestResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.lmax.disruptor.EventSink;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.BinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import rx.functions.Action1;

public class DCPHandler
extends AbstractGenericHandler<FullBinaryMemcacheResponse, BinaryMemcacheRequest, DCPRequest> {
    public static final byte OP_OPEN_CONNECTION = 80;
    public static final byte OP_STREAM_REQUEST = 83;
    public static final byte OP_STREAM_END = 85;
    public static final byte OP_SNAPSHOT_MARKER = 86;
    public static final byte OP_MUTATION = 87;
    public static final byte OP_REMOVE = 88;
    public static final byte OP_CONTROL = 94;
    public static final byte OP_BUFFER_ACK = 93;
    public static final byte OP_GET_FAILOVER_LOG = 84;
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DCPHandler.class);
    private DCPConnection connection;

    public DCPHandler(AbstractEndpoint endpoint, EventSink<ResponseEvent> responseBuffer, boolean isTransient) {
        this(endpoint, responseBuffer, (Queue<DCPRequest>)new ArrayDeque<DCPRequest>(), isTransient);
    }

    public DCPHandler(AbstractEndpoint endpoint, EventSink<ResponseEvent> responseBuffer, Queue<DCPRequest> queue, boolean isTransient) {
        super(endpoint, responseBuffer, queue, isTransient);
    }

    @Override
    protected BinaryMemcacheRequest encodeRequest(ChannelHandlerContext ctx, DCPRequest msg) throws Exception {
        BinaryMemcacheRequest request;
        if (msg instanceof OpenConnectionRequest) {
            OpenConnectionRequest openConnection = (OpenConnectionRequest)msg;
            request = this.handleOpenConnectionRequest(ctx, openConnection);
            this.connection = new DCPConnection(this.env(), openConnection.connectionName(), openConnection.bucket());
        } else if (msg instanceof StreamRequestRequest) {
            request = this.handleStreamRequestRequest(ctx, (StreamRequestRequest)msg);
        } else if (msg instanceof GetFailoverLogRequest) {
            request = this.handleFailoverLogsRequest(ctx, (GetFailoverLogRequest)msg);
        } else {
            throw new IllegalArgumentException("Unknown incoming DCPRequest type " + msg.getClass());
        }
        if (msg.partition() >= 0) {
            request.setReserved(msg.partition());
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CouchbaseResponse decodeResponse(ChannelHandlerContext ctx, FullBinaryMemcacheResponse msg) throws Exception {
        DCPRequest request = (DCPRequest)this.currentRequest();
        AbstractDCPResponse response = null;
        if (msg.getOpcode() == 80 && request instanceof OpenConnectionRequest) {
            response = new OpenConnectionResponse(ResponseStatusConverter.fromBinary(msg.getStatus()), this.connection, request);
            if (this.env().dcpConnectionBufferSize() > 0) {
                ctx.writeAndFlush(this.controlRequest(ctx, ControlParameter.CONNECTION_BUFFER_SIZE, this.env().dcpConnectionBufferSize()));
            }
        } else if (msg.getOpcode() == 83 && request instanceof StreamRequestRequest) {
            ByteBuf content = msg.content();
            List<FailoverLogEntry> failoverLog = null;
            long rollbackToSequenceNumber = 0L;
            KeyValueStatus status = KeyValueStatus.valueOf(msg.getStatus());
            switch (status) {
                case SUCCESS: {
                    failoverLog = this.readFailoverLogs(content);
                    break;
                }
                case ERR_ROLLBACK: {
                    rollbackToSequenceNumber = content.readLong();
                    break;
                }
                default: {
                    LOGGER.warn("Unexpected status of StreamRequestResponse: {} (0x{}, {})", new Object[]{status, Integer.toHexString(status.code()), status.description()});
                }
            }
            response = new StreamRequestResponse(ResponseStatusConverter.fromBinary(msg.getStatus()), failoverLog, rollbackToSequenceNumber, request, this.connection);
            this.updateConnectionStats(ctx, this.connection, msg);
        } else if (msg.getOpcode() == 84) {
            response = new GetFailoverLogResponse(ResponseStatusConverter.fromBinary(msg.getStatus()), this.readFailoverLogs(msg.content()), request);
        } else if (msg.getOpcode() == 94 || msg.getOpcode() == 93) {
            KeyValueStatus status = KeyValueStatus.valueOf(msg.getStatus());
            if (status != KeyValueStatus.SUCCESS) {
                LOGGER.warn("Unexpected status of service response (opcode={}): {} (0x{}, {})", new Object[]{Integer.toHexString(msg.getOpcode()), status, Integer.toHexString(status.code()), status.description()});
            }
        } else {
            DCPRequest oldRequest = (DCPRequest)this.currentRequest();
            AbstractDCPRequest dummy = new AbstractDCPRequest(this.connection.bucket(), null){};
            dummy.observable().subscribe((Action1)new Action1<CouchbaseResponse>(){

                public void call(CouchbaseResponse couchbaseResponse) {
                }
            }, (Action1)new Action1<Throwable>(){

                public void call(Throwable throwable) {
                    DCPHandler.this.connection.subject().onError(throwable);
                }
            });
            try {
                this.currentRequest(dummy);
                this.handleDCPRequest(ctx, msg);
            }
            finally {
                this.currentRequest(oldRequest);
            }
        }
        if (request != null && request.partition() >= 0 && response != null) {
            response.partition(request.partition());
        }
        if (response != null || request == null) {
            this.finishedDecoding();
        }
        return response;
    }

    private void handleDCPRequest(ChannelHandlerContext ctx, FullBinaryMemcacheResponse msg) {
        AbstractDCPRequest request = null;
        int flags = 0;
        long bySeqno = 0L;
        long revSeqno = 0L;
        switch (msg.getOpcode()) {
            case 86: {
                long startSequenceNumber = 0L;
                long endSequenceNumber = 0L;
                if (msg.getExtrasLength() > 0) {
                    ByteBuf extras = msg.getExtras();
                    startSequenceNumber = extras.readLong();
                    endSequenceNumber = extras.readLong();
                    flags = extras.readInt();
                }
                request = new SnapshotMarkerMessage(msg.getStatus(), startSequenceNumber, endSequenceNumber, flags, this.connection.bucket());
                this.updateConnectionStats(ctx, this.connection, msg);
                break;
            }
            case 87: {
                int expiration = 0;
                int lockTime = 0;
                if (msg.getExtrasLength() > 0) {
                    ByteBuf extras = msg.getExtras();
                    bySeqno = extras.readLong();
                    revSeqno = extras.readLong();
                    flags = extras.readInt();
                    expiration = extras.readInt();
                    lockTime = extras.readInt();
                }
                request = new MutationMessage(msg.getStatus(), msg.getKey(), msg.content().retain(), expiration, bySeqno, revSeqno, flags, lockTime, msg.getCAS(), this.connection.bucket());
                this.updateConnectionStats(ctx, this.connection, msg);
                break;
            }
            case 88: {
                if (msg.getExtrasLength() > 0) {
                    ByteBuf extras = msg.getExtras();
                    bySeqno = extras.readLong();
                    revSeqno = extras.readLong();
                }
                request = new RemoveMessage(msg.getStatus(), msg.getKey(), msg.getCAS(), bySeqno, revSeqno, this.connection.bucket());
                this.updateConnectionStats(ctx, this.connection, msg);
                break;
            }
            case 85: {
                ByteBuf extrasReleased = msg.getExtras();
                ByteBuf extras = ctx.alloc().buffer(msg.getExtrasLength());
                extras.writeBytes(extrasReleased, extrasReleased.readerIndex(), extrasReleased.readableBytes());
                flags = extras.readInt();
                extras.release();
                request = new StreamEndMessage(StreamEndMessage.Reason.valueOf(flags), this.connection.bucket());
                this.connection.removeStream(msg.getOpaque());
                this.updateConnectionStats(ctx, this.connection, msg);
                break;
            }
            default: {
                LOGGER.info("Unhandled DCP message: {}, {}", (Object)msg.getOpcode(), (Object)msg);
            }
        }
        if (request != null) {
            this.connection.subject().onNext(request);
        }
        if (this.connection.streamsCount() == 0) {
            this.connection.subject().onCompleted();
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.connection.subject().onCompleted();
        super.handlerRemoved(ctx);
    }

    private void updateConnectionStats(ChannelHandlerContext ctx, DCPConnection connection, FullBinaryMemcacheResponse msg) {
        connection.inc(msg.getTotalBodyLength());
        if ((double)connection.totalReceivedBytes() >= (double)this.env().dcpConnectionBufferSize() * this.env().dcpConnectionBufferAckThreshold()) {
            ctx.writeAndFlush(this.bufferAckRequest(ctx, connection.totalReceivedBytes()));
            connection.reset();
        }
    }

    private BinaryMemcacheRequest bufferAckRequest(ChannelHandlerContext ctx, int size) {
        ByteBuf extras = ctx.alloc().buffer(4).writeInt(size);
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest("", extras);
        request.setOpcode((byte)93);
        request.setExtrasLength((byte)extras.readableBytes());
        request.setTotalBodyLength(extras.readableBytes());
        return request;
    }

    private FullBinaryMemcacheRequest controlRequest(ChannelHandlerContext ctx, ControlParameter parameter, boolean value) {
        return this.controlRequest(ctx, parameter, Boolean.toString(value));
    }

    private FullBinaryMemcacheRequest controlRequest(ChannelHandlerContext ctx, ControlParameter parameter, int value) {
        return this.controlRequest(ctx, parameter, Integer.toString(value));
    }

    private FullBinaryMemcacheRequest controlRequest(ChannelHandlerContext ctx, ControlParameter parameter, String value) {
        String key = parameter.value();
        short keyLength = (short)key.getBytes(CharsetUtil.UTF_8).length;
        byte[] val = value.getBytes(CharsetUtil.UTF_8);
        ByteBuf body = ctx.alloc().buffer(val.length);
        body.writeBytes(val);
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(key, Unpooled.EMPTY_BUFFER, body);
        request.setOpcode((byte)94);
        request.setKeyLength(keyLength);
        request.setTotalBodyLength(keyLength + body.readableBytes());
        return request;
    }

    private BinaryMemcacheRequest handleOpenConnectionRequest(ChannelHandlerContext ctx, OpenConnectionRequest msg) {
        ByteBuf extras = ctx.alloc().buffer(8);
        extras.writeInt(msg.sequenceNumber()).writeInt(msg.type().flags());
        String key = msg.connectionName();
        byte extrasLength = (byte)extras.readableBytes();
        short keyLength = (short)key.getBytes(CharsetUtil.UTF_8).length;
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(key, extras);
        request.setOpcode((byte)80);
        request.setKeyLength(keyLength);
        request.setExtrasLength(extrasLength);
        request.setTotalBodyLength(keyLength + extrasLength);
        return request;
    }

    private BinaryMemcacheRequest handleStreamRequestRequest(ChannelHandlerContext ctx, StreamRequestRequest msg) {
        ByteBuf extras = ctx.alloc().buffer(48);
        extras.writeInt(0).writeInt(0).writeLong(msg.startSequenceNumber()).writeLong(msg.endSequenceNumber()).writeLong(msg.vbucketUUID()).writeLong(msg.snapshotStartSequenceNumber()).writeLong(msg.snapshotEndSequenceNumber());
        byte extrasLength = (byte)extras.readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(extras);
        request.setOpcode((byte)83);
        request.setExtrasLength(extrasLength);
        request.setTotalBodyLength(extrasLength);
        request.setOpaque(this.connection.addStream(this.connection.name()));
        return request;
    }

    private BinaryMemcacheRequest handleFailoverLogsRequest(ChannelHandlerContext ctx, GetFailoverLogRequest msg) {
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        request.setOpcode((byte)84);
        request.setReserved(msg.partition());
        return request;
    }

    private List<FailoverLogEntry> readFailoverLogs(ByteBuf content) {
        ArrayList<FailoverLogEntry> failoverLog = new ArrayList<FailoverLogEntry>(content.readableBytes() / 16);
        while (content.readableBytes() >= 16) {
            FailoverLogEntry entry = new FailoverLogEntry(content.readLong(), content.readLong());
            failoverLog.add(entry);
        }
        return failoverLog;
    }

    @Override
    protected ServiceType serviceType() {
        return ServiceType.DCP;
    }
}

