/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.managers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.ContainerInfo;
import org.gcube.common.events.Observes;
import org.gcube.smartgears.configuration.container.ContainerHandlers;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.handlers.container.ContainerHandler;
import org.gcube.smartgears.handlers.container.ContainerLifecycleEvent;
import org.gcube.smartgears.handlers.container.ContainerPipeline;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.lifecycle.container.ContainerState;
import org.gcube.smartgears.provider.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerManager {
    private static Logger log = LoggerFactory.getLogger(ContainerManager.class);
    public static ContainerManager instance = new ContainerManager();
    private AuthorizationProxy authProvider = ProviderFactory.provider().authorizationProxy();
    private ContainerContext context;
    private ContainerPipeline pipeline;

    private ContainerManager() {
    }

    public ContainerContext start(ContainerContext context) {
        this.context = context;
        try {
            context.configuration().validate();
            this.validateContainer(context);
            this.saveContainerState();
            ContainerHandlers handlers = ProviderFactory.provider().containerHandlers();
            log.trace("managing container lifecycle with {}", handlers.get());
            this.startHandlers(handlers.get());
            context.lifecycle().moveTo(ContainerState.active);
            log.trace("loading keys for starting token ...");
            log.trace("keys loaded for starting token ...");
            return context;
        }
        catch (RuntimeException e) {
            log.error("cannot manage container (see cause)", (Throwable)e);
            if (context != null) {
                context.lifecycle().moveTo(ContainerState.failed);
            }
            throw e;
        }
    }

    private void saveContainerState() {
        File file = this.context.configuration().persistence().file("ghn.xml");
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));){
            oos.writeObject(this.context.id());
            oos.writeObject(this.context.configuration().startTokens());
        }
        catch (Exception e) {
            log.error("error serializing cointainer state");
            throw new RuntimeException(e);
        }
    }

    private void validateContainer(ContainerContext context) {
        ArrayList<String> tokensToRemove = new ArrayList<String>();
        HashSet<String> foundContexts = new HashSet<String>();
        for (String token : context.configuration().startTokens()) {
            String tokenContext = this.resolveTokenForAdd(foundContexts, token);
            if (tokenContext != null) {
                log.info("the container will be started in context {}", (Object)tokenContext);
                foundContexts.add(tokenContext);
                continue;
            }
            tokensToRemove.add(token);
        }
        if (foundContexts.isEmpty()) {
            log.error("no valid starting token are specified, moving the container to failed");
            throw new RuntimeException("no valid starting token are specified");
        }
        context.configuration().startTokens().remove(tokensToRemove);
        context.configuration().allowedContexts(foundContexts);
    }

    private String resolveTokenForAdd(Set<String> alreadyAddedContext, String token) {
        block7: {
            try {
                AuthorizationEntry entry = this.authProvider.get(token);
                ClientInfo info = entry.getClientInfo();
                if (alreadyAddedContext.contains(entry.getContext())) {
                    log.warn("the token {} cannot be used, another token with the same context {} found ", (Object)entry.getContext());
                    break block7;
                }
                if (!entry.getContext().startsWith("/" + this.context.configuration().infrastructure())) {
                    log.warn("the token {} cannot be used, is not in the infrastructure {} of the container ", (Object)token, (Object)this.context.configuration().infrastructure());
                    break block7;
                }
                if (!(info instanceof ContainerInfo)) {
                    log.warn("the token {} cannot be used, is not for a container token ", (Object)token);
                    break block7;
                }
                if (!((ContainerInfo)info).getHost().equals(this.context.configuration().hostname()) && this.context.configuration().port() != ((ContainerInfo)info).getPort()) {
                    log.warn("the token {} cannot be used, the client id {} resolved with the token is not the same of the one specified in this container  ", (Object)token, (Object)info.getId());
                    break block7;
                }
                return entry.getContext();
            }
            catch (ObjectNotFound onf) {
                log.error("token {} not valid", (Object)token);
            }
            catch (Exception e) {
                log.error("error contacting authorization for token {}", (Object)token, (Object)e);
            }
        }
        return null;
    }

    public void manage(ApplicationContext app) {
        app.events().subscribe((Object)this);
    }

    @Observes(value={"failure", "stop"}, kind=Observes.Kind.critical)
    void monitorApplication(ApplicationLifecycle lifecycle) {
        this.context.lifecycle().tryMoveTo(ContainerState.partActive);
    }

    @Observes(value={"AddTokenToContainer"}, kind=Observes.Kind.critical)
    void addToken(String token) {
        log.trace("adding token {} to container", (Object)token);
        String newContext = this.resolveTokenForAdd(this.context.configuration().allowedContexts(), token);
        if (newContext != null) {
            this.context.configuration().startTokens().add(token);
            this.context.configuration().allowedContexts().add(newContext);
            this.saveContainerState();
            this.context.events().fire((Object)token, new String[]{"AddTokenToApplication"});
            this.context.events().fire((Object)token, new String[]{"addToContext"});
            log.trace("token added and event fired");
        } else {
            log.warn("trying to add an invalid token");
        }
    }

    @Observes(value={"RemoveTokenFromContainer"}, kind=Observes.Kind.critical)
    void removeToken(String token) {
        AuthorizationEntry entry;
        log.trace("removing token {} from container", (Object)token);
        try {
            entry = this.authProvider.get(token);
        }
        catch (Exception e) {
            log.error("error resolving token to remove");
            return;
        }
        if (this.context.configuration().startTokens().contains(token)) {
            this.context.configuration().startTokens().remove(token);
            this.context.configuration().allowedContexts().remove(entry.getContext());
            this.saveContainerState();
            this.context.events().fire((Object)token, new String[]{"RemoveTokenFromApplication"});
            this.context.events().fire((Object)token, new String[]{"removeFromContext"});
            log.trace("token removed and event fired");
        } else {
            log.warn("cannot remove token, it is not present in the container");
        }
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean shutdown) {
        if (this.context == null) {
            return;
        }
        log.info("stopping container management");
        try {
            this.context.lifecycle().tryMoveTo(shutdown ? ContainerState.down : ContainerState.stopped);
            this.stopHandlers();
            log.info("stopping container events");
            this.context.events().stop();
        }
        catch (RuntimeException e) {
            log.warn("cannot stop container management (see cause)", (Throwable)e);
        }
    }

    private void startHandlers(List<ContainerHandler> handlers) {
        try {
            this.pipeline = new ContainerPipeline(handlers);
            this.pipeline.forward(new ContainerLifecycleEvent.Start(this.context));
        }
        catch (RuntimeException e) {
            this.context.lifecycle().tryMoveTo(ContainerState.failed);
            throw e;
        }
    }

    private void stopHandlers() {
        if (this.pipeline == null) {
            return;
        }
        ContainerPipeline returnPipeline = this.pipeline.reverse();
        returnPipeline.forward(new ContainerLifecycleEvent.Stop(this.context));
    }
}

