/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.deps.com.lmax.disruptor;

import com.couchbase.client.deps.com.lmax.disruptor.AlertException;
import com.couchbase.client.deps.com.lmax.disruptor.Sequence;
import com.couchbase.client.deps.com.lmax.disruptor.SequenceBarrier;
import com.couchbase.client.deps.com.lmax.disruptor.WaitStrategy;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class BlockingWaitStrategy
implements WaitStrategy {
    private final Lock lock = new ReentrantLock();
    private final Condition processorNotifyCondition = this.lock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long waitFor(long sequence, Sequence cursorSequence, Sequence dependentSequence, SequenceBarrier barrier) throws AlertException, InterruptedException {
        long availableSequence;
        if (cursorSequence.get() < sequence) {
            this.lock.lock();
            try {
                while (cursorSequence.get() < sequence) {
                    barrier.checkAlert();
                    this.processorNotifyCondition.await();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        while ((availableSequence = dependentSequence.get()) < sequence) {
            barrier.checkAlert();
        }
        return availableSequence;
    }

    @Override
    public void signalAllWhenBlocking() {
        this.lock.lock();
        try {
            this.processorNotifyCondition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public String toString() {
        return "BlockingWaitStrategy{processorNotifyCondition=" + this.processorNotifyCondition + '}';
    }
}

