/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records.aggregation;

public class AggregationConfig {
    protected static final int MAX_RECORDS_NUMBER = 1000;
    protected static final long OLD_RECORD_MAX_TIME_ELAPSED = 1800000L;
    public static final int INITIAL_DELAY = 30;
    public static final int DELAY = 30;
    private int initialDelaySet;
    private int delaySet;
    private int maxRecordsNumberSet;
    private long oldRecordMaxTimeElapsedSet;

    public static AggregationConfig getDefaultConfiguration() {
        return new AggregationConfig(30, 30, 1000, 1800000L);
    }

    public AggregationConfig(Integer initialDelaySet, Integer delaySet, int maxRecordsNumberSet, long oldRecordMaxTimeElapsedSet) {
        this.initialDelaySet = initialDelaySet;
        this.delaySet = delaySet;
        this.maxRecordsNumberSet = maxRecordsNumberSet;
        this.oldRecordMaxTimeElapsedSet = oldRecordMaxTimeElapsedSet;
    }

    public Integer getInitialDelaySet() {
        return this.initialDelaySet;
    }

    public void setInitialDelaySet(int initialDelaySet) {
        this.initialDelaySet = initialDelaySet;
    }

    public Integer getDelaySet() {
        return this.delaySet;
    }

    public void setDelaySet(int delaySet) {
        this.delaySet = delaySet;
    }

    public int getMaxRecordsNumberSet() {
        return this.maxRecordsNumberSet;
    }

    public void setMaxRecordsNumberSet(int maxRecordsNumberSet) {
        this.maxRecordsNumberSet = maxRecordsNumberSet;
    }

    public long getOldRecordMaxTimeElapsedSet() {
        return this.oldRecordMaxTimeElapsedSet;
    }

    public void setOldRecordMaxTimeElapsedSet(long oldRecordMaxTimeElapsedSet) {
        this.oldRecordMaxTimeElapsedSet = oldRecordMaxTimeElapsedSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.delaySet;
        result = 31 * result + this.initialDelaySet;
        result = 31 * result + this.maxRecordsNumberSet;
        result = 31 * result + (int)(this.oldRecordMaxTimeElapsedSet ^ this.oldRecordMaxTimeElapsedSet >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AggregationConfig other = (AggregationConfig)obj;
        if (this.delaySet != other.delaySet) {
            return false;
        }
        if (this.initialDelaySet != other.initialDelaySet) {
            return false;
        }
        if (this.maxRecordsNumberSet != other.maxRecordsNumberSet) {
            return false;
        }
        return this.oldRecordMaxTimeElapsedSet == other.oldRecordMaxTimeElapsedSet;
    }

    public String toString() {
        return "AggregationConfig [initialDelaySet=" + this.initialDelaySet + ", delaySet=" + this.delaySet + ", maxRecordsNumberSet=" + this.maxRecordsNumberSet + ", oldRecordMaxTimeElapsedSet=" + this.oldRecordMaxTimeElapsedSet + "]";
    }
}

