/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.document;

import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.java.document.AbstractDocument;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializableDocument
extends AbstractDocument<Serializable>
implements Serializable {
    private static final long serialVersionUID = 2153366534711753989L;

    public static SerializableDocument create(String id) {
        return new SerializableDocument(id, 0, null, 0L, null);
    }

    public static SerializableDocument create(String id, Serializable content) {
        return new SerializableDocument(id, 0, content, 0L, null);
    }

    public static SerializableDocument create(String id, Serializable content, long cas) {
        return new SerializableDocument(id, 0, content, cas, null);
    }

    public static SerializableDocument create(String id, int expiry, Serializable content) {
        return new SerializableDocument(id, expiry, content, 0L, null);
    }

    public static SerializableDocument create(String id, int expiry, Serializable content, long cas) {
        return new SerializableDocument(id, expiry, content, cas, null);
    }

    public static SerializableDocument create(String id, int expiry, Serializable content, long cas, MutationToken mutationToken) {
        return new SerializableDocument(id, expiry, content, cas, mutationToken);
    }

    public static SerializableDocument from(SerializableDocument doc, String id) {
        return SerializableDocument.create(id, doc.expiry(), (Serializable)doc.content(), doc.cas(), doc.mutationToken());
    }

    public static SerializableDocument from(SerializableDocument doc, Long content) {
        return SerializableDocument.create(doc.id(), doc.expiry(), content, doc.cas(), doc.mutationToken());
    }

    public static SerializableDocument from(SerializableDocument doc, String id, Long content) {
        return SerializableDocument.create(id, doc.expiry(), content, doc.cas(), doc.mutationToken());
    }

    public static SerializableDocument from(SerializableDocument doc, long cas) {
        return SerializableDocument.create(doc.id(), doc.expiry(), (Serializable)doc.content(), cas, doc.mutationToken());
    }

    private SerializableDocument(String id, int expiry, Serializable content, long cas, MutationToken mutationToken) {
        super(id, expiry, content, cas, mutationToken);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.writeToSerializedStream(stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.readFromSerializedStream(stream);
    }
}

