/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records.aggregation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.ServiceLoader;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.persistence.ExecutorUtils;
import org.gcube.documentstore.persistence.PersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.persistence.PersistenceExecutor;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.RecordUtility;
import org.gcube.documentstore.records.aggregation.AggregationConfiguration;
import org.gcube.documentstore.records.aggregation.BufferAggregationScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AggregationScheduler
implements Runnable {
    public static final Logger logger = LoggerFactory.getLogger(AggregationScheduler.class);
    public static final String AGGREGATION_SCHEDULER_TIME = "AggregationSchedulerTime";
    public static final String BUFFER_RECORD_TIME = "BufferRecordTime";
    public static final String BUFFER_RECORD_NUMBER = "BufferRecordNumber";
    public static final int RANDOM_INIT_START = 5;
    public static final long TIME_RELOAD_CONFIGURATION = 720L;
    public static final String CONFIG_DIRECTORY_NAME = "config";
    public static final String FILE_NAME = "accounting.properties";
    public static final File AGGREGATION_PROPERTIES_FILE;
    protected int totalBufferedRecords;
    protected Map<String, List<Record>> bufferedRecords;
    protected final PersistenceExecutor persistenceExecutor;
    public boolean changeConfiguration = false;
    private AggregationConfiguration config;
    protected ScheduledFuture<?> futureFlush;
    protected ScheduledFuture<?> futureReload;

    public static AggregationScheduler newInstance(PersistenceExecutor persistenceExecutor) {
        return new BufferAggregationScheduler(persistenceExecutor);
    }

    public static AggregationScheduler newInstance(PersistenceExecutor persistenceExecutor, PersistenceBackendConfiguration configuration) throws NumberFormatException, Exception {
        AggregationConfiguration config = AggregationScheduler.CheckConfiguration(configuration);
        return new BufferAggregationScheduler(persistenceExecutor, config);
    }

    protected AggregationScheduler(PersistenceExecutor persistenceExecutor) {
        this(persistenceExecutor, AggregationConfiguration.getDefaultConfiguration());
    }

    protected AggregationScheduler(PersistenceExecutor persistenceExecutor, AggregationConfiguration config) {
        this.config = config;
        this.bufferedRecords = new HashMap<String, List<Record>>();
        this.totalBufferedRecords = 0;
        this.persistenceExecutor = persistenceExecutor;
        this.schedule();
        this.reloadConfiguration();
    }

    private void schedule() {
        if (this.futureFlush != null) {
            this.futureFlush.cancel(false);
        }
        this.futureFlush = ExecutorUtils.scheduler.scheduleAtFixedRate(this, this.config.getInitialDelay(), this.config.getDelay(), AggregationConfiguration.TIME_UNIT);
    }

    protected static AggregatedRecord instantiateAggregatedRecord(Record record) throws Exception {
        String recordType = record.getRecordType();
        Class<AggregatedRecord<?, ?>> clz = RecordUtility.getAggregatedRecordClass(recordType);
        Class[] argTypes = new Class[]{record.getClass()};
        Constructor<AggregatedRecord<?, ?>> constructor = clz.getDeclaredConstructor(argTypes);
        Object[] arguments = new Object[]{record};
        return constructor.newInstance(arguments);
    }

    public static AggregatedRecord getAggregatedRecord(Record record) throws Exception {
        AggregatedRecord aggregatedRecord = record instanceof AggregatedRecord ? (AggregatedRecord)record : AggregationScheduler.instantiateAggregatedRecord(record);
        return aggregatedRecord;
    }

    protected void madeAggregation(Record record) {
        String recordType = record.getRecordType();
        if (this.bufferedRecords.containsKey(recordType)) {
            List<Record> records = this.bufferedRecords.get(recordType);
            boolean found = false;
            for (Record bufferedRecord : records) {
                if (!(bufferedRecord instanceof AggregatedRecord)) continue;
                try {
                    AggregatedRecord bufferedAggregatedRecord = (AggregatedRecord)bufferedRecord;
                    if (record instanceof AggregatedRecord) {
                        bufferedAggregatedRecord.aggregate((AggregatedRecord)record);
                    } else {
                        bufferedAggregatedRecord.aggregate(record);
                    }
                    logger.trace("Aggregated Record is {}", (Object)bufferedAggregatedRecord);
                    found = true;
                    break;
                }
                catch (NotAggregatableRecordsExceptions e) {
                    logger.trace("{} is not usable for aggregation", (Object)bufferedRecord);
                }
            }
            if (!found) {
                try {
                    records.add(AggregationScheduler.getAggregatedRecord(record));
                }
                catch (Exception e) {
                    records.add(record);
                }
                ++this.totalBufferedRecords;
                return;
            }
        } else {
            ArrayList<Record> records = new ArrayList<Record>();
            try {
                records.add(AggregationScheduler.getAggregatedRecord(record));
            }
            catch (Exception e) {
                records.add(record);
            }
            ++this.totalBufferedRecords;
            this.bufferedRecords.put(recordType, records);
        }
    }

    public void flush(PersistenceExecutor persistenceExecutor) throws Exception {
        this.aggregate(null, persistenceExecutor, true);
    }

    protected abstract void schedulerSpecificClear();

    protected void clear() {
        this.totalBufferedRecords = 0;
        this.bufferedRecords.clear();
        this.schedulerSpecificClear();
    }

    protected synchronized void aggregate(Record record, PersistenceExecutor persistenceExecutor, boolean forceFlush) throws Exception {
        if (record != null) {
            this.madeAggregation(record);
        }
        if (this.isTimeToPersist(this.config.getMaxRecordsNumber(), this.config.getMaxTimeElapsed()) || forceFlush) {
            this.reallyFlush(persistenceExecutor);
        }
    }

    protected void reallyFlush(PersistenceExecutor persistenceExecutor) throws Exception {
        if (this.totalBufferedRecords == 0) {
            return;
        }
        Object[] recordToPersist = new Record[this.totalBufferedRecords];
        int i = 0;
        Collection<List<Record>> values = this.bufferedRecords.values();
        for (List<Record> records : values) {
            for (Record thisRecord : records) {
                recordToPersist[i] = thisRecord;
                ++i;
            }
        }
        logger.trace("It is time to persist buffered records {}", (Object)Arrays.toString(recordToPersist));
        persistenceExecutor.persist((Record[])recordToPersist);
        this.clear();
    }

    public void aggregate(Record record, PersistenceExecutor persistenceExecutor) throws Exception {
        this.aggregate(record, persistenceExecutor, false);
    }

    protected abstract boolean isTimeToPersist(int var1, long var2);

    protected void reloadConfiguration() {
        Random random = new Random();
        Integer randStart = Math.abs(random.nextInt(5));
        this.futureReload = ExecutorUtils.scheduler.scheduleAtFixedRate(new ReloaderThread(this), 720L + (long)randStart.intValue(), 720L, TimeUnit.MINUTES);
    }

    protected PersistenceBackendConfiguration getConfiguration() {
        ServiceLoader<PersistenceBackend> serviceLoader = ServiceLoader.load(PersistenceBackend.class);
        PersistenceBackendConfiguration configuration = null;
        for (PersistenceBackend found : serviceLoader) {
            Class<?> foundClass = found.getClass();
            try {
                String foundClassName = foundClass.getSimpleName();
                logger.trace("getConfiguration - foundClassName {}", (Object)foundClassName);
                configuration = PersistenceBackendConfiguration.getInstance(foundClass);
                if (configuration == null) continue;
                logger.debug("{} will be used.", (Object)foundClassName);
            }
            catch (Exception e) {
                logger.error(String.format("%s not initialized correctly. It will not be used. Trying the next one if any.", foundClass.getSimpleName()), (Throwable)e);
            }
        }
        return configuration;
    }

    public static Properties getPropertiesFromFile() throws IOException {
        Properties properties = null;
        logger.trace("Looking for properties in file " + AGGREGATION_PROPERTIES_FILE.getAbsolutePath());
        try (FileInputStream inputStream = new FileInputStream(AGGREGATION_PROPERTIES_FILE);){
            if (inputStream != null) {
                properties = new Properties();
                properties.load(inputStream);
            }
        }
        catch (Exception e) {
            logger.trace("ConfigurationGetPropertyValues -property file error on input stream" + e.getLocalizedMessage());
        }
        return properties;
    }

    protected static AggregationConfiguration CheckConfiguration(PersistenceBackendConfiguration configuration) throws IOException {
        Integer maxRecordTime;
        Integer maxRecordNumber;
        Integer delay;
        block18: {
            delay = null;
            maxRecordNumber = null;
            maxRecordTime = null;
            try {
                Properties properties = AggregationScheduler.getPropertiesFromFile();
                if (properties != null) {
                    logger.trace("Configuration from properties file");
                    try {
                        delay = Integer.parseInt(properties.getProperty("delay"));
                    }
                    catch (Exception e) {
                        logger.trace("Configuration from properties file, not found a delay value");
                    }
                    try {
                        maxRecordNumber = Integer.parseInt(properties.getProperty("maxrecordnumber"));
                    }
                    catch (Exception e) {
                        logger.trace("Configuration from properties file, not found a maxRecordNumber value");
                    }
                    try {
                        maxRecordTime = Integer.parseInt(properties.getProperty("maxtimenumber")) * 1000 * 60;
                    }
                    catch (Exception e) {
                        logger.trace("Configuration from properties file, not found a maxRecordTime value");
                    }
                    break block18;
                }
                if (configuration == null) break block18;
                logger.trace("Configuration from service end point");
                try {
                    delay = Integer.parseInt(configuration.getProperty(AGGREGATION_SCHEDULER_TIME));
                }
                catch (Exception e) {
                    logger.trace("Configuration from service end point, not found delay value");
                }
                try {
                    maxRecordTime = Integer.parseInt(configuration.getProperty(BUFFER_RECORD_TIME)) * 1000 * 60;
                }
                catch (Exception e) {
                    logger.trace("Configuration from service end point, not found maxRecordTime value");
                }
                try {
                    maxRecordNumber = Integer.parseInt(configuration.getProperty(BUFFER_RECORD_NUMBER));
                }
                catch (Exception e) {
                    logger.trace("Configuration from service end point, not found maxRecordNumber value");
                }
            }
            catch (Exception e) {
                logger.error(String.format("%s not initialized correctly. It will not be used. Trying the next one if any.", e.getLocalizedMessage()), (Throwable)e);
            }
        }
        AggregationConfiguration config = AggregationConfiguration.getDefaultConfiguration();
        if (delay != null) {
            config.setDelay(delay);
            config.setInitialDelay(delay);
        }
        if (maxRecordNumber != null) {
            config.setMaxRecordsNumber(maxRecordNumber);
        }
        if (maxRecordTime != null) {
            config.setMaxTimeElapsed(maxRecordTime.intValue());
        }
        return config;
    }

    public AggregationConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(AggregationConfiguration newConfig) {
        this.config = newConfig;
    }

    @Override
    public void run() {
        try {
            this.flush(this.persistenceExecutor);
        }
        catch (Exception e) {
            logger.error("Error flushing Buffered Records", (Throwable)e);
        }
    }

    public void shutdown() {
        this.futureReload.cancel(false);
        this.run();
        this.futureFlush.cancel(true);
    }

    static {
        File file = new File(".");
        file = new File(file, CONFIG_DIRECTORY_NAME);
        AGGREGATION_PROPERTIES_FILE = new File(file, FILE_NAME);
    }

    public class ReloaderThread
    extends Thread {
        private AggregationScheduler agScheduler;

        public ReloaderThread(AggregationScheduler agScheduler) {
            this.agScheduler = agScheduler;
        }

        @Override
        public void run() {
            PersistenceBackendConfiguration configuration = AggregationScheduler.this.getConfiguration();
            try {
                AggregationConfiguration agConf = AggregationScheduler.CheckConfiguration(configuration);
                if (!this.agScheduler.config.equals(agConf)) {
                    logger.trace("reloadConfiguration changeConfiguration old config:{} newconfig:{}", (Object)this.agScheduler.config.toString(), (Object)agConf.toString());
                    this.agScheduler.setConfig(agConf);
                    this.agScheduler.run();
                    this.agScheduler.schedule();
                } else {
                    logger.trace("reloadConfiguration  no changeConfiguration");
                }
            }
            catch (IOException e) {
                logger.warn("error retrieving configuration", (Throwable)e);
            }
        }
    }
}

