/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.extensions;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.smartgears.configuration.application.Exclude;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.extensions.ApiResource;
import org.gcube.smartgears.extensions.HttpExtension;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.utils.Utils;

public class HttpController
extends HttpExtension {
    private static final long serialVersionUID = 1L;
    private final Map<String, ApiResource> resources = new HashMap<String, ApiResource>();

    HttpController() {
    }

    public HttpController(String name, String mapping) {
        super(name, mapping);
    }

    public void addResources(ApiResource ... resources) {
        Utils.notNull("API resources", resources);
        for (ApiResource resource : resources) {
            this.resources.put(resource.mapping(), resource);
        }
    }

    @Override
    public void init(ApplicationContext context) throws Exception {
        super.init(context);
        for (ApiResource resource : this.resources.values()) {
            resource.init(context);
        }
    }

    @Override
    public Set<Exclude> excludes() {
        LinkedHashSet<Exclude> resourceExcludes = new LinkedHashSet<Exclude>();
        for (ApiResource resource : this.resources.values()) {
            resourceExcludes.addAll(resource.excludes());
        }
        return resourceExcludes;
    }

    public final void service(ServletRequest req, ServletResponse resp) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(req);
        HttpServletResponse response = (HttpServletResponse)HttpServletResponse.class.cast(resp);
        ApiResource resource = this.resourceFor(request.getPathInfo());
        this.checkMethod(resource, request, response);
        this.checkContentTyperHeader(resource, request, response);
        this.checkAcceptHeader(resource, request, response);
        this.setContentTypeHeader(resource, request, response);
        this.dispatch(resource, request, response);
    }

    private void setContentTypeHeader(ApiResource resource, HttpServletRequest request, HttpServletResponse response) {
        HttpExtension.Method method = this.valueOf(request.getMethod());
        Set<String> responseTypes = resource.signature().responseTypes().get((Object)method);
        if (responseTypes.isEmpty()) {
            response.setStatus(204);
        } else if (responseTypes.size() == 1 && !response.containsHeader("Content-Type")) {
            response.addHeader("Content-Type", responseTypes.iterator().next());
        }
    }

    private ApiResource resourceFor(String path) {
        if (path == null) {
            path = "/";
        } else if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        ApiResource resource = this.resources.get(path);
        if (resource == null) {
            RequestError.resource_notfound_error.fire();
        }
        return resource;
    }

    private void checkMethod(ApiResource resource, HttpServletRequest request, HttpServletResponse response) {
        HttpExtension.Method method = this.valueOf(request.getMethod());
        if (!resource.supports(method)) {
            response.addHeader("Allow", this.toSingleString(resource.signature().methods()));
            RequestError.method_unsupported_error.fire("this resource does not support method  " + (Object)((Object)method));
        }
    }

    private void dispatch(ApiResource resource, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpExtension.Method method = this.valueOf(request.getMethod());
        switch (method) {
            case HEAD: {
                resource.doHead(request, response);
                break;
            }
            case GET: {
                resource.doGet(request, response);
                break;
            }
            case POST: {
                resource.doPost(request, response);
                break;
            }
            case PUT: {
                resource.doPut(request, response);
                break;
            }
            case DELETE: {
                resource.doDelete(request, response);
                break;
            }
            case OPTIONS: {
                resource.doOptions(request, response);
                break;
            }
            case TRACE: {
                resource.doTrace(request, response);
            }
        }
    }

    private void checkContentTyperHeader(ApiResource resource, HttpServletRequest request, HttpServletResponse response) {
        HttpExtension.Method method = this.valueOf(request.getMethod());
        String requestTypes = request.getHeader("Content-Type");
        if (requestTypes != null) {
            String type = null;
            for (String value : this.valuesOf(requestTypes)) {
                if (!resource.accepts(method, value)) continue;
                type = value;
                break;
            }
            if (type == null) {
                RequestError.incoming_contenttype_unsupported_error.fire("this resource does not accept " + requestTypes);
            }
        }
    }

    private void checkAcceptHeader(ApiResource resource, HttpServletRequest request, HttpServletResponse response) {
        HttpExtension.Method method = this.valueOf(request.getMethod());
        String responseType = request.getHeader("Accept");
        if (responseType != null) {
            String type = null;
            for (String value : this.valuesOf(responseType)) {
                if (!resource.produces(method, value)) continue;
                type = value;
                break;
            }
            if (type == null) {
                RequestError.outgoing_contenttype_unsupported_error.fire("this resource cannot produce " + responseType);
            }
        }
    }

    private String toSingleString(Collection<? extends Object> values) {
        StringBuilder builder = new StringBuilder();
        for (Object object : values) {
            builder.append(object).append(",");
        }
        String concat = builder.toString();
        return concat.substring(0, concat.length() - 1);
    }

    private String[] valuesOf(String header) {
        return header.split(",");
    }

    private HttpExtension.Method valueOf(String method) {
        try {
            return HttpExtension.Method.valueOf(method);
        }
        catch (Exception e) {
            throw RequestError.method_unsupported_error.toException("unsupported method " + method);
        }
    }
}

