/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.lifecycle;

import org.gcube.common.events.Hub;
import org.gcube.smartgears.lifecycle.Lifecycle;
import org.gcube.smartgears.lifecycle.State;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLifecycle<S extends State<S>>
implements Lifecycle<S> {
    private static final Logger log = LoggerFactory.getLogger(Lifecycle.class);
    private final Hub hub;
    private final String name;
    private S currentState;
    private S previousState;

    public DefaultLifecycle(Hub hub, String name, S startState) {
        this.hub = hub;
        this.currentState = startState;
        this.name = name;
    }

    @Override
    public S state() {
        return this.currentState;
    }

    @Override
    public void moveTo(S next) {
        if (next == this.currentState) {
            return;
        }
        if (!this.currentState.next().contains(next)) {
            throw new IllegalStateException("cannot transition " + this.name + " from " + this.currentState + " to " + next);
        }
        this.previousState = this.currentState;
        this.currentState = next;
        log.trace("{} transitioned from {} to {}", new Object[]{this.name, this.previousState, this.currentState});
        this.hub.fire((Object)this, new String[]{this.currentState.event()});
    }

    @Override
    public boolean tryMoveTo(S next) {
        try {
            this.moveTo(next);
            return true;
        }
        catch (IllegalStateException ignore) {
            return false;
        }
    }

    @Override
    public S previous() {
        return this.previousState;
    }
}

