/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SymmetricKey {
    private static Map<String, Key> keyContextMap = Collections.synchronizedMap(new HashMap());
    private static String keyAlgorithm = "AES";
    private static Logger logger = LoggerFactory.getLogger(SymmetricKey.class);

    private SymmetricKey() {
    }

    protected static synchronized Key getKey() throws InvalidKeyException {
        if (!keyContextMap.containsKey(ScopeProvider.instance.get())) {
            SymmetricKey.load(ScopeProvider.instance.get());
        }
        return keyContextMap.get(ScopeProvider.instance.get());
    }

    private static void load(String context) throws InvalidKeyException {
        byte[] rawKey;
        String keyFileName = null;
        try {
            keyFileName = SymmetricKey.getKeyFileName(context);
            InputStream is = SymmetricKey.class.getResourceAsStream("/" + keyFileName);
            rawKey = SymmetricKey.getBytesFromStream(is);
        }
        catch (Exception e) {
            logger.error("Unable to load the Key " + keyFileName + " from the classpath");
            throw new InvalidKeyException("Unable to load the Key " + keyFileName + " from the classpath");
        }
        try {
            SecretKeySpec key = new SecretKeySpec(rawKey, 0, rawKey.length, keyAlgorithm);
            keyContextMap.put(context, key);
        }
        catch (Exception e) {
            logger.error("error getting key", (Throwable)e);
            throw new InvalidKeyException();
        }
    }

    private static byte[] getBytesFromStream(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        byte[] rawKey = buffer.toByteArray();
        return rawKey;
    }

    protected static String getKeyFileName(String context) throws InvalidKeyException {
        ScopeBean bean;
        String keyFile = null;
        if (context != null) {
            bean = new ScopeBean(context);
            if (bean.is(ScopeBean.Type.VRE)) {
                bean = bean.enclosingScope();
            }
        } else {
            throw new InvalidKeyException("invalid key for scope: " + context);
        }
        String name = bean.name();
        keyFile = name + ".gcubekey";
        return keyFile;
    }
}

