/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.encryption;

import java.security.Key;
import javax.crypto.Cipher;
import javax.xml.bind.DatatypeConverter;
import org.gcube.common.encryption.IEncrypter;
import org.gcube.common.encryption.SymmetricKey;

public class StringEncrypter
implements IEncrypter<String> {
    private static StringEncrypter singleton;

    StringEncrypter() {
    }

    public static StringEncrypter getEncrypter() {
        if (singleton == null) {
            singleton = new StringEncrypter();
        }
        return singleton;
    }

    @Override
    public String encrypt(String string) throws Exception {
        Key ekey = SymmetricKey.getKey();
        return this.encrypt(string, ekey);
    }

    @Override
    public String encrypt(String string, Key ekey) throws Exception {
        Cipher cipher = Cipher.getInstance(ekey.getAlgorithm());
        cipher.init(1, ekey);
        return new String(DatatypeConverter.printBase64Binary((byte[])cipher.doFinal(string.getBytes())));
    }

    @Override
    @Deprecated
    public String encrypt(String string, Key ... key) throws Exception {
        Key ekey = key != null && key.length > 0 ? key[0] : SymmetricKey.getKey();
        return this.encrypt(string, ekey);
    }

    @Override
    public String decrypt(String string) throws Exception {
        Key dkey = SymmetricKey.getKey();
        return this.decrypt(string, dkey);
    }

    @Override
    public String decrypt(String string, Key dkey) throws Exception {
        Cipher cipher = Cipher.getInstance(dkey.getAlgorithm());
        cipher.init(2, dkey);
        return new String(cipher.doFinal(DatatypeConverter.parseBase64Binary((String)string)));
    }

    @Override
    @Deprecated
    public String decrypt(String string, Key ... key) throws Exception {
        Key dkey = key != null && key.length > 0 ? key[0] : SymmetricKey.getKey();
        return this.decrypt(string, dkey);
    }
}

