/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.context.impl.entities;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.informationsystem.base.impl.entities.EntityElementImpl;
import org.gcube.informationsystem.context.impl.relations.IsParentOfImpl;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.context.reference.relations.IsParentOf;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;

@JsonTypeName(value="Context")
public final class ContextImpl
extends EntityElementImpl
implements Context {
    private static final long serialVersionUID = -5070590328223454087L;
    protected String name;
    protected IsParentOf parent = null;
    protected List<IsParentOf> children = new ArrayList<IsParentOf>();

    protected ContextImpl() {
    }

    public ContextImpl(String name) {
        this(name, null);
    }

    public ContextImpl(String name, UUID uuid) {
        this();
        this.name = name;
        if (uuid == null) {
            uuid = UUID.randomUUID();
        }
        this.header = new HeaderImpl(uuid);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IsParentOf getParent() {
        return this.parent;
    }

    @Override
    public void setParent(UUID uuid) {
        ContextImpl parent = null;
        if (uuid != null) {
            parent = new ContextImpl();
            parent.setHeader(new HeaderImpl(uuid));
        }
        this.setParent(parent);
    }

    @Override
    public void setParent(Context context) {
        IsParentOfImpl isParentOf = null;
        if (context != null) {
            isParentOf = new IsParentOfImpl(context, this);
        }
        this.setParent(isParentOf);
    }

    @JsonSetter(value="parent")
    protected void setParentFromJson(IsParentOf isParentOf) throws JsonProcessingException {
        if (isParentOf != null) {
            Context parent = isParentOf.getSource();
            isParentOf.setTarget(this);
            ((ContextImpl)parent).addChild(isParentOf);
        }
        this.setParent(isParentOf);
    }

    @Override
    public void setParent(IsParentOf isParentOf) {
        this.parent = isParentOf;
    }

    @Override
    public List<IsParentOf> getChildren() {
        return this.children;
    }

    @JsonSetter(value="children")
    protected void setChildrenFromJson(List<IsParentOf> children) throws JsonProcessingException {
        for (IsParentOf isParentOf : children) {
            this.addChildFromJson(isParentOf);
        }
    }

    protected void addChildFromJson(IsParentOf isParentOf) throws JsonProcessingException {
        isParentOf.setSource(this);
        this.addChild(isParentOf);
    }

    @Override
    public void addChild(UUID uuid) {
        ContextImpl child = new ContextImpl();
        child.setHeader(new HeaderImpl(uuid));
        this.addChild(child);
    }

    @Override
    public void addChild(Context child) {
        IsParentOfImpl isParentOf = new IsParentOfImpl(this, child);
        this.addChild(isParentOf);
    }

    @Override
    public void addChild(IsParentOf isParentOf) {
        ((ContextImpl)isParentOf.getTarget()).setParent(this);
        this.children.add(isParentOf);
    }
}

