/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.gcube.com.fasterxml.jackson.core.JsonGenerationException;
import org.gcube.com.fasterxml.jackson.core.JsonParseException;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.DeserializationFeature;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.com.fasterxml.jackson.databind.JsonMappingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.Module;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.exc.InvalidTypeIdException;
import org.gcube.com.fasterxml.jackson.databind.module.SimpleModule;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.com.fasterxml.jackson.databind.node.TextNode;
import org.gcube.com.fasterxml.jackson.databind.type.CollectionType;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.utils.ElementDeserializer;
import org.gcube.informationsystem.utils.ElementMappingAction;
import org.gcube.informationsystem.utils.discovery.ElementSpecilizationDiscovery;
import org.gcube.informationsystem.utils.discovery.RegistrationProvider;
import org.gcube.informationsystem.utils.discovery.SchemaAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElementMapper {
    private static Logger logger;
    protected static final ObjectMapper mapper;
    protected static final Map<String, Class<? extends Element>> knownTypes;

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static void registerPackages(List<Package> packages) {
        ElementMappingAction schemaAction = new ElementMappingAction();
        try {
            ElementSpecilizationDiscovery.manageISM((SchemaAction)schemaAction, packages);
        }
        catch (Exception e) {
            logger.error("Error registering types", (Throwable)e);
        }
    }

    public static void registerPackages(Package ... packages) {
        ElementMappingAction schemaAction = new ElementMappingAction();
        try {
            ElementSpecilizationDiscovery.manageISM((SchemaAction)schemaAction, packages);
        }
        catch (Exception e) {
            logger.error("Error registering types", (Throwable)e);
        }
    }

    public static <El extends Element> void registerSubtypes(Class<El> clz, Class<El> implementationClass) {
        String typeName = TypeMapper.getType(clz);
        SimpleModule isModule = new SimpleModule(typeName);
        isModule.addDeserializer(clz, new ElementDeserializer<El>(clz, mapper));
        mapper.registerModule((Module)isModule);
        ElementMapper.registerSubtype(implementationClass);
    }

    public static <El extends Element> void registerSubtype(Class<El> clz) {
        String typeName = TypeMapper.getType(clz);
        knownTypes.put(typeName, clz);
        mapper.registerSubtypes(new Class[]{clz});
    }

    public static <T extends OutputStream, ISM extends Element> T marshal(ISM object, T stream) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(stream, object);
        return stream;
    }

    public static <T extends Writer, ISM extends Element> T marshal(ISM object, T writer) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(writer, object);
        return writer;
    }

    public static <El extends Element> String marshal(El object) throws JsonProcessingException {
        return mapper.writeValueAsString(object);
    }

    public static <El extends Element> String marshal(List<El> list) throws JsonProcessingException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, Element.class);
        return mapper.writerFor((JavaType)type).writeValueAsString(list);
    }

    public static <El extends Element> String marshal(El[] array) throws JsonProcessingException {
        return mapper.writeValueAsString(array);
    }

    public static <El extends Element> El unmarshal(Class<El> clz, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        return (El)((Element)mapper.readValue(reader, clz));
    }

    public static <El extends Element> El unmarshal(Class<El> clz, InputStream stream) throws JsonParseException, JsonMappingException, IOException {
        return (El)((Element)mapper.readValue(stream, clz));
    }

    /*
     * Unable to fully structure code
     */
    public static JsonNode analizeJsonToReplaceType(JsonNode jsonNodeToAnalize, String typeIdToReplace) throws Exception {
        block14: {
            replaced = false;
            candidatedSuperClass = null;
            index = 0;
            typeId = null;
            if (jsonNodeToAnalize.has("@class")) {
                typeId = jsonNodeToAnalize.get("@class").asText();
            }
            if (typeId == null || typeIdToReplace.compareTo(typeId) != 0 || (superClassesTreeNode = jsonNodeToAnalize.get("@superClasses")) == null || !superClassesTreeNode.isArray()) break block14;
            arrayNode = (ArrayNode)superClassesTreeNode;
            block9: for (i = 0; i < arrayNode.size(); ++i) {
                try {
                    jsonNode = arrayNode.get(i);
                    jsonNodeType = jsonNode.getNodeType();
                    switch (1.$SwitchMap$org$gcube$com$fasterxml$jackson$databind$node$JsonNodeType[jsonNodeType.ordinal()]) {
                        case 1: {
                            superClass = jsonNode.asText();
                            try {
                                Enum.valueOf(AccessType.class, superClass.toUpperCase());
                                break;
                            }
                            catch (Exception var12_15) {
                                if (!ElementMapper.knownTypes.containsKey(superClass)) ** GOTO lbl24
                                candidatedSuperClass = superClass;
                                index = i;
                            }
                        }
lbl24:
                        // 3 sources

                        default: {
                            if (candidatedSuperClass == null) continue block9;
                            break block9;
                        }
                    }
                    continue;
                }
                catch (Exception jsonNode) {
                    // empty catch block
                }
            }
            arrayNode.remove(index);
            ((ObjectNode)jsonNodeToAnalize).set("@class", (JsonNode)new TextNode(candidatedSuperClass));
            replaced = true;
        }
        if (!replaced) {
            iterator = jsonNodeToAnalize.fieldNames();
            while (iterator.hasNext()) {
                fieldName = (String)iterator.next();
                jn = jsonNodeToAnalize.get(fieldName);
                if (jn.getNodeType() != JsonNodeType.OBJECT) continue;
                try {
                    newValue = ElementMapper.analizeJsonToReplaceType(jn, typeIdToReplace);
                    replaced = true;
                    ((ObjectNode)jsonNodeToAnalize).set(fieldName, newValue);
                    break;
                }
                catch (Exception e) {
                }
            }
        }
        if (!replaced) {
            throw new Exception();
        }
        return jsonNodeToAnalize;
    }

    public static <ISM extends Element> ISM unmarshal(Class<ISM> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        try {
            return (ISM)((Element)mapper.readValue(string, clz));
        }
        catch (InvalidTypeIdException e) {
            String typeId = e.getTypeId();
            JsonNode jsonNode = mapper.readTree(string);
            try {
                jsonNode = ElementMapper.analizeJsonToReplaceType(jsonNode, typeId);
            }
            catch (Exception ex) {
                throw e;
            }
            return ElementMapper.unmarshal(clz, mapper.writeValueAsString((Object)jsonNode));
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static <ISM extends Element> ISM unmarshalWithReader(Class<ISM> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        return (ISM)((Element)mapper.readerFor(clz).readValue(string));
    }

    public static <ISM extends Element> List<ISM> unmarshalList(Class<ISM> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, clz);
        return (List)mapper.readValue(string, (JavaType)type);
    }

    public static <ISM extends Element> List<ISM> unmarshalList(String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, Element.class);
        return (List)mapper.readValue(string, (JavaType)type);
    }

    static {
        AccessType[] accessTypes;
        logger = LoggerFactory.getLogger(ElementMapper.class);
        mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        knownTypes = new HashMap<String, Class<? extends Element>>();
        ArrayList<Package> packages = new ArrayList<Package>();
        Class<Type> tdClz = Type.class;
        ElementMapper.registerSubtype(tdClz);
        packages.add(tdClz.getPackage());
        for (AccessType accessType : accessTypes = AccessType.values()) {
            Class clz = accessType.getTypeClass();
            if (Type.class.isAssignableFrom(clz)) continue;
            Class dummyClz = accessType.getDummyImplementationClass();
            if (dummyClz != null) {
                ElementMapper.registerSubtypes(clz, dummyClz);
            } else {
                ElementMapper.registerSubtype(clz);
            }
            packages.add(clz.getPackage());
        }
        ElementMapper.registerPackages(packages);
        ServiceLoader<RegistrationProvider> regsitrationProviders = ServiceLoader.load(RegistrationProvider.class);
        for (RegistrationProvider registrationProvider : regsitrationProviders) {
            ElementMapper.registerPackages(registrationProvider.getPackagesToRegister());
        }
    }
}

