/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.publisher;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.context.reference.entities.Context;
import org.gcube.informationsystem.model.reference.ERElement;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.context.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaViolationException;

public interface ResourceRegistryPublisher {
    public <ERElem extends ERElement, R extends Resource> List<R> list(Class<ERElem> var1, Boolean var2) throws ResourceRegistryException;

    public String list(String var1, Boolean var2) throws ResourceRegistryException;

    public <ERElem extends ERElement> ERElem create(ERElem var1) throws SchemaViolationException, AlreadyPresentException, ResourceRegistryException;

    public String create(String var1) throws SchemaViolationException, AlreadyPresentException, ResourceRegistryException;

    public <ERElem extends ERElement> boolean exists(Class<ERElem> var1, UUID var2) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public <ERElem extends ERElement> boolean exists(ERElem var1) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public boolean exists(String var1, UUID var2) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public <ERElem extends ERElement> ERElem read(ERElem var1) throws NotFoundException, ResourceRegistryException;

    public <ERElem extends ERElement> ERElem read(Class<ERElem> var1, UUID var2) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException;

    public String read(String var1, UUID var2) throws NotFoundException, ResourceRegistryException;

    public <ERElem extends ERElement> ERElem update(ERElem var1) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public String update(String var1) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public String update(String var1, String var2) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public String update(String var1, String var2, UUID var3) throws SchemaViolationException, AlreadyPresentException, ResourceRegistryException;

    public <ERElem extends ERElement> boolean delete(ERElem var1) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public boolean delete(String var1, UUID var2) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public <F extends Facet> F createFacet(F var1) throws SchemaViolationException, FacetAlreadyPresentException, ResourceRegistryException;

    public String createFacet(String var1) throws SchemaViolationException, FacetAlreadyPresentException, ResourceRegistryException;

    public <F extends Facet> F readFacet(F var1) throws FacetNotFoundException, ResourceRegistryException;

    public String readFacet(String var1, UUID var2) throws FacetNotFoundException, ResourceRegistryException;

    public <F extends Facet> F updateFacet(F var1) throws SchemaViolationException, FacetNotFoundException, ResourceRegistryException;

    public String updateFacet(String var1) throws SchemaViolationException, FacetNotFoundException, ResourceRegistryException;

    public <F extends Facet> boolean deleteFacet(F var1) throws SchemaViolationException, FacetNotFoundException, ResourceRegistryException;

    public boolean deleteFacet(String var1, UUID var2) throws SchemaViolationException, FacetNotFoundException, ResourceRegistryException;

    public <R extends Resource> R createResource(R var1) throws SchemaViolationException, ResourceAlreadyPresentException, ResourceRegistryException;

    public String createResource(String var1) throws SchemaViolationException, ResourceAlreadyPresentException, ResourceRegistryException;

    public <R extends Resource> R readResource(R var1) throws ResourceNotFoundException, ResourceRegistryException;

    public String readResource(String var1, UUID var2) throws ResourceNotFoundException, ResourceRegistryException;

    public <R extends Resource> R updateResource(R var1) throws SchemaViolationException, ResourceNotFoundException, ResourceRegistryException;

    public String updateResource(String var1) throws SchemaViolationException, ResourceNotFoundException, ResourceRegistryException;

    public <R extends Resource> boolean deleteResource(R var1) throws SchemaViolationException, ResourceNotFoundException, ResourceRegistryException;

    public boolean deleteResource(String var1, UUID var2) throws SchemaViolationException, ResourceNotFoundException, ResourceRegistryException;

    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C createConsistsOf(C var1) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public String createConsistsOf(String var1) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C readConsistsOf(C var1) throws NotFoundException, ResourceRegistryException;

    public String readConsistsOf(String var1, UUID var2) throws NotFoundException, ResourceRegistryException;

    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C updateConsistsOf(C var1) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public String updateConsistsOf(String var1) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> boolean deleteConsistsOf(C var1) throws SchemaViolationException, ResourceRegistryException;

    public boolean deleteConsistsOf(String var1, UUID var2) throws SchemaViolationException, ResourceRegistryException;

    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I createIsRelatedTo(I var1) throws SchemaViolationException, ResourceNotFoundException, ResourceRegistryException;

    public String createIsRelatedTo(String var1) throws SchemaViolationException, ResourceNotFoundException, ResourceRegistryException;

    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I readIsRelatedTo(I var1) throws NotFoundException, ResourceRegistryException;

    public String readIsRelatedTo(String var1, UUID var2) throws NotFoundException, ResourceRegistryException;

    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I updateIsRelatedTo(I var1) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public String updateIsRelatedTo(String var1) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> boolean deleteIsRelatedTo(I var1) throws SchemaViolationException, ResourceRegistryException;

    public boolean deleteIsRelatedTo(String var1, UUID var2) throws SchemaViolationException, ResourceRegistryException;

    public List<ERElement> addToContext(String var1, UUID var2, UUID var3) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public List<ERElement> addToContext(ERElement var1, UUID var2) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public List<ERElement> addToCurrentContext(String var1, UUID var2) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public List<ERElement> addToCurrentContext(ERElement var1) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public List<ERElement> removeFromContext(String var1, UUID var2, UUID var3) throws SchemaViolationException, NotFoundException, ResourceRegistryException;

    public List<ERElement> removeFromContext(ERElement var1, UUID var2) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeFromCurrentContext(String var1, UUID var2) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeFromCurrentContext(ERElement var1) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public Set<UUID> getElementContexts(String var1, UUID var2) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <ERElem extends ERElement> Set<UUID> getElementContexts(ERElem var1) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> addResourceToContext(String var1, UUID var2, UUID var3) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <R extends Resource> List<ERElement> addResourceToContext(R var1, UUID var2) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> addResourceToCurrentContext(String var1, UUID var2) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <R extends Resource> List<ERElement> addResourceToCurrentContext(R var1) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeResourceFromContext(String var1, UUID var2, UUID var3) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <R extends Resource> List<ERElement> removeResourceFromContext(R var1, UUID var2) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeResourceFromCurrentContext(String var1, UUID var2) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <R extends Resource> List<ERElement> removeResourceFromCurrentContext(R var1) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public Set<UUID> getResourceContexts(String var1, UUID var2) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <R extends Resource> Set<UUID> getResourceContexts(R var1) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> addFacetToContext(String var1, UUID var2, UUID var3) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <F extends Facet> List<ERElement> addFacetToContext(F var1, UUID var2) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> addFacetToCurrentContext(String var1, UUID var2) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <F extends Facet> List<ERElement> addFacetToCurrentContext(F var1) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeFacetFromContext(String var1, UUID var2, UUID var3) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <F extends Facet> List<ERElement> removeFacetFromContext(F var1, UUID var2) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public List<ERElement> removeFacetFromCurrentContext(String var1, UUID var2) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <F extends Facet> List<ERElement> removeFacetFromCurrentContext(F var1) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public Set<UUID> getFacetContexts(String var1, UUID var2) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public <F extends Facet> Set<UUID> getFacetContexts(F var1) throws FacetNotFoundException, ContextNotFoundException, ResourceRegistryException;

    public Context getContext(UUID var1) throws ContextNotFoundException, ResourceRegistryException;

    public Context getCurrentContext() throws ContextNotFoundException, ResourceRegistryException;

    public List<Context> getAllContext() throws ResourceRegistryException;
}

