/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types.impl.properties;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.types.PropertyTypeName;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.gcube.informationsystem.utils.TypeVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="PropertyDefinition")
public final class PropertyDefinitionImpl
implements PropertyDefinition {
    private static final long serialVersionUID = -5925314595659292025L;
    private static Logger logger = LoggerFactory.getLogger(PropertyDefinitionImpl.class);
    public static final String UUID_REGEX = "^([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}){1}$";
    public static final String URI_REGEX = null;
    public static final String URL_REGEX = null;
    private String name = "";
    private String description = "";
    private boolean mandatory = false;
    private boolean readonly = false;
    private boolean notnull = false;
    private Integer max = null;
    private Integer min = null;
    private String regexp = null;
    private PropertyTypeName propertyTypeName = null;

    private static String getPropertyNameFromMethodName(Method method) {
        String name = method.getName();
        if (name.startsWith("get")) {
            name = name.replace("get", "");
        }
        if (name.startsWith("is")) {
            name = name.replace("is", "");
        }
        if (name.length() > 0) {
            name = Character.toLowerCase(name.charAt(0)) + (name.length() > 1 ? name.substring(1) : "");
        }
        return name;
    }

    protected PropertyDefinitionImpl() {
    }

    public PropertyDefinitionImpl(ISProperty propertyAnnotation, Method method) {
        String name;
        this.name = name = propertyAnnotation.name().isEmpty() ? PropertyDefinitionImpl.getPropertyNameFromMethodName(method) : propertyAnnotation.name();
        this.description = propertyAnnotation.description();
        this.mandatory = propertyAnnotation.mandatory();
        this.notnull = !propertyAnnotation.nullable();
        this.readonly = propertyAnnotation.readonly();
        if (propertyAnnotation.max() > 0) {
            this.max = propertyAnnotation.max();
        }
        if (propertyAnnotation.max() >= propertyAnnotation.min() && propertyAnnotation.min() > 0) {
            this.min = propertyAnnotation.min();
        }
        this.propertyTypeName = new PropertyTypeName(method);
        Class<?> clz = method.getReturnType();
        logger.trace("Return Type for method {} is {}", (Object)method, clz);
        if (!propertyAnnotation.regexpr().isEmpty()) {
            this.regexp = propertyAnnotation.regexpr();
        }
        if (this.regexp == null || this.regexp.compareTo("") == 0) {
            if (Enum.class.isAssignableFrom(clz)) {
                ?[] constants = clz.getEnumConstants();
                StringBuilder stringBuilder = new StringBuilder("^(");
                for (int i = 0; i < constants.length; ++i) {
                    stringBuilder.append(constants[i].toString());
                    if (i >= constants.length - 1) continue;
                    stringBuilder.append("|");
                }
                stringBuilder.append(")$");
                this.regexp = stringBuilder.toString();
            }
            if (UUID.class.isAssignableFrom(clz)) {
                this.regexp = UUID_REGEX;
            }
            if (URI.class.isAssignableFrom(clz)) {
                this.regexp = URI_REGEX;
            }
            if (URL.class.isAssignableFrom(clz)) {
                this.regexp = URL_REGEX;
            }
            if (TypeVersion.class.isAssignableFrom(clz)) {
                this.regexp = "^[1-9][0-9]{0,}\\.(0|([1-9][0-9]{0,}))\\.(0|([1-9][0-9]{0,}))$";
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    public boolean isNotnull() {
        return this.notnull;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }

    @Override
    public Integer getMin() {
        return this.min;
    }

    @Override
    public String getRegexp() {
        return this.regexp;
    }

    @Override
    public String getType() {
        return this.propertyTypeName.toString();
    }

    @JsonSetter(value="type")
    public void setType(String type) {
        this.propertyTypeName = new PropertyTypeName(type);
    }

    @JsonIgnore
    public PropertyTypeName getPropertyTypeName() {
        return this.propertyTypeName;
    }

    public String toString() {
        return "Property [name=" + this.name + ", description=" + this.description + ", mandatory=" + this.mandatory + ", readonly=" + this.readonly + ", notnull=" + this.notnull + ", max=" + this.max + ", min=" + this.min + ", regexpr=" + this.regexp + ", type=" + this.propertyTypeName.toString() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.description, this.mandatory, this.max, this.min, this.name, this.notnull, this.propertyTypeName.toString(), this.readonly, this.regexp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyDefinitionImpl other = (PropertyDefinitionImpl)obj;
        return Objects.equals(this.description, other.description) && this.mandatory == other.mandatory && Objects.equals(this.max, other.max) && Objects.equals(this.min, other.min) && Objects.equals(this.name, other.name) && this.notnull == other.notnull && Objects.equals(this.propertyTypeName.toString(), other.propertyTypeName.toString()) && this.readonly == other.readonly && Objects.equals(this.regexp, other.regexp);
    }
}

