/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.utils.secret;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.ClientType;
import org.gcube.common.authorization.library.exception.AuthorizationException;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.authorization.utils.socialservice.SocialService;
import org.gcube.common.authorization.utils.user.GCubeUser;
import org.gcube.common.authorization.utils.user.User;

public class GCubeSecret
extends Secret {
    public static final String GCUBE_TOKEN_REGEX = "^([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}-[a-fA-F0-9]{8,9}){1}$";
    protected AuthorizationEntry authorizationEntry;

    @Override
    protected void check(String token) throws AuthorizationException {
        super.check(token);
        if (!Pattern.matches(GCUBE_TOKEN_REGEX, token)) {
            throw new AuthorizationException("The GUCBE token must comply with the regex ^([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}-[a-fA-F0-9]{8,9}){1}$");
        }
    }

    public GCubeSecret(String token) {
        super(20, token);
    }

    protected AuthorizationEntry getAuthorizationEntry() throws Exception {
        if (this.authorizationEntry == null) {
            this.authorizationEntry = Constants.authorizationService().get(this.token);
        }
        return this.authorizationEntry;
    }

    @Override
    public void setToken() throws Exception {
        SecurityTokenProvider.instance.set(this.token);
    }

    @Override
    public void resetToken() throws Exception {
        SecurityTokenProvider.instance.reset();
    }

    @Override
    public ClientInfo getClientInfo() throws Exception {
        return this.getAuthorizationEntry().getClientInfo();
    }

    @Override
    public Caller getCaller() throws Exception {
        ClientInfo clientInfo = this.getClientInfo();
        String qualifier = this.authorizationEntry.getQualifier();
        Caller caller = new Caller(clientInfo, qualifier);
        return caller;
    }

    @Override
    public String getContext() throws Exception {
        return this.getAuthorizationEntry().getContext();
    }

    @Override
    public Map<String, String> getHTTPAuthorizationHeaders() {
        HashMap<String, String> authorizationHeaders = new HashMap<String, String>();
        authorizationHeaders.put("gcube-token", this.token);
        return authorizationHeaders;
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    @Override
    public boolean isRefreshable() {
        return false;
    }

    @Override
    public User getUser() {
        if (this.user == null) {
            try {
                ClientInfo clientInfo = this.getClientInfo();
                ClientType clientType = clientInfo.getType();
                switch (clientType) {
                    case USER: {
                        this.user = SocialService.getSocialService().getUser(this);
                        break;
                    }
                    default: {
                        GCubeUser gCubeUser = new GCubeUser();
                        gCubeUser.setRoles(new HashSet<String>(clientInfo.getRoles()));
                        gCubeUser.setUsername(clientInfo.getId());
                        this.user = gCubeUser;
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
        return this.user;
    }
}

