/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.discovery;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.discovery.DiscoveredElementAction;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.utils.ReflectionUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Discovery<E extends Element> {
    public static Logger logger = LoggerFactory.getLogger(Discovery.class);
    protected final Class<E> root;
    protected final Set<Package> packages;
    protected final List<Class<E>> discoveredElements;
    protected final List<DiscoveredElementAction<Element>> discoveredElementActions;
    protected boolean discovered;

    public Discovery(Class<E> root) throws Exception {
        this.root = root;
        this.packages = new HashSet<Package>();
        this.discovered = false;
        this.discoveredElements = new ArrayList<Class<E>>();
        this.discoveredElementActions = new ArrayList<DiscoveredElementAction<Element>>();
        this.add(root);
    }

    public List<Class<E>> getDiscoveredElements() {
        return this.discoveredElements;
    }

    public synchronized void addDiscoveredElementActions(DiscoveredElementAction<Element> discoveredElementAction) throws Exception {
        this.discoveredElementActions.add(discoveredElementAction);
        if (this.discovered) {
            for (Class<E> clz : this.discoveredElements) {
                discoveredElementAction.analizeElement(clz);
            }
        }
    }

    public synchronized void executeDiscoveredElementActions(DiscoveredElementAction<Element> discoveredElementAction) throws Exception {
        if (this.discovered) {
            for (Class<E> clz : this.discoveredElements) {
                discoveredElementAction.analizeElement(clz);
            }
        }
    }

    public void addPackage(Package p) {
        this.packages.add(p);
    }

    public void addPackages(Collection<Package> packages) {
        for (Package p : packages) {
            this.addPackage(p);
        }
    }

    protected void add(Class<E> clz) throws Exception {
        if (!this.discoveredElements.contains(clz)) {
            this.discoveredElements.add(clz);
            for (DiscoveredElementAction<Element> discoveredElementAction : this.discoveredElementActions) {
                discoveredElementAction.analizeElement(clz);
            }
            logger.info("+ Added {}.", clz);
        }
    }

    protected void analizeElement(Class<E> clz) throws Exception {
        logger.trace("Analizyng {}", clz);
        if (!clz.isInterface()) {
            logger.trace("- Discarding {} because is not an interface", clz);
            return;
        }
        if (!this.root.isAssignableFrom(clz)) {
            logger.trace("- Discarding {} because is not a {}", clz, (Object)this.root.getSimpleName());
            return;
        }
        if (this.discoveredElements.contains(clz)) {
            logger.trace("- Discarding {} because was already managed", clz);
            return;
        }
        Class<?>[] interfaces = clz.getInterfaces();
        GenericDeclaration[] genericDeclarationArray = interfaces;
        int n = genericDeclarationArray.length;
        for (int i = 0; i < n; ++i) {
            Class<?> clazz;
            Class<?> parent = clazz = genericDeclarationArray[i];
            this.analizeElement(parent);
        }
        if (this.root == PropertyElement.class) {
            for (GenericDeclaration genericDeclaration : clz.getDeclaredMethods()) {
                ((Method)genericDeclaration).setAccessible(true);
                if (!((AccessibleObject)((Object)genericDeclaration)).isAnnotationPresent(ISProperty.class)) continue;
                if (Map.class.isAssignableFrom(((Method)genericDeclaration).getReturnType()) || Set.class.isAssignableFrom(((Method)genericDeclaration).getReturnType()) || List.class.isAssignableFrom(((Method)genericDeclaration).getReturnType())) {
                    Type[] typeArguments;
                    for (Type t : typeArguments = ((ParameterizedType)((Method)genericDeclaration).getGenericReturnType()).getActualTypeArguments()) {
                        Class tClass = (Class)t;
                        if (!this.root.isAssignableFrom(tClass)) continue;
                        Class type = tClass;
                        this.analizeElement(type);
                    }
                    continue;
                }
                if (!this.root.isAssignableFrom(((Method)genericDeclaration).getReturnType())) continue;
                Class<?> eClz = ((Method)genericDeclaration).getReturnType();
                this.analizeElement(eClz);
            }
        }
        this.add(clz);
    }

    public synchronized void discover() throws Exception {
        this.discovered = false;
        for (Package p : this.packages) {
            List<Class<?>> classes = ReflectionUtility.getClassesForPackage(p);
            Iterator<Class<?>> iterator = classes.iterator();
            while (iterator.hasNext()) {
                Class<?> clz;
                Class<?> eClz = clz = iterator.next();
                this.analizeElement(eClz);
            }
        }
        this.discovered = true;
    }
}

