/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.model.reference.properties;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.impl.properties.PropagationConstraintImpl;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.types.annotations.Final;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.Changelog;
import org.gcube.informationsystem.types.reference.TypeMetadata;

@JsonDeserialize(as=PropagationConstraintImpl.class)
@TypeMetadata(name="PropagationConstraint", description="This type provides propagation constraint for Relation", version="1.1.0")
@Changelog(value={@Change(version="1.1.0", description="Added 'delete' propagation constraint"), @Change(version="1.0.0", description="First Version")})
@Final
public interface PropagationConstraint
extends Property {
    public static final String NAME = "PropagationConstraint";
    public static final String DELETE_PROPERTY = "delete";
    public static final String REMOVE_PROPERTY = "remove";
    public static final String ADD_PROPERTY = "add";

    @ISProperty(name="delete", description="It indicates the behaviour to implement for the target Entity when a 'delete' action is performed on the source Resource. Delet action  is the operation of deleting an instance (it has an impact on all contexts).", mandatory=true, nullable=false)
    public DeleteConstraint getDeleteConstraint();

    public void setDeleteConstraint(DeleteConstraint var1);

    @ISProperty(name="remove", description="It indicates the behaviour to implement for the target Entity when a 'remove' action is performed on the source Resource. Remove actions is the operation of removing an instance from a context.", mandatory=true, nullable=false)
    public RemoveConstraint getRemoveConstraint();

    public void setRemoveConstraint(RemoveConstraint var1);

    @ISProperty(name="add", description="It indicates the behaviour to implement for the target Entity when an 'add' action is performed on the source Resource. Add action is the operation of adding an instance to a context.", mandatory=true, nullable=false)
    public AddConstraint getAddConstraint();

    public void setAddConstraint(AddConstraint var1);

    public static enum AddConstraint {
        propagate,
        unpropagate;

    }

    public static enum RemoveConstraint {
        cascadeWhenOrphan,
        cascade,
        keep;

    }

    public static enum DeleteConstraint {
        cascadeWhenOrphan,
        cascade,
        keep;

    }
}

