/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.discovery.knowledge;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;

public class UsageKnowledge {
    protected Map<String, Set<LinkedEntity>> map = new LinkedHashMap<String, Set<LinkedEntity>>();

    protected void add(String typeName, LinkedEntity linkedEntity) {
        Set<LinkedEntity> list = this.map.get(typeName);
        if (list == null) {
            list = new TreeSet<LinkedEntity>();
            this.map.put(typeName, list);
        }
        list.add(linkedEntity);
    }

    public void add(LinkedEntity linkedEntity) {
        if (linkedEntity != null) {
            String source = linkedEntity.getSource();
            this.add(source, linkedEntity);
            String relation = linkedEntity.getRelation();
            this.add(relation, linkedEntity);
            String target = linkedEntity.getTarget();
            this.add(target, linkedEntity);
        }
    }

    public void addAll(Collection<LinkedEntity> linkedEntities) {
        if (linkedEntities != null) {
            for (LinkedEntity le : linkedEntities) {
                this.add(le);
            }
        }
    }

    public Set<LinkedEntity> getUsage(String typeName) {
        Set<LinkedEntity> list = this.map.get(typeName);
        return list;
    }
}

