/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.discovery.knowledge;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.discovery.Discovery;
import org.gcube.informationsystem.discovery.knowledge.AddElementToTreeAction;
import org.gcube.informationsystem.discovery.knowledge.ClassInformation;
import org.gcube.informationsystem.discovery.knowledge.UsageKnowledge;
import org.gcube.informationsystem.serialization.ElementMappingAction;
import org.gcube.informationsystem.tree.Tree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelKnowledge {
    private static final Logger logger = LoggerFactory.getLogger(ModelKnowledge.class);
    protected boolean created;
    protected Map<AccessType, UsageKnowledge> usageKnowledges;
    protected Map<AccessType, Tree<Class<Element>>> trees;
    protected Map<AccessType, Discovery<Element>> discoveries;
    protected Set<Package> packages = new HashSet<Package>();

    public ModelKnowledge() {
        this.reset();
    }

    private void reset() {
        this.created = false;
        this.usageKnowledges = new HashMap<AccessType, UsageKnowledge>();
        this.trees = new HashMap<AccessType, Tree<Class<Element>>>();
        this.discoveries = new HashMap<AccessType, Discovery<Element>>();
    }

    public UsageKnowledge getUsageKnowledge(AccessType accessType) {
        if (!this.created) {
            throw new RuntimeException("You must invoke createKnowledge() first");
        }
        return this.usageKnowledges.get((Object)accessType);
    }

    public synchronized void createKnowledge(boolean force) throws Exception {
        if (force) {
            logger.info("Going to force Knowledge recreation");
            this.reset();
        }
        this.createKnowledge();
    }

    public void addPackages(Collection<Package> packages) {
        this.packages.addAll(packages);
    }

    public synchronized void createKnowledge() throws Exception {
        if (this.created) {
            logger.trace("Knowledge has been already created.");
            return;
        }
        AccessType[] modelTypes = AccessType.getModelTypes();
        ClassInformation classInformation = new ClassInformation();
        for (AccessType accessType : modelTypes) {
            Class clz = accessType.getTypeClass();
            Tree<Class<Element>> tree = new Tree<Class<Element>>(clz, classInformation);
            this.trees.put(accessType, tree);
            AddElementToTreeAction aetta = new AddElementToTreeAction(tree);
            if (accessType == AccessType.RESOURCE) {
                UsageKnowledge facetKnowledge = new UsageKnowledge();
                this.usageKnowledges.put(AccessType.FACET, facetKnowledge);
                aetta.setFacetKnowledge(facetKnowledge);
                UsageKnowledge resourceKnowledge = new UsageKnowledge();
                this.usageKnowledges.put(AccessType.RESOURCE, resourceKnowledge);
                aetta.setResourceKnowledge(resourceKnowledge);
            }
            Discovery discovery = new Discovery(clz);
            this.discoveries.put(accessType, discovery);
            discovery.addPackages(this.packages);
            discovery.addDiscoveredElementActions(new ElementMappingAction());
            discovery.addDiscoveredElementActions(aetta);
            discovery.discover();
        }
        this.created = true;
    }

    public synchronized Tree<Class<Element>> getClassesTree(AccessType accessType) {
        return this.trees.get((Object)accessType);
    }

    public synchronized Discovery<Element> getDiscovery(AccessType accessType) {
        return this.discoveries.get((Object)accessType);
    }
}

