/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.publisher;

import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.common.context.ContextUtility;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.http.GXHTTPUtility;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.model.reference.ERElement;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCache;
import org.gcube.informationsystem.resourceregistry.api.contexts.ContextCacheRenewal;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.facet.FacetAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.facet.FacetAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.consistsof.ConsistsOfAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.consistsof.ConsistsOfAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.consistsof.ConsistsOfNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isrelatedto.IsRelatedToAlreadyPresentException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isrelatedto.IsRelatedToAvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.relations.isrelatedto.IsRelatedToNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.types.SchemaViolationException;
import org.gcube.informationsystem.resourceregistry.api.rest.SharingPath;
import org.gcube.informationsystem.resourceregistry.api.rest.httputils.HTTPUtility;
import org.gcube.informationsystem.resourceregistry.api.utils.Utility;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.utils.UUIDManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryPublisherImpl
implements ResourceRegistryPublisher {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryPublisherImpl.class);
    private static final String ACCEPT_HTTP_HEADER_KEY = "Accept";
    private static final String CONTENT_TYPE_HTTP_HEADER_KEY = "Content-Type";
    protected final String address;
    protected Map<String, String> headers;
    protected boolean hierarchicalMode;
    protected boolean includeContextsInHeader;
    protected ContextCacheRenewal contextCacheRenewal = new ContextCacheRenewal(){

        public List<Context> renew() throws ResourceRegistryException {
            return ResourceRegistryPublisherImpl.this.getAllContextFromServer();
        }
    };

    @Override
    public boolean isHierarchicalMode() {
        return this.hierarchicalMode;
    }

    @Override
    public void setHierarchicalMode(boolean hierarchicalMode) {
        this.hierarchicalMode = hierarchicalMode;
    }

    @Override
    public boolean isIncludeContextsInHeader() {
        return this.includeContextsInHeader;
    }

    @Override
    public void setIncludeContextsInHeader(boolean includeContextsInHeader) {
        this.includeContextsInHeader = includeContextsInHeader;
    }

    private GXHTTPStringRequest includeAdditionalQueryParameters(GXHTTPStringRequest gxHTTPStringRequest) throws UnsupportedEncodingException {
        return this.includeAdditionalQueryParameters(gxHTTPStringRequest, null);
    }

    private GXHTTPStringRequest includeAdditionalQueryParameters(GXHTTPStringRequest gxHTTPStringRequest, Map<String, String> queryParams) throws UnsupportedEncodingException {
        gxHTTPStringRequest = this.checkHierarchicalMode(gxHTTPStringRequest, queryParams);
        return this.checkIncludeContextsInInstanceHeader(gxHTTPStringRequest, queryParams);
    }

    private GXHTTPStringRequest checkHierarchicalMode(GXHTTPStringRequest gxHTTPStringRequest, Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (this.hierarchicalMode) {
            if (queryParams == null) {
                queryParams = new HashMap<String, String>();
            }
            queryParams.put("hierarchical", Boolean.toString(this.hierarchicalMode));
        }
        return gxHTTPStringRequest.queryParams(queryParams);
    }

    private GXHTTPStringRequest checkIncludeContextsInInstanceHeader(GXHTTPStringRequest gxHTTPStringRequest, Map<String, String> queryParams) throws UnsupportedEncodingException {
        if (this.includeContextsInHeader) {
            if (queryParams == null) {
                queryParams = new HashMap<String, String>();
            }
            queryParams.put("includeContextsInHeader", Boolean.toString(this.includeContextsInHeader));
        }
        return gxHTTPStringRequest.queryParams(queryParams);
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    protected GXHTTPStringRequest getGXHTTPStringRequest() {
        GXHTTPStringRequest gxHTTPStringRequest = GXHTTPUtility.getGXHTTPStringRequest((String)this.address);
        gxHTTPStringRequest.from(this.getClass().getSimpleName());
        for (String name : this.headers.keySet()) {
            gxHTTPStringRequest.header(name, this.headers.get(name));
        }
        return gxHTTPStringRequest;
    }

    public ResourceRegistryPublisherImpl(String address) {
        this.address = address;
        this.headers = new HashMap<String, String>();
        ContextCache contextCache = ContextCache.getInstance();
        contextCache.setContextCacheRenewal(this.contextCacheRenewal);
    }

    public List<Context> getAllContextFromServer() throws ResourceRegistryException {
        try {
            logger.info("Going to read all {}s", (Object)"Context");
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("contexts");
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got Contexts are {}", (Object)ret);
            return ElementMapper.unmarshalList(Context.class, (String)ret);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Context> getAllContext() throws ResourceRegistryException {
        ContextCache contextCache = ContextCache.getInstance();
        return contextCache.getContexts();
    }

    protected Context getContextFromServer(String id) throws ContextNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get current {} ", (Object)"Context");
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(id);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            Context context = (Context)HTTPUtility.getResponse(Context.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got Context is {}", (Object)ElementMapper.marshal((Element)context));
            return context;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Context getContext(UUID uuid) throws ContextNotFoundException, ResourceRegistryException {
        ContextCache contextCache = ContextCache.getInstance();
        Context context = ContextCache.getInstance().getContextByUUID(uuid);
        if (context == null) {
            context = this.getContextFromServer(uuid.toString());
            contextCache.cleanCache();
            contextCache.refreshContextsIfNeeded();
            Context c = contextCache.getContextByUUID(context.getHeader().getUUID());
            if (c != null) {
                context = c;
            } else {
                logger.error("Context with UUID {} is {}. It is possibile to get it from the server but not from the cache. This is very strange and should not occur.", (Object)uuid, (Object)context);
            }
        }
        return context;
    }

    @Override
    public Context getCurrentContext() throws ContextNotFoundException, ResourceRegistryException {
        String contextFullName = ContextUtility.getCurrentContextFullName();
        ContextCache contextCache = ContextCache.getInstance();
        UUID uuid = contextCache.getUUIDByFullName(contextFullName);
        Context context = null;
        if (uuid == null) {
            context = this.getContextFromServer("CURRENT_CONTEXT");
            contextCache.cleanCache();
            contextCache.refreshContextsIfNeeded();
            Context c = contextCache.getContextByUUID(context.getHeader().getUUID());
            if (c != null) {
                context = c;
            } else {
                logger.error("Current Context is {}. It is possibile to get it from the server but not from the cache. This is very strange and should not occur.", (Object)contextFullName);
            }
        } else {
            context = contextCache.getContextByUUID(uuid);
        }
        return context;
    }

    private UUID getCurrentContextUUID() throws ResourceRegistryException {
        return this.getCurrentContext().getHeader().getUUID();
    }

    @Override
    public <ERElem extends ERElement> List<ERElem> list(Class<ERElem> clazz, Boolean polymorphic) throws ResourceRegistryException {
        String type = Utility.getTypeName(clazz);
        String ret = this.list(type, polymorphic);
        try {
            return ElementMapper.unmarshalList(ERElement.class, (String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String list(String type, Boolean polymorphic) throws ResourceRegistryException {
        try {
            logger.info("Going to get all instances of {} ", (Object)type);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("polymorphic", polymorphic.toString());
            this.includeAdditionalQueryParameters(gxHTTPStringRequest, parameters);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got instances of {} are {}", (Object)type, (Object)ret);
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String create(String type, String json, UUID uuid) throws SchemaViolationException, AlreadyPresentException, ResourceRegistryException {
        try {
            logger.trace("Going to create {} : {}", (Object)type, (Object)json);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.header(CONTENT_TYPE_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(json);
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} successfully created", (Object)ret);
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <ERElem extends ERElement> String internalCreate(ERElem er) throws SchemaViolationException, AlreadyPresentException, ResourceRegistryException {
        try {
            String type = Utility.getTypeName(er);
            String json = ElementMapper.marshal(er);
            Header header = er.getHeader();
            if (header == null) {
                UUID randomUUID = UUIDManager.generateValidRandomUUID();
                header = new HeaderImpl(randomUUID);
                er.setHeader(header);
            }
            UUID uuid = er.getHeader().getUUID();
            return this.create(type, json, uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERElem extends ERElement> ERElem create(ERElem er) throws SchemaViolationException, AlreadyPresentException, ResourceRegistryException {
        try {
            String ret = this.internalCreate(er);
            return (ERElem)((ERElement)ElementMapper.unmarshal(ERElement.class, (String)ret));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String create(String json) throws SchemaViolationException, AlreadyPresentException, ResourceRegistryException {
        try {
            ERElement e = (ERElement)ElementMapper.unmarshal(ERElement.class, (String)json);
            return this.internalCreate(e);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERElem extends ERElement> boolean exist(ERElem er) throws AvailableInAnotherContextException, ResourceRegistryException {
        String type = Utility.getTypeName(er);
        UUID uuid = er.getHeader().getUUID();
        return this.exist(type, uuid);
    }

    @Override
    public <ERElem extends ERElement> boolean exist(Class<ERElem> clazz, UUID uuid) throws AvailableInAnotherContextException, ResourceRegistryException {
        String type = Utility.getTypeName(clazz);
        return this.exist(type, uuid);
    }

    @Override
    public boolean exist(String type, UUID uuid) throws AvailableInAnotherContextException, ResourceRegistryException {
        try {
            logger.info("Going to check if {} with UUID {} exists", (Object)type, (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("access");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            gxHTTPStringRequest.path(uuid.toString());
            this.includeAdditionalQueryParameters(gxHTTPStringRequest);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.head();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("{} with UUID {} exists", (Object)type, (Object)uuid);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERElem extends ERElement> ERElem read(ERElem er) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            String type = Utility.getTypeName(er);
            UUID uuid = er.getHeader().getUUID();
            String ret = this.read(type, uuid);
            return (ERElem)((ERElement)ElementMapper.unmarshal(ERElement.class, (String)ret));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERElem extends ERElement> ERElem read(Class<ERElem> clazz, UUID uuid) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            String type = Utility.getTypeName(clazz);
            String ret = this.read(type, uuid);
            return (ERElem)((ERElement)ElementMapper.unmarshal(ERElement.class, (String)ret));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String read(String type, UUID uuid) throws NotFoundException, AvailableInAnotherContextException, ResourceRegistryException {
        try {
            logger.trace("Going to read {} with UUID {}", (Object)type, (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            gxHTTPStringRequest.path(uuid.toString());
            this.includeAdditionalQueryParameters(gxHTTPStringRequest);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.debug("Got {} with UUID {} is {}", new Object[]{type, uuid, ret});
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERElem extends ERElement> ERElem update(ERElem er) throws SchemaViolationException, NotFoundException, ResourceRegistryException {
        try {
            String type = Utility.getTypeName(er);
            String json = ElementMapper.marshal(er);
            UUID uuid = er.getHeader().getUUID();
            String ret = this.update(type, json, uuid);
            return (ERElem)((ERElement)ElementMapper.unmarshal(ERElement.class, (String)ret));
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String json) throws SchemaViolationException, NotFoundException, ResourceRegistryException {
        try {
            String type = Utility.getClassFromJsonString((String)json);
            return this.update(type, json);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String type, String json) throws SchemaViolationException, NotFoundException, ResourceRegistryException {
        try {
            UUID uuid = org.gcube.informationsystem.utils.Utility.getUUIDFromJSONString((String)json);
            return this.update(type, json, uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String update(String type, String json, UUID uuid) throws SchemaViolationException, NotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to create {} : {}", (Object)type, (Object)json);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.header(CONTENT_TYPE_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.put(json);
            String ret = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.trace("{} with UUID {} successfully created : {}", new Object[]{type, uuid, ret});
            return ret;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERElem extends ERElement> boolean delete(ERElem er) throws SchemaViolationException, NotFoundException, ResourceRegistryException {
        try {
            String type = Utility.getTypeName(er);
            UUID uuid = er.getHeader().getUUID();
            return this.delete(type, uuid);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(String type, UUID uuid) throws SchemaViolationException, NotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to delete {} with UUID {}", (Object)type, (Object)uuid);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.header(ACCEPT_HTTP_HEADER_KEY, "application/json;charset=UTF-8");
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            gxHTTPStringRequest.path(uuid.toString());
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.delete();
            HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            boolean deleted = true;
            logger.info("{} with UUID {} {}", new Object[]{type, uuid, deleted ? " successfully deleted" : "was NOT deleted"});
            return deleted;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <F extends Facet> F createFacet(F facet) throws SchemaViolationException, FacetAlreadyPresentException, ResourceRegistryException {
        return this.create((ERElement)facet);
    }

    @Override
    public String createFacet(String facet) throws SchemaViolationException, FacetAlreadyPresentException, ResourceRegistryException {
        return this.create(facet);
    }

    @Override
    public <F extends Facet> F readFacet(F facet) throws FacetNotFoundException, FacetAvailableInAnotherContextException, ResourceRegistryException {
        return this.read((ERElement)facet);
    }

    @Override
    public String readFacet(String facetType, UUID uuid) throws FacetNotFoundException, FacetAvailableInAnotherContextException, ResourceRegistryException {
        return this.read(facetType, uuid);
    }

    @Override
    public <F extends Facet> F updateFacet(F facet) throws SchemaViolationException, FacetNotFoundException, ResourceRegistryException {
        return this.update((ERElement)facet);
    }

    @Override
    public String updateFacet(String facet) throws SchemaViolationException, FacetNotFoundException, ResourceRegistryException {
        return this.update(facet);
    }

    @Override
    public <F extends Facet> boolean deleteFacet(F facet) throws SchemaViolationException, FacetNotFoundException, ResourceRegistryException {
        return this.delete((ERElement)facet);
    }

    @Override
    public boolean deleteFacet(String facetType, UUID uuid) throws SchemaViolationException, FacetNotFoundException, ResourceRegistryException {
        return this.delete(facetType, uuid);
    }

    @Override
    public <R extends Resource> R createResource(R resource) throws SchemaViolationException, ResourceAlreadyPresentException, ResourceRegistryException {
        return this.create((ERElement)resource);
    }

    @Override
    public String createResource(String resource) throws SchemaViolationException, ResourceAlreadyPresentException, ResourceRegistryException {
        return this.create(resource);
    }

    @Override
    public <R extends Resource> R readResource(R resource) throws ResourceNotFoundException, ResourceAvailableInAnotherContextException, ResourceRegistryException {
        return this.read((ERElement)resource);
    }

    @Override
    public String readResource(String resourceType, UUID uuid) throws ResourceNotFoundException, ResourceAvailableInAnotherContextException, ResourceRegistryException {
        return this.read(resourceType, uuid);
    }

    @Override
    public <R extends Resource> R updateResource(R resource) throws SchemaViolationException, ResourceNotFoundException, ResourceRegistryException {
        return this.update((ERElement)resource);
    }

    @Override
    public String updateResource(String resource) throws SchemaViolationException, ResourceNotFoundException, ResourceRegistryException {
        return this.update(resource);
    }

    @Override
    public <R extends Resource> boolean deleteResource(R resource) throws ResourceNotFoundException, ResourceRegistryException {
        return this.delete((ERElement)resource);
    }

    @Override
    public boolean deleteResource(String resourceType, UUID uuid) throws ResourceNotFoundException, ResourceRegistryException {
        return this.delete(resourceType, uuid);
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C createConsistsOf(C consistsOf) throws SchemaViolationException, ConsistsOfAlreadyPresentException, ResourceNotFoundException, ResourceRegistryException {
        return this.create((ERElement)consistsOf);
    }

    @Override
    public String createConsistsOf(String consistsOf) throws SchemaViolationException, ConsistsOfAlreadyPresentException, ResourceNotFoundException, ResourceRegistryException {
        return this.create(consistsOf);
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C readConsistsOf(C consistsOf) throws ConsistsOfNotFoundException, ConsistsOfAvailableInAnotherContextException, ResourceRegistryException {
        return this.read((ERElement)consistsOf);
    }

    @Override
    public String readConsistsOf(String consistsOfType, UUID uuid) throws ConsistsOfNotFoundException, ConsistsOfAvailableInAnotherContextException, ResourceRegistryException {
        return this.read(consistsOfType, uuid);
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> C updateConsistsOf(C consistsOf) throws SchemaViolationException, ConsistsOfNotFoundException, ResourceRegistryException {
        return this.update((ERElement)consistsOf);
    }

    @Override
    public String updateConsistsOf(String consistsOf) throws SchemaViolationException, ConsistsOfNotFoundException, ResourceRegistryException {
        return this.update(consistsOf);
    }

    @Override
    public <C extends ConsistsOf<? extends Resource, ? extends Facet>> boolean deleteConsistsOf(C consistsOf) throws SchemaViolationException, ConsistsOfNotFoundException, ResourceRegistryException {
        return this.delete((ERElement)consistsOf);
    }

    @Override
    public boolean deleteConsistsOf(String consistsOfType, UUID uuid) throws SchemaViolationException, ConsistsOfNotFoundException, ResourceRegistryException {
        return this.delete(consistsOfType, uuid);
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I createIsRelatedTo(I isRelatedTo) throws SchemaViolationException, IsRelatedToAlreadyPresentException, ResourceNotFoundException, ResourceRegistryException {
        return this.create((ERElement)isRelatedTo);
    }

    @Override
    public String createIsRelatedTo(String isRelatedTo) throws SchemaViolationException, IsRelatedToAlreadyPresentException, ResourceNotFoundException, ResourceRegistryException {
        return this.create(isRelatedTo);
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I readIsRelatedTo(I isRelatedTo) throws IsRelatedToNotFoundException, IsRelatedToAvailableInAnotherContextException, ResourceRegistryException {
        return this.read((ERElement)isRelatedTo);
    }

    @Override
    public String readIsRelatedTo(String isRelatedToType, UUID uuid) throws IsRelatedToNotFoundException, IsRelatedToAvailableInAnotherContextException, ResourceRegistryException {
        return this.read(isRelatedToType, uuid);
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> I updateIsRelatedTo(I isRelatedTo) throws SchemaViolationException, IsRelatedToNotFoundException, ResourceRegistryException {
        return this.update((ERElement)isRelatedTo);
    }

    @Override
    public String updateIsRelatedTo(String isRelatedTo) throws SchemaViolationException, IsRelatedToNotFoundException, ResourceRegistryException {
        return this.update(isRelatedTo);
    }

    @Override
    public <I extends IsRelatedTo<? extends Resource, ? extends Resource>> boolean deleteIsRelatedTo(I isRelatedTo) throws IsRelatedToNotFoundException, ResourceRegistryException {
        return this.delete((ERElement)isRelatedTo);
    }

    @Override
    public boolean deleteIsRelatedTo(String isRelatedToType, UUID uuid) throws IsRelatedToNotFoundException, ResourceRegistryException {
        return this.delete(isRelatedToType, uuid);
    }

    @Override
    public List<ERElement> addToContext(String type, UUID instanceUUID, UUID contextUUID, Boolean dryRun) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to add {} with UUID {} to {} with UUID {} ", new Object[]{type, instanceUUID, "Context", contextUUID});
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.path("sharing");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(contextUUID.toString());
            gxHTTPStringRequest.path(type);
            gxHTTPStringRequest.path(instanceUUID.toString());
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("operation", SharingPath.SharingOperation.ADD.name());
            queryParams.put("dryRun", dryRun.toString());
            Boolean forceAddToContext = this.getCurrentContextUUID().compareTo(contextUUID) == 0;
            queryParams.put("forceAddToContext", forceAddToContext.toString());
            this.includeAdditionalQueryParameters(gxHTTPStringRequest, queryParams);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.post();
            String jsonArray = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.info("{} with UUID {} successfully added to {} with UUID {}", new Object[]{type, instanceUUID, "Context", contextUUID});
            List affectedInstaces = ElementMapper.unmarshalList((String)jsonArray);
            return affectedInstaces;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ERElement> addToContext(ERElement er, UUID contextUUID, Boolean dryRun) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException {
        try {
            String type = Utility.getTypeName((Element)er);
            UUID instanceUUID = er.getHeader().getUUID();
            return this.addToContext(type, instanceUUID, contextUUID, dryRun);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ERElement> addToCurrentContext(String type, UUID instanceUUID, Boolean dryRun) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException {
        UUID contextUUID = this.getCurrentContextUUID();
        return this.addToContext(type, instanceUUID, contextUUID, dryRun);
    }

    @Override
    public List<ERElement> addToCurrentContext(ERElement er, Boolean dryRun) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException {
        UUID contextUUID = this.getCurrentContextUUID();
        return this.addToContext(er, contextUUID, dryRun);
    }

    @Override
    public List<ERElement> removeFromContext(String type, UUID instanceUUID, UUID contextUUID, Boolean dryRun) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to add {} with UUID {} to {} with UUID {} ", new Object[]{type, instanceUUID, "Context", contextUUID});
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.path("sharing");
            gxHTTPStringRequest.path("contexts");
            gxHTTPStringRequest.path(contextUUID.toString());
            gxHTTPStringRequest.path(type);
            gxHTTPStringRequest.path(instanceUUID.toString());
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("operation", SharingPath.SharingOperation.REMOVE.name());
            queryParams.put("dryRun", dryRun.toString());
            this.includeAdditionalQueryParameters(gxHTTPStringRequest, queryParams);
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.post();
            String jsonArray = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.info("{} with UUID {} successfully removed from {} with UUID {}", new Object[]{type, instanceUUID, "Context", contextUUID});
            List affectedInstaces = ElementMapper.unmarshalList((String)jsonArray);
            return affectedInstaces;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ERElement> removeFromContext(ERElement er, UUID contextUUID, Boolean dryRun) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException {
        try {
            String type = Utility.getTypeName((Element)er);
            UUID instanceUUID = er.getHeader().getUUID();
            return this.removeFromContext(type, instanceUUID, contextUUID, dryRun);
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ERElement> removeFromCurrentContext(String type, UUID instanceUUID, Boolean dryRun) throws SchemaViolationException, NotFoundException, ContextNotFoundException, ResourceRegistryException {
        UUID contextUUID = this.getCurrentContextUUID();
        return this.removeFromContext(type, instanceUUID, contextUUID, dryRun);
    }

    @Override
    public List<ERElement> removeFromCurrentContext(ERElement er, Boolean dryRun) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        UUID contextUUID = this.getCurrentContextUUID();
        return this.removeFromContext(er, contextUUID, dryRun);
    }

    @Override
    public Map<UUID, String> getElementContexts(String type, UUID instanceUUID) throws NotFoundException, ResourceRegistryException {
        try {
            logger.trace("Going to get contexts of {} with UUID {}", (Object)type, (Object)instanceUUID);
            GXHTTPStringRequest gxHTTPStringRequest = this.getGXHTTPStringRequest();
            gxHTTPStringRequest.path("instances");
            gxHTTPStringRequest.path(type);
            gxHTTPStringRequest.path(instanceUUID.toString());
            gxHTTPStringRequest.path("contexts");
            HttpURLConnection httpURLConnection = gxHTTPStringRequest.get();
            String objectNode = (String)HTTPUtility.getResponse(String.class, (HttpURLConnection)httpURLConnection);
            logger.info("Contexts of {} with UUID {} are {}", new Object[]{type, instanceUUID, objectNode});
            Map contexts = org.gcube.informationsystem.resourceregistry.api.contexts.ContextUtility.getContextMap((String)objectNode);
            return contexts;
        }
        catch (ResourceRegistryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <ERElem extends ERElement> Map<UUID, String> getElementContexts(ERElem er) throws NotFoundException, ResourceRegistryException {
        String type = Utility.getTypeName(er);
        UUID instanceUUID = er.getHeader().getUUID();
        return this.getElementContexts(type, instanceUUID);
    }

    @Override
    public List<ERElement> addResourceToContext(String resourceType, UUID resourceUUID, UUID contextUUID, Boolean dryRun) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToContext(resourceType, resourceUUID, contextUUID, dryRun);
    }

    @Override
    public <R extends Resource> List<ERElement> addResourceToContext(R resource, UUID contextUUID, Boolean dryRun) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToContext((ERElement)resource, contextUUID, dryRun);
    }

    @Override
    public List<ERElement> addResourceToCurrentContext(String resourceType, UUID resourceUUID, Boolean dryRun) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToCurrentContext(resourceType, resourceUUID, dryRun);
    }

    @Override
    public <R extends Resource> List<ERElement> addResourceToCurrentContext(R resource, Boolean dryRun) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToCurrentContext((ERElement)resource, dryRun);
    }

    @Override
    public List<ERElement> removeResourceFromContext(String resourceType, UUID resourceUUID, UUID contextUUID, Boolean dryRun) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromContext(resourceType, resourceUUID, contextUUID, dryRun);
    }

    @Override
    public <R extends Resource> List<ERElement> removeResourceFromContext(R resource, UUID contextUUID, Boolean dryRun) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromContext((ERElement)resource, contextUUID, dryRun);
    }

    @Override
    public List<ERElement> removeResourceFromCurrentContext(String resourceType, UUID resourceUUID, Boolean dryRun) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromCurrentContext(resourceType, resourceUUID, dryRun);
    }

    @Override
    public <R extends Resource> List<ERElement> removeResourceFromCurrentContext(R resource, Boolean dryRun) throws SchemaViolationException, ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromCurrentContext((ERElement)resource, dryRun);
    }

    @Override
    public Map<UUID, String> getResourceContexts(String resourceType, UUID resourceUUID) throws ResourceNotFoundException, ResourceRegistryException {
        return this.getElementContexts(resourceType, resourceUUID);
    }

    @Override
    public <R extends Resource> Map<UUID, String> getResourceContexts(R resource) throws ResourceNotFoundException, ResourceRegistryException {
        return this.getElementContexts((ERElement)resource);
    }

    @Override
    public List<ERElement> addFacetToContext(String facetType, UUID facetUUID, UUID contextUUID, Boolean dryRun) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToContext(facetType, facetUUID, contextUUID, dryRun);
    }

    @Override
    public <F extends Facet> List<ERElement> addFacetToContext(F facet, UUID contextUUID, Boolean dryRun) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToContext((ERElement)facet, contextUUID, dryRun);
    }

    @Override
    public List<ERElement> addFacetToCurrentContext(String facetType, UUID facetUUID, Boolean dryRun) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToCurrentContext(facetType, facetUUID, dryRun);
    }

    @Override
    public <F extends Facet> List<ERElement> addFacetToCurrentContext(F facet, Boolean dryRun) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.addToCurrentContext((ERElement)facet, dryRun);
    }

    @Override
    public List<ERElement> removeFacetFromContext(String facetType, UUID facetUUID, UUID contextUUID, Boolean dryRun) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromContext(facetType, facetUUID, contextUUID, dryRun);
    }

    @Override
    public <F extends Facet> List<ERElement> removeFacetFromContext(F facet, UUID contextUUID, Boolean dryRun) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromContext((ERElement)facet, contextUUID, dryRun);
    }

    @Override
    public List<ERElement> removeFacetFromCurrentContext(String facetType, UUID facetUUID, Boolean dryRun) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromCurrentContext(facetType, facetUUID, dryRun);
    }

    @Override
    public <F extends Facet> List<ERElement> removeFacetFromCurrentContext(F facet, Boolean dryRun) throws SchemaViolationException, FacetNotFoundException, ContextNotFoundException, ResourceRegistryException {
        return this.removeFromCurrentContext((ERElement)facet, dryRun);
    }

    @Override
    public Map<UUID, String> getFacetContexts(String facetType, UUID facetUUID) throws FacetNotFoundException, ResourceRegistryException {
        return this.getElementContexts(facetType, facetUUID);
    }

    @Override
    public <F extends Facet> Map<UUID, String> getFacetContexts(F facet) throws FacetNotFoundException, ResourceRegistryException {
        return this.getElementContexts((ERElement)facet);
    }
}

