/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.events.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.gcube.common.events.Hub;
import org.gcube.common.events.Observes;
import org.gcube.common.events.impl.Key;
import org.gcube.common.events.impl.Observer;
import org.gcube.common.events.impl.ReflectionUtils;
import org.gcube.common.events.impl.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHub
implements Hub {
    private static final Logger log = LoggerFactory.getLogger(Hub.class);
    private final Map<Key, List<Observer>> subscriptions = new HashMap<Key, List<Observer>>();
    private final ExecutorService service;
    private volatile boolean terminated = false;

    public DefaultHub() {
        this.service = Executors.newCachedThreadPool();
    }

    public DefaultHub(ExecutorService service) {
        Utils.notNull("executor service", service);
        this.service = service;
        log.info("configured hub with executor service {}", (Object)service.getClass().getSimpleName());
    }

    @Override
    public synchronized void subscribe(Object object) {
        if (this.isTerminated()) {
            return;
        }
        Utils.notNull("observer", object);
        for (Observer observer : Observer.observersFor(object, this.service)) {
            this.subscribe(observer);
        }
    }

    @Override
    public synchronized boolean unsubscribe(Object observer) {
        if (this.isTerminated()) {
            return false;
        }
        Utils.notNull("observer", observer);
        for (Key key : this.subscriptions.keySet()) {
            if (!this.unsubscribe(observer, key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void fire(Object event, String ... qualifiers) {
        if (this.isTerminated()) {
            return;
        }
        Utils.notNull("event", event);
        Utils.notNull("qualifiers", qualifiers);
        ArrayList<Observer> observers = new ArrayList<Observer>();
        for (Key key : this.subscriptions.keySet()) {
            if (!key.matches(ReflectionUtils.typeOf(event), qualifiers)) continue;
            observers.addAll((Collection<Observer>)this.subscriptions.get(key));
        }
        this.notifyObservers(observers, ReflectionUtils.valueOf(event));
    }

    @Override
    public void waitFor(Class<?> eventType) {
        if (this.isTerminated()) {
            return;
        }
        this.waitFor(eventType, 0L);
    }

    @Override
    public void waitFor(Class<?> eventType, long duration, TimeUnit unit) {
        if (this.isTerminated()) {
            return;
        }
        Utils.notNull("time unit", (Object)unit);
        if (duration <= 0L) {
            throw new IllegalArgumentException("invalid duration: 0 ms");
        }
        this.waitFor(eventType, unit.toMillis(duration));
    }

    @Override
    public void stop() {
        if (this.isTerminated()) {
            return;
        }
        try {
            Thread.sleep(200L);
            this.terminated = true;
            this.service.shutdown();
            this.service.awaitTermination(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.warn("cannot shutdown this hub", (Throwable)e);
        }
    }

    private void notifyObservers(List<Observer> observers, Object event) {
        ArrayList<Observer> critical = new ArrayList<Observer>();
        ArrayList<Observer> resilient = new ArrayList<Observer>();
        ArrayList<Observer> safe = new ArrayList<Observer>();
        ArrayList<Observer> target = null;
        for (Observer observer : observers) {
            switch (observer.kind()) {
                case critical: {
                    target = critical;
                    break;
                }
                case resilient: {
                    target = resilient;
                    break;
                }
                case safe: {
                    target = safe;
                }
            }
            target.add(observer);
        }
        for (Observer observer : critical) {
            try {
                observer.onEvent(event);
            }
            catch (RuntimeException e) {
                this.notifyObserversAsynchronously(resilient, event);
                throw e;
            }
        }
        safe.addAll(resilient);
        this.notifyObserversAsynchronously(safe, event);
    }

    private void notifyObserversAsynchronously(List<Observer> observers, final Object event) {
        ArrayList<1> asynchronous = new ArrayList<1>();
        for (final Observer observer : observers) {
            asynchronous.add(new Runnable(){

                @Override
                public void run() {
                    observer.onEvent(event);
                }
            });
        }
        for (Runnable runnable : asynchronous) {
            this.service.submit(runnable);
        }
    }

    private void subscribe(Observer observer) {
        Key key = observer.key();
        List<Observer> observers = this.subscriptions.get(key);
        if (observers == null) {
            observers = new ArrayList<Observer>();
            this.subscriptions.put(key, observers);
        }
        observers.add(observer);
    }

    private boolean unsubscribe(Object observer, Key key) {
        List<Observer> observers = this.subscriptions.get(key);
        if (observers != null) {
            for (Observer l : observers) {
                if (!l.equals(observer)) continue;
                observers.remove(l);
                return true;
            }
        }
        return false;
    }

    private boolean waitFor(final Class<?> eventType, long duration) {
        Utils.notNull("event type", eventType);
        final CountDownLatch latch = new CountDownLatch(1);
        Object watcher = new Object(){

            @Observes
            void onEvent() {
                log.trace("end of watch for event {}", (Object)eventType);
                latch.countDown();
            }
        };
        this.subscribe(watcher);
        log.info("subscribed watcher for event {}", eventType);
        boolean outcome = true;
        try {
            if (duration == 0L) {
                latch.await();
            } else {
                outcome = latch.await(duration, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            log.error("watcher for event {} has been interrupted", eventType);
            outcome = false;
        }
        return outcome;
    }

    private boolean isTerminated() {
        if (this.terminated) {
            log.trace("hub is terminated, operation request aborted");
        }
        return this.terminated;
    }
}

