/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.discovery.knowledge;

import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.discovery.DiscoveredElementAction;
import org.gcube.informationsystem.discovery.knowledge.UsageKnowledge;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.tree.Tree;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.types.reference.entities.ResourceType;

public class AddElementToTreeAction
implements DiscoveredElementAction<Element> {
    protected Tree<Class<Element>> tree;
    protected UsageKnowledge facetKnowledge;
    protected UsageKnowledge resourceKnowledge;

    public UsageKnowledge getFacetKnowledge() {
        return this.facetKnowledge;
    }

    public void setFacetKnowledge(UsageKnowledge facetKnowledge) {
        this.facetKnowledge = facetKnowledge;
    }

    public UsageKnowledge getResourceKnowledge() {
        return this.resourceKnowledge;
    }

    public void setResourceKnowledge(UsageKnowledge resourceKnowledge) {
        this.resourceKnowledge = resourceKnowledge;
    }

    public AddElementToTreeAction(Tree<Class<Element>> tree) {
        this.tree = tree;
    }

    @Override
    public void analizeElement(Class<Element> e) throws Exception {
        this.tree.addNode(e);
        this.createUsageKnowledge(e);
    }

    protected void createUsageKnowledge(Class<Element> e) {
        if (e.isAssignableFrom(Resource.class)) {
            return;
        }
        if (this.facetKnowledge != null && this.resourceKnowledge != null) {
            Type type = TypeMapper.createTypeDefinition(e);
            ResourceType rt = (ResourceType)type;
            this.facetKnowledge.addAll(rt.getFacets());
            this.resourceKnowledge.addAll(rt.getResources());
        }
    }
}

