/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handler.resourceregistry;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.events.Observes;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.handler.resourceregistry.Constants;
import org.gcube.smartgears.handler.resourceregistry.ContextUtility;
import org.gcube.smartgears.handler.resourceregistry.resourcemanager.HostingNodeManager;
import org.gcube.smartgears.handlers.container.ContainerHandler;
import org.gcube.smartgears.handlers.container.ContainerLifecycleEvent;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.lifecycle.container.ContainerState;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="resource-management")
public class HostingNodeHandler
extends ContainerHandler {
    private static Logger logger = LoggerFactory.getLogger(HostingNodeHandler.class);
    private ContainerContext containerContext;
    private ScheduledFuture<?> periodicUpdates;
    protected HostingNodeManager hostingNodeManager;

    public void onStart(ContainerLifecycleEvent.Start event) {
        try {
            logger.info("{} onStart started", (Object)((Object)((Object)this)).getClass().getSimpleName());
            this.containerContext = (ContainerContext)event.context();
            this.init();
            this.registerObservers();
            this.schedulePeriodicUpdates();
            logger.info("{} onStart terminated", (Object)((Object)((Object)this)).getClass().getSimpleName());
        }
        catch (Throwable re) {
            logger.error("onStart failed", re);
        }
    }

    protected void removeResourceFromOldContexts(Set<UUID> startContexts, Set<UUID> resourceContexts) throws ResourceRegistryException {
        HashSet<UUID> contextsToRemove = new HashSet<UUID>(resourceContexts);
        contextsToRemove.removeAll(startContexts);
        for (UUID contextToRemove : contextsToRemove) {
            this.hostingNodeManager.removeFromContext(contextToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            Thread.currentThread().setContextClassLoader(HostingNodeHandler.class.getClassLoader());
            boolean create = true;
            List startTokens = this.containerContext.configuration().startTokens();
            String firstToken = (String)startTokens.iterator().next();
            ContextUtility.setContextFromToken(firstToken);
            this.hostingNodeManager = new HostingNodeManager(this.containerContext);
            HashSet<UUID> startContextsUUID = new HashSet<UUID>();
            for (String token : startTokens) {
                UUID contextUUID = ContextUtility.getContextUUID(token);
                startContextsUUID.add(contextUUID);
                if (create) {
                    this.hostingNodeManager.createHostingNode();
                    this.containerContext.properties().add(new Property[]{new Property(Constants.HOSTING_NODE_MANAGER_PROPERTY, (Object)this.hostingNodeManager)});
                    create = false;
                    continue;
                }
                this.hostingNodeManager.addToContext(contextUUID);
            }
            Set<UUID> resourceContextsUUID = this.hostingNodeManager.getContextsUUID().keySet();
            this.removeResourceFromOldContexts(startContextsUUID, resourceContextsUUID);
        }
        catch (Throwable e) {
            Utils.rethrowUnchecked((Throwable)e);
        }
        finally {
            ContextUtility.setContextFromToken(previousToken);
            Thread.currentThread().setContextClassLoader(contextCL);
        }
        logger.info("{} init() terminated", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    private void registerObservers() {
        this.containerContext.events().subscribe(new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Observes(value={"activation", "part_activation", "shutdown", "stop", "failure"})
            void onChanged(ContainerLifecycle cl) {
                ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                String previousToken = SecurityTokenProvider.instance.get();
                try {
                    Thread.currentThread().setContextClassLoader(HostingNodeHandler.class.getClassLoader());
                    if (previousToken == null) {
                        String token = (String)HostingNodeHandler.this.containerContext.configuration().startTokens().iterator().next();
                        ContextUtility.setContextFromToken(token);
                    }
                    HostingNodeHandler.this.hostingNodeManager.updateFacets();
                }
                catch (Exception e) {
                    logger.error("Failed to update {} State", (Object)"HostingNode", (Object)e);
                }
                finally {
                    ContextUtility.setContextFromToken(previousToken);
                    Thread.currentThread().setContextClassLoader(contextCL);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Observes(value={"addToContext"})
            void addTo(String token) {
                ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                String previousToken = SecurityTokenProvider.instance.get();
                try {
                    Thread.currentThread().setContextClassLoader(HostingNodeHandler.class.getClassLoader());
                    ContextUtility.setContextFromToken(token);
                    UUID contextUUID = ContextUtility.getContextUUID(token);
                    HostingNodeHandler.this.hostingNodeManager.addToContext(contextUUID);
                }
                catch (Exception e) {
                    logger.error("Failed to update Service State", (Throwable)e);
                }
                finally {
                    ContextUtility.setContextFromToken(previousToken);
                    Thread.currentThread().setContextClassLoader(contextCL);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Observes(value={"removeFromContext"})
            void removeFrom(String token) {
                ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
                String previousToken = SecurityTokenProvider.instance.get();
                try {
                    Thread.currentThread().setContextClassLoader(HostingNodeHandler.class.getClassLoader());
                    ContextUtility.setContextFromToken(token);
                    UUID contextUUID = ContextUtility.getContextUUID(token);
                    HostingNodeHandler.this.hostingNodeManager.removeFromContext(contextUUID);
                }
                catch (Exception e) {
                    logger.error("Failed to update Service State", (Throwable)e);
                }
                finally {
                    ContextUtility.setContextFromToken(previousToken);
                    Thread.currentThread().setContextClassLoader(contextCL);
                }
            }
        });
    }

    private void schedulePeriodicUpdates() {
        this.containerContext.events().subscribe(new Object(){
            final ScheduledExecutorService service = Executors.newScheduledThreadPool(1);

            @Observes(value={"activation", "part_activation"}, kind=Observes.Kind.resilient)
            synchronized void restartPeriodicUpdates(ContainerLifecycle cl) {
                if (HostingNodeHandler.this.periodicUpdates != null) {
                    return;
                }
                if (cl.state() == ContainerState.active) {
                    logger.info("Scheduling periodic updates of {}", (Object)"HostingNode");
                } else {
                    logger.info("Resuming periodic updates of {}", (Object)"HostingNode");
                }
                Runnable updateTask = new Runnable(){

                    @Override
                    public void run() {
                        String previousToken = SecurityTokenProvider.instance.get();
                        if (previousToken == null) {
                            String token = (String)HostingNodeHandler.this.containerContext.configuration().startTokens().iterator().next();
                            ContextUtility.setContextFromToken(token);
                        }
                        try {
                            HostingNodeHandler.this.hostingNodeManager.updateFacets();
                        }
                        catch (Exception e) {
                            logger.error("Cannot complete periodic update of {}", (Object)"HostingNode", (Object)e);
                        }
                        finally {
                            ContextUtility.setContextFromToken(previousToken);
                        }
                    }
                };
                HostingNodeHandler.this.periodicUpdates = this.service.scheduleAtFixedRate(updateTask, 3L, HostingNodeHandler.this.containerContext.configuration().publicationFrequency(), TimeUnit.SECONDS);
            }

            @Observes(value={"stop", "failure", "shutdown"}, kind=Observes.Kind.resilient)
            synchronized void cancelPeriodicUpdates(ContainerLifecycle cl) {
                if (HostingNodeHandler.this.periodicUpdates != null) {
                    logger.trace("Stopping periodic updates of {}", (Object)"HostingNode");
                    try {
                        HostingNodeHandler.this.periodicUpdates.cancel(true);
                        this.service.shutdownNow();
                        HostingNodeHandler.this.periodicUpdates = null;
                    }
                    catch (Exception e) {
                        logger.warn("Could not stop periodic updates of {}", (Object)"HostingNode", (Object)e);
                    }
                }
            }
        });
    }

    public String toString() {
        return "resource-management";
    }
}

