/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.discovery.knowledge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.discovery.DiscoveredElementAction;
import org.gcube.informationsystem.discovery.RegistrationProvider;
import org.gcube.informationsystem.tree.Node;
import org.gcube.informationsystem.tree.NodeElaborator;
import org.gcube.informationsystem.types.TypeMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelKnowledgeValidator
implements DiscoveredElementAction<Element>,
NodeElaborator<Class<Element>> {
    public static Logger logger = LoggerFactory.getLogger(ModelKnowledgeValidator.class);
    protected RegistrationProvider rp;
    private Collection<Package> packages;
    private List<Class<Element>> baseTypes;

    public ModelKnowledgeValidator(RegistrationProvider rp) {
        AccessType[] accessTypes;
        this.rp = rp;
        this.packages = rp.getPackagesToRegister();
        this.baseTypes = new ArrayList<Class<Element>>();
        for (AccessType accessType : accessTypes = AccessType.getModelTypes()) {
            this.baseTypes.add(accessType.getTypeClass());
        }
    }

    @Override
    public void analizeElement(Class<Element> e) throws Exception {
        String typeName = TypeMapper.getType(e);
        if (this.baseTypes.contains(e)) {
            logger.info("- Type {} is the root type", (Object)typeName);
            return;
        }
        if (!this.packages.contains(e.getPackage())) {
            logger.error("- Type {} DOES NOT belong to {} as expected. This is very strange and should not occurr.", (Object)typeName, (Object)this.rp.getModelName());
            throw new Exception("Type " + typeName + " DOES NOT belong to " + this.rp.getModelName() + " as expected. This is very strange and should not occurr.");
        }
        logger.info("- Type {} belongs to {} as expected", (Object)typeName, (Object)this.rp.getModelName());
    }

    @Override
    public void elaborate(Node<Class<Element>> node, int level) throws Exception {
        Class<Element> e = node.getNodeElement();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            stringBuffer.append(Node.INDENTATION);
        }
        String typeName = TypeMapper.getType(e);
        if (node.getTree().getRootNode().getNodeElement() == e) {
            logger.info("{}- Type {} is the root type", (Object)stringBuffer.toString(), (Object)typeName);
            return;
        }
        if (!this.packages.contains(e.getPackage())) {
            logger.error("{}- Type {} DOES NOT belong to {} as expected. This is very strange and should not occurr.", new Object[]{stringBuffer.toString(), typeName, this.rp.getModelName()});
            throw new Exception("Type " + typeName + " DOES NOT belong to " + this.rp.getModelName() + " as expected. This is very strange and should not occurr.");
        }
        logger.info("{}- Type {} belongs to {} as expected", new Object[]{stringBuffer.toString(), typeName, this.rp.getModelName()});
    }
}

