/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.client;

import org.gcube.informationsystem.resourceregistry.api.rest.ServiceInstance;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryClientFactory.class);

    public static String getResourceRegistryURL() {
        String address = String.format("%s/%s", ServiceInstance.getServiceURL(), "resource-registry");
        return address;
    }

    public static String getResourceRegistryURL(String context) {
        String address = String.format("%s/%s", ServiceInstance.getServiceURL((String)context), "resource-registry");
        return address;
    }

    public static ResourceRegistryClient create() {
        String address = ResourceRegistryClientFactory.getResourceRegistryURL();
        logger.trace("The {} will be contacted at {}", (Object)"resource-registry", (Object)address);
        return new ResourceRegistryClientImpl(address);
    }

    public static ResourceRegistryClient create(String context) {
        String address = ResourceRegistryClientFactory.getResourceRegistryURL(context);
        logger.trace("The {} will be contacted at {}", (Object)"resource-registry", (Object)address);
        return new ResourceRegistryClientImpl(address);
    }
}

