/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.gcore;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.common.AnyMixedWrapper;
import org.gcube.common.resources.gcore.common.AnyWrapper;
import org.gcube.common.resources.gcore.common.BooleanWrapper;
import org.gcube.common.resources.gcore.common.FileList;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.utils.Group;
import org.w3c.dom.Element;

@XmlRootElement(name="Resource")
public class Software
extends Resource {
    private static String CURRENT_VERSION = "1.3.0";
    @XmlElementRef
    private Profile profile;

    public Software() {
        this.type(Resource.Type.SOFTWARE);
        this.version(CURRENT_VERSION);
    }

    @Override
    public Profile profile() {
        return this.profile;
    }

    public Profile newProfile() {
        this.profile = new Profile();
        return this.profile;
    }

    @XmlRootElement(name="Profile")
    @XmlType(propOrder={"description", "clazz", "name", "version", "configuration", "dependencies", "packages", "specificData"})
    public static class Profile {
        @XmlElement(name="Description")
        private String description;
        @XmlElement(name="Class")
        private String clazz;
        @XmlElement(name="Name")
        private String name;
        @XmlElement(name="Version")
        final String version = "1.0.0";
        @XmlElementRef
        private Configuration configuration;
        @XmlElementWrapper(name="Dependencies")
        @XmlElementRef
        private Set<Dependency> dependencies = new LinkedHashSet<Dependency>();
        @XmlElementWrapper(name="Packages")
        @XmlElementRefs(value={@XmlElementRef(type=ServicePackage.class), @XmlElementRef(type=PluginPackage.class), @XmlElementRef(type=GenericPackage.class)})
        private Set<SoftwarePackage<?>> packages = new LinkedHashSet();
        @XmlElement(name="SpecificData")
        private SpecificData specificData;

        public String description() {
            return this.description;
        }

        public Profile description(String description) {
            this.description = description;
            return this;
        }

        public String softwareClass() {
            return this.clazz;
        }

        public Profile softwareClass(String clazz) {
            this.clazz = clazz;
            return this;
        }

        public String softwareName() {
            return this.name;
        }

        public Profile softwareName(String name) {
            this.name = name;
            return this;
        }

        public Configuration configuration() {
            return this.configuration;
        }

        public boolean hasConfiguration() {
            return this.configuration != null;
        }

        public Configuration newConfiguration() {
            this.configuration = new Configuration();
            return this.configuration;
        }

        public Group<SoftwarePackage<?>> packages() {
            return new Group(this.packages, SoftwarePackage.class);
        }

        public Map<String, SoftwarePackage<?>> softwarePackageMap() {
            HashMap map = new HashMap();
            for (SoftwarePackage<?> sp : this.packages) {
                if (sp.name() == null) continue;
                map.put(sp.name(), sp);
            }
            return map;
        }

        public Element specificData() {
            return this.specificData == null ? null : this.specificData.root();
        }

        public boolean hasSpecificData() {
            return this.specificData != null;
        }

        public Element newSpecificData() {
            this.specificData = new SpecificData();
            return this.specificData.root();
        }

        public Group<Dependency> dependencies() {
            return new Group<Dependency>(this.dependencies, Dependency.class);
        }

        public String toString() {
            return "Profile [description=" + this.description + ", clazz=" + this.clazz + ", name=" + this.name + ", configuration=" + this.configuration + ", dependency=" + this.dependencies + ", packages=" + this.packages + ", specificData=" + this.specificData + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.configuration == null ? 0 : this.configuration.hashCode());
            result = 31 * result + (this.dependencies == null ? 0 : this.dependencies.hashCode());
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.packages == null ? 0 : this.packages.hashCode());
            result = 31 * result + (this.specificData == null ? 0 : this.specificData.hashCode());
            result = 31 * result + ("1.0.0" == null ? 0 : "1.0.0".hashCode());
            return result;
        }

        void beforeMarshal(Marshaller marshaller) {
            if (this.dependencies != null && this.dependencies.isEmpty()) {
                this.dependencies = null;
            }
            if (this.packages != null && this.packages.isEmpty()) {
                this.packages = null;
            }
        }

        void afterMarshal(Marshaller marshaller) {
            if (this.dependencies == null) {
                this.dependencies = new LinkedHashSet<Dependency>();
            }
            if (this.packages == null) {
                this.packages = new LinkedHashSet();
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Profile other = (Profile)obj;
            if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                return false;
            }
            if (this.configuration == null ? other.configuration != null : !this.configuration.equals(other.configuration)) {
                return false;
            }
            if (this.dependencies == null ? other.dependencies != null : !this.dependencies.equals(other.dependencies)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.packages == null ? other.packages != null : !this.packages.equals(other.packages)) {
                return false;
            }
            if (this.specificData == null ? other.specificData != null : !this.specificData.equals(other.specificData)) {
                return false;
            }
            return !("1.0.0" == null ? other.version != null : !"1.0.0".equals(other.version));
        }

        @XmlType(propOrder={"description", "name", "version", "coordinates", "targetPlatform", "multiversion", "mandatory", "shareable", "ghnRequirements", "installScripts", "uninstallScripts", "rebootScripts", "dependencies", "specificData"})
        public static abstract class SoftwarePackage<T extends SoftwarePackage<T>> {
            @XmlElement(name="Description")
            private String description;
            @XmlElement(name="Name")
            private String name;
            @XmlElement(name="Version")
            private String version;
            @XmlElementRef
            private MavenCoordinates coordinates;
            @XmlElementRef
            private TargetPlatform targetPlatform;
            @XmlElement(name="MultiVersion")
            private BooleanWrapper multiversion = new BooleanWrapper(true);
            @XmlElement(name="Mandatory")
            private LevelWrapper mandatory;
            @XmlElement(name="Shareable")
            private LevelWrapper shareable;
            @XmlElementWrapper(name="GHNRequirements")
            @XmlElementRef
            private Set<Requirement> ghnRequirements = new LinkedHashSet<Requirement>();
            @XmlElementRef
            private InstallScripts installScripts = new InstallScripts();
            @XmlElementRef
            private UninstallScripts uninstallScripts = new UninstallScripts();
            @XmlElementRef
            private RebootScripts rebootScripts = new RebootScripts();
            @XmlElementWrapper(name="Dependencies")
            @XmlElementRef
            private Set<PackageDependency> dependencies = new LinkedHashSet<PackageDependency>();
            @XmlElement(name="SpecificData")
            private SpecificData specificData;

            protected abstract T _this();

            private void beforeMarshal(Marshaller marshaller) {
                if (this.ghnRequirements.isEmpty()) {
                    this.ghnRequirements = null;
                }
                if (this.installScripts.files.isEmpty()) {
                    this.installScripts = null;
                }
                if (this.uninstallScripts.files.isEmpty()) {
                    this.uninstallScripts = null;
                }
                if (this.rebootScripts.files.isEmpty()) {
                    this.rebootScripts = null;
                }
                if (this.dependencies.isEmpty()) {
                    this.dependencies = null;
                }
            }

            private void afterMarshal(Marshaller marshaller) {
                if (this.ghnRequirements == null) {
                    this.ghnRequirements = new LinkedHashSet<Requirement>();
                }
                if (this.installScripts == null) {
                    this.installScripts = new InstallScripts();
                }
                if (this.uninstallScripts == null) {
                    this.uninstallScripts = new UninstallScripts();
                }
                if (this.rebootScripts == null) {
                    this.rebootScripts = new RebootScripts();
                }
                if (this.dependencies == null) {
                    this.dependencies = new LinkedHashSet<PackageDependency>();
                }
            }

            public String description() {
                return this.description;
            }

            public T description(String description) {
                this.description = description;
                return this._this();
            }

            public String name() {
                return this.name;
            }

            public T name(String name) {
                this.name = name;
                return this._this();
            }

            public String version() {
                return this.version;
            }

            public T version(String version) {
                this.version = version;
                return this._this();
            }

            public MavenCoordinates coordinates() {
                return this.coordinates;
            }

            public boolean hasCoordinates() {
                return this.coordinates != null;
            }

            public MavenCoordinates newCoordinates() {
                this.coordinates = new MavenCoordinates();
                return this.coordinates;
            }

            public TargetPlatform targetPlatform() {
                return this.targetPlatform;
            }

            public boolean hasTargetPlatform() {
                return this.targetPlatform != null;
            }

            public TargetPlatform newTargetPlatform() {
                this.targetPlatform = new TargetPlatform();
                return this.targetPlatform;
            }

            public boolean isMultiVersion() {
                return this.multiversion.value;
            }

            public T multiVersion(boolean value) {
                this.multiversion.value = value;
                return this._this();
            }

            public Level mandatory() {
                return this.mandatory.level;
            }

            public LevelWrapper newMandatory() {
                this.mandatory = new LevelWrapper(Level.NONE);
                return this.mandatory;
            }

            public Level shareable() {
                return this.shareable.level;
            }

            public boolean hasShareable() {
                return this.shareable != null;
            }

            public LevelWrapper newShareable() {
                this.shareable = new LevelWrapper(Level.VO);
                return this.shareable;
            }

            public Group<Requirement> ghnRequirements() {
                return new Group<Requirement>(this.ghnRequirements, Requirement.class);
            }

            public Map<String, Requirement> ghnRequirementsMap() {
                HashMap<String, Requirement> map = new HashMap<String, Requirement>();
                for (Requirement r : this.ghnRequirements) {
                    if (r.key() == null) continue;
                    map.put(r.key(), r);
                }
                return map;
            }

            public Collection<String> installScripts() {
                return new Group<String>(this.installScripts.files, String.class);
            }

            public Collection<String> uninstallScripts() {
                return new Group<String>(this.uninstallScripts.files, String.class);
            }

            public Collection<String> rebootScripts() {
                return new Group<String>(this.rebootScripts.files, String.class);
            }

            public boolean hasRebootScripts() {
                return this.rebootScripts != null;
            }

            public Group<PackageDependency> dependencies() {
                return new Group<PackageDependency>(this.dependencies, PackageDependency.class);
            }

            public Element specificData() {
                return this.specificData == null ? null : this.specificData.root();
            }

            public String specificDataAsString() {
                return this.specificData == null ? null : this.specificData.asString();
            }

            public boolean hasSpecificData() {
                return this.specificData != null;
            }

            public Element newSpecificData() {
                this.specificData = new SpecificData();
                return this.specificData.root();
            }

            public T newSpecificData(String text) {
                this.specificData = new SpecificData();
                this.specificData.setString(text);
                return this._this();
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.coordinates == null ? 0 : this.coordinates.hashCode());
                result = 31 * result + (this.dependencies == null ? 0 : this.dependencies.hashCode());
                result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
                result = 31 * result + (this.ghnRequirements == null ? 0 : this.ghnRequirements.hashCode());
                result = 31 * result + (this.installScripts == null ? 0 : this.installScripts.hashCode());
                result = 31 * result + (this.mandatory == null ? 0 : this.mandatory.hashCode());
                result = 31 * result + (this.multiversion == null ? 0 : this.multiversion.hashCode());
                result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                result = 31 * result + (this.rebootScripts == null ? 0 : this.rebootScripts.hashCode());
                result = 31 * result + (this.shareable == null ? 0 : this.shareable.hashCode());
                result = 31 * result + (this.specificData == null ? 0 : this.specificData.hashCode());
                result = 31 * result + (this.targetPlatform == null ? 0 : this.targetPlatform.hashCode());
                result = 31 * result + (this.uninstallScripts == null ? 0 : this.uninstallScripts.hashCode());
                result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                SoftwarePackage other = (SoftwarePackage)obj;
                if (this.coordinates == null ? other.coordinates != null : !this.coordinates.equals(other.coordinates)) {
                    return false;
                }
                if (this.dependencies == null ? other.dependencies != null : !this.dependencies.equals(other.dependencies)) {
                    return false;
                }
                if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                    return false;
                }
                if (this.ghnRequirements == null ? other.ghnRequirements != null : !this.ghnRequirements.equals(other.ghnRequirements)) {
                    return false;
                }
                if (this.installScripts == null ? other.installScripts != null : !this.installScripts.equals(other.installScripts)) {
                    return false;
                }
                if (this.mandatory == null ? other.mandatory != null : !this.mandatory.equals(other.mandatory)) {
                    return false;
                }
                if (this.multiversion == null ? other.multiversion != null : !this.multiversion.equals(other.multiversion)) {
                    return false;
                }
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
                if (this.rebootScripts == null ? other.rebootScripts != null : !this.rebootScripts.equals(other.rebootScripts)) {
                    return false;
                }
                if (this.shareable == null ? other.shareable != null : !this.shareable.equals(other.shareable)) {
                    return false;
                }
                if (this.specificData == null ? other.specificData != null : !this.specificData.equals(other.specificData)) {
                    return false;
                }
                if (this.targetPlatform == null ? other.targetPlatform != null : !this.targetPlatform.equals(other.targetPlatform)) {
                    return false;
                }
                if (this.uninstallScripts == null ? other.uninstallScripts != null : !this.uninstallScripts.equals(other.uninstallScripts)) {
                    return false;
                }
                return !(this.version == null ? other.version != null : !this.version.equals(other.version));
            }

            public String toString() {
                return "[description=" + this.description + ", name=" + this.name + ", version=" + this.version + ", coordinates=" + this.coordinates + ", targetPlatform=" + this.targetPlatform + ", multiversion=" + this.multiversion + ", mandatory=" + this.mandatory + ", shareable=" + this.shareable + ", ghnRequirements=" + this.ghnRequirements + ", installScripts=" + this.installScripts + ", uninstallScripts=" + this.uninstallScripts + ", rebootScripts=" + this.rebootScripts + ", dependencies=" + this.dependencies + "], specificData=" + this.specificData + "]";
            }

            @XmlRootElement(name="Requirement")
            @XmlType(propOrder={"category", "key", "requirement", "value", "operator"})
            public static class Requirement {
                @XmlAttribute(name="category")
                private String category;
                @XmlAttribute(name="key")
                private String key;
                @XmlAttribute(name="requirement")
                private String requirement;
                @XmlAttribute(name="value")
                private String value;
                @XmlAttribute(name="operator")
                private OpType operator;

                public String category() {
                    return this.category;
                }

                public Requirement category(String cat) {
                    this.category = cat;
                    return this;
                }

                public String key() {
                    return this.key;
                }

                public Requirement key(String key) {
                    this.key = key;
                    return this;
                }

                public String requirement() {
                    return this.requirement;
                }

                public Requirement requirement(String requirement) {
                    this.requirement = requirement;
                    return this;
                }

                public String value() {
                    return this.value;
                }

                public Requirement value(String value) {
                    this.value = value;
                    return this;
                }

                public OpType operator() {
                    return this.operator;
                }

                public Requirement operator(OpType operator) {
                    this.operator = operator;
                    return this;
                }

                public String toString() {
                    return "Requirement [category=" + this.category + ", key=" + this.key + ", requirement=" + this.requirement + ", value=" + this.value + ", operator=" + this.operator + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
                    result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
                    result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
                    result = 31 * result + (this.requirement == null ? 0 : this.requirement.hashCode());
                    result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Requirement other = (Requirement)obj;
                    if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
                        return false;
                    }
                    if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                        return false;
                    }
                    if (this.operator != other.operator) {
                        return false;
                    }
                    if (this.requirement == null ? other.requirement != null : !this.requirement.equals(other.requirement)) {
                        return false;
                    }
                    return !(this.value == null ? other.value != null : !this.value.equals(other.value));
                }

                @XmlType(name="OpType")
                @XmlEnum
                public static enum OpType {
                    eq,
                    exist,
                    ge,
                    gt,
                    le,
                    lt,
                    ne,
                    contains;


                    public String value() {
                        return this.name();
                    }

                    public static OpType fromValue(String v) {
                        return OpType.valueOf(v);
                    }
                }
            }

            @XmlType(name="Scopes")
            @XmlEnum
            public static enum Level {
                NONE,
                GHN,
                VRE,
                VO;


                public String value() {
                    return this.name();
                }

                public static Level fromValue(String v) {
                    return Level.valueOf(v);
                }
            }

            public static class LevelWrapper {
                @XmlAttribute(name="level")
                private Level level;

                LevelWrapper() {
                }

                LevelWrapper(Level level) {
                    this.level = level;
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    LevelWrapper other = (LevelWrapper)obj;
                    return this.level == other.level;
                }
            }

            @XmlRootElement(name="TargetPlatform")
            public static class TargetPlatform
            extends Platform {
            }

            @XmlRootElement(name="Dependency")
            @XmlType(propOrder={"service", "package_", "version", "scope", "optional"})
            public static class PackageDependency {
                @XmlElement(name="Package")
                private String package_;
                @XmlElement(name="Version")
                private String version;
                @XmlElementRef
                private DependencyService service;
                @XmlElement(name="Scope")
                private LevelWrapper scope;
                @XmlElement(name="Optional")
                private boolean optional;

                public boolean isOptional() {
                    return this.optional;
                }

                public String dependencyPackage() {
                    return this.package_;
                }

                public PackageDependency dependencyPackage(String dependencyPackage) {
                    this.package_ = dependencyPackage;
                    return this;
                }

                public String version() {
                    return this.version;
                }

                public PackageDependency version(String version) {
                    this.version = version;
                    return this;
                }

                public DependencyService service() {
                    return this.service;
                }

                public DependencyService newService() {
                    this.service = new DependencyService();
                    return this.service;
                }

                public Level scope() {
                    return this.scope.level;
                }

                public boolean hasScope() {
                    return this.scope != null;
                }

                public LevelWrapper newScope() {
                    this.scope = new LevelWrapper(Level.VO);
                    return this.scope;
                }

                public String toString() {
                    return " [package_=" + this.package_ + ", version=" + this.version + ", service=" + this.service + ", scope=" + this.scope + ", optional=" + this.optional + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.optional ? 1231 : 1237);
                    result = 31 * result + (this.package_ == null ? 0 : this.package_.hashCode());
                    result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
                    result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
                    result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    PackageDependency other = (PackageDependency)obj;
                    if (this.optional != other.optional) {
                        return false;
                    }
                    if (this.package_ == null ? other.package_ != null : !this.package_.equals(other.package_)) {
                        return false;
                    }
                    if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
                        return false;
                    }
                    if (this.service == null ? other.service != null : !this.service.equals(other.service)) {
                        return false;
                    }
                    return !(this.version == null ? other.version != null : !this.version.equals(other.version));
                }

                @XmlRootElement(name="Service")
                public static class DependencyService {
                    @XmlElement(name="Class")
                    private String clazz;
                    @XmlElement(name="Name")
                    private String name;
                    @XmlElement(name="Version")
                    private String version;

                    public String packageClass() {
                        return this.clazz;
                    }

                    public DependencyService packageClass(String clazz) {
                        this.clazz = clazz;
                        return this;
                    }

                    public String packageName() {
                        return this.name;
                    }

                    public DependencyService packageName(String name) {
                        this.name = name;
                        return this;
                    }

                    public String version() {
                        return this.version;
                    }

                    public DependencyService version(String version) {
                        this.version = version;
                        return this;
                    }

                    public String toString() {
                        return " [clazz=" + this.clazz + ", name=" + this.name + ", version=" + this.version + "]";
                    }

                    public int hashCode() {
                        int prime = 31;
                        int result = 1;
                        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
                        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
                        return result;
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        DependencyService other = (DependencyService)obj;
                        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                            return false;
                        }
                        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                            return false;
                        }
                        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
                    }
                }
            }

            @XmlRootElement(name="MavenCoordinates")
            @XmlType(propOrder={"groupId", "artifactId", "version", "classifier"})
            public static class MavenCoordinates {
                @XmlElement(name="groupId")
                private String groupId;
                @XmlElement(name="artifactId")
                private String artifactId;
                @XmlElement(name="version")
                private String version;
                @XmlElement(name="classifier")
                private String classifier;

                public String groupId() {
                    return this.groupId;
                }

                public MavenCoordinates groupId(String gid) {
                    this.groupId = gid;
                    return this;
                }

                public String artifactId() {
                    return this.artifactId;
                }

                public MavenCoordinates artifactId(String aId) {
                    this.artifactId = aId;
                    return this;
                }

                public String version() {
                    return this.version;
                }

                public MavenCoordinates version(String version) {
                    this.version = version;
                    return this;
                }

                public String classifier() {
                    return this.classifier;
                }

                public MavenCoordinates classifier(String classifier) {
                    this.classifier = classifier;
                    return this;
                }

                public String toString() {
                    return " [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", classifier=" + this.classifier + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
                    result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
                    result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
                    result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    MavenCoordinates other = (MavenCoordinates)obj;
                    if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
                        return false;
                    }
                    if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
                        return false;
                    }
                    if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                        return false;
                    }
                    return !(this.version == null ? other.version != null : !this.version.equals(other.version));
                }
            }

            @XmlRootElement(name="RebootScripts")
            public static class RebootScripts
            extends FileList {
            }

            @XmlRootElement(name="UninstallScripts")
            public static class UninstallScripts
            extends FileList {
            }

            @XmlRootElement(name="InstallScripts")
            public static class InstallScripts
            extends FileList {
            }
        }

        @XmlRootElement(name="Plugin")
        @XmlType(propOrder={"target", "entryPoint", "files"})
        public static class PluginPackage
        extends SoftwarePackage<PluginPackage> {
            @XmlElementRef
            private TargetService target;
            @XmlElementWrapper(name="Files")
            @XmlElement(name="File")
            private Set<String> files = new LinkedHashSet<String>();
            @XmlElement(name="EntryPoint")
            private String entryPoint;

            @Override
            protected PluginPackage _this() {
                return this;
            }

            private void beforeMarshal(Marshaller marshaller) {
                super.beforeMarshal(marshaller);
                if (this.files.isEmpty()) {
                    this.files = null;
                }
            }

            private void afterMarshal(Marshaller marshaller) {
                super.afterMarshal(marshaller);
                if (this.files == null) {
                    this.files = new LinkedHashSet<String>();
                }
            }

            public TargetService targetService() {
                return this.target;
            }

            public TargetService newTargetService() {
                this.target = new TargetService();
                return this.target;
            }

            public String entryPoint() {
                return this.entryPoint;
            }

            public PluginPackage entryPoint(String entry) {
                this.entryPoint = entry;
                return this;
            }

            public Collection<String> files() {
                return new Group<String>(this.files, String.class);
            }

            @Override
            public String toString() {
                return "Plugin [service=" + this.target + "]";
            }

            @Override
            public int hashCode() {
                int prime = 31;
                int result = super.hashCode();
                result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!super.equals(obj)) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                PluginPackage other = (PluginPackage)obj;
                return !(this.target == null ? other.target != null : !this.target.equals(other.target));
            }

            @XmlRootElement(name="TargetService")
            public static class TargetService {
                @XmlElementRef
                private Service service;
                @XmlElement(name="Package")
                private String package_;
                @XmlElement(name="Version")
                private String version;

                public Service service() {
                    return this.service;
                }

                public Service newService() {
                    this.service = new Service();
                    return this.service;
                }

                public String servicePackage() {
                    return this.package_;
                }

                public TargetService servicePackage(String pack) {
                    this.package_ = pack;
                    return this;
                }

                public String version() {
                    return this.version;
                }

                public TargetService version(String version) {
                    this.version = version;
                    return this;
                }

                public String toString() {
                    return " [service=" + this.service + ", package_=" + this.package_ + ", version=" + this.version + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.package_ == null ? 0 : this.package_.hashCode());
                    result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
                    result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    TargetService other = (TargetService)obj;
                    if (this.package_ == null ? other.package_ != null : !this.package_.equals(other.package_)) {
                        return false;
                    }
                    if (this.service == null ? other.service != null : !this.service.equals(other.service)) {
                        return false;
                    }
                    return !(this.version == null ? other.version != null : !this.version.equals(other.version));
                }

                @XmlRootElement(name="Service")
                public static class Service {
                    @XmlElement(name="Class")
                    private String clazz;
                    @XmlElement(name="Name")
                    private String name;
                    @XmlElement(name="Version")
                    private String version;

                    public String serviceClass() {
                        return this.clazz;
                    }

                    public Service serviceClass(String clazz) {
                        this.clazz = clazz;
                        return this;
                    }

                    public String serviceName() {
                        return this.name;
                    }

                    public Service serviceName(String name) {
                        this.name = name;
                        return this;
                    }

                    public String version() {
                        return this.version;
                    }

                    public Service version(String version) {
                        this.version = version;
                        return this;
                    }

                    public String toString() {
                        return " [class=" + this.clazz + ", name=" + this.name + ", version=" + this.version + "]";
                    }

                    public int hashCode() {
                        int prime = 31;
                        int result = 1;
                        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
                        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
                        return result;
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        Service other = (Service)obj;
                        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                            return false;
                        }
                        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                            return false;
                        }
                        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
                    }
                }
            }
        }

        @XmlRootElement(name="WSDL")
        public static class Wsdl
        extends AnyWrapper {
        }

        @XmlRootElement(name="Main")
        @XmlType(propOrder={"archive", "functions", "portTypes"})
        public static class ServicePackage
        extends SoftwarePackage<ServicePackage> {
            @XmlElement(name="GARArchive")
            private String archive;
            @XmlElementWrapper(name="ServiceEquivalenceFunctions")
            @XmlElementRef
            private Set<Function> functions = new LinkedHashSet<Function>();
            @XmlElementRef
            private Set<PortType> portTypes = new LinkedHashSet<PortType>();

            @Override
            protected ServicePackage _this() {
                return this;
            }

            private void beforeMarshal(Marshaller marshaller) {
                super.beforeMarshal(marshaller);
                if (this.functions.isEmpty()) {
                    this.functions = null;
                }
            }

            private void afterMarshal(Marshaller marshaller) {
                super.afterMarshal(marshaller);
                if (this.functions == null) {
                    this.functions = new LinkedHashSet<Function>();
                }
            }

            public String archive() {
                return this.archive;
            }

            public ServicePackage archive(String archive) {
                this.archive = archive;
                return this;
            }

            public Group<Function> functions() {
                return new Group<Function>(this.functions, Function.class);
            }

            public Group<PortType> portTypes() {
                return new Group<PortType>(this.portTypes, PortType.class);
            }

            public Map<String, PortType> portTypeMap() {
                HashMap<String, PortType> map = new HashMap<String, PortType>();
                for (PortType p : this.portTypes) {
                    if (p.name() == null) continue;
                    map.put(p.name(), p);
                }
                return map;
            }

            @Override
            public String toString() {
                return "Main [garArchive=" + this.archive + ", function=" + this.functions + ", portTypes=" + this.portTypes + "]";
            }

            @XmlRootElement(name="Function")
            @XmlType(propOrder={"name", "formalParameters", "body"})
            public static class Function {
                @XmlElement(name="Name")
                private String name;
                @XmlElementWrapper(name="FormalParameters")
                @XmlElement(name="Name")
                private List<String> formalParameters = new ArrayList<String>();
                @XmlElementRef
                private Body body;

                public String name() {
                    return this.name;
                }

                public Function name(String name) {
                    this.name = name;
                    return this;
                }

                public List<String> formalParameters() {
                    return this.formalParameters;
                }

                public Group<String> functions() {
                    return new Group<String>(this.formalParameters, String.class);
                }

                public Element body() {
                    return this.body == null ? null : this.body.root();
                }

                public String bodyAsString() {
                    return this.body == null ? null : this.body.asString();
                }

                public Element newBody() {
                    this.body = new Body();
                    return this.body.root();
                }

                public Function newBody(String text) {
                    this.body = new Body();
                    this.body.setString(text);
                    return this;
                }

                public String toString() {
                    return " [name=" + this.name + ", formalParametersName=" + this.formalParameters + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
                    result = 31 * result + (this.formalParameters == null ? 0 : this.formalParameters.hashCode());
                    result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    Function other = (Function)obj;
                    if (this.body == null ? other.body != null : !this.body.equals(other.body)) {
                        return false;
                    }
                    if (this.formalParameters == null ? other.formalParameters != null : !this.formalParameters.equals(other.formalParameters)) {
                        return false;
                    }
                    return !(this.name == null ? other.name != null : !this.name.equals(other.name));
                }

                @XmlRootElement(name="Body")
                public static class Body
                extends AnyMixedWrapper {
                }
            }

            @XmlRootElement(name="PortType")
            public static class PortType {
                @XmlElement(name="Name")
                private String name;
                @XmlElementRef
                private Security security;
                @XmlElementRef
                private Wsdl wsdl;

                public String name() {
                    return this.name;
                }

                public PortType name(String name) {
                    this.name = name;
                    return this;
                }

                public Security security() {
                    return this.security;
                }

                public Security newSecurity() {
                    this.security = new Security();
                    return this.security;
                }

                public Element wsdl() {
                    return this.wsdl == null ? null : this.wsdl.root();
                }

                public Element newWsdl() {
                    this.wsdl = new Wsdl();
                    return this.wsdl.root();
                }

                public String toString() {
                    return " [name=" + this.name + ", security=" + this.security + ", wsdl=" + this.wsdl + "]";
                }

                @XmlRootElement(name="Security")
                public static class Security {
                    @XmlElement(name="Descriptor")
                    private SecurityDescriptor descriptor;
                    @XmlElementWrapper(name="Operations")
                    @XmlElement(name="Operation")
                    private List<Operation> operations;

                    public Element descriptor() {
                        return this.descriptor == null ? null : this.descriptor.root();
                    }

                    public Element newDescriptor() {
                        this.descriptor = new SecurityDescriptor();
                        return this.descriptor.root();
                    }

                    public Group<Operation> operations() {
                        return new Group<Operation>(this.operations, Operation.class);
                    }

                    public Map<String, Operation> portTypeMap() {
                        HashMap<String, Operation> map = new HashMap<String, Operation>();
                        for (Operation o : this.operations) {
                            if (o.name() == null) continue;
                            map.put(o.name(), o);
                        }
                        return map;
                    }

                    @XmlRootElement(name="Operation")
                    public static class Operation {
                        @XmlElement(name="id")
                        private String id;
                        @XmlAttribute(name="name")
                        private String name;
                        @XmlElement(name="description")
                        private String description;
                        @XmlElementRef
                        private Roles roles;

                        public String id() {
                            return this.id;
                        }

                        public Operation id(String id) {
                            this.id = id;
                            return this;
                        }

                        public String name() {
                            return this.name;
                        }

                        public Operation name(String name) {
                            this.name = name;
                            return this;
                        }

                        public String description() {
                            return this.description;
                        }

                        public Operation description(String desc) {
                            this.description = desc;
                            return this;
                        }

                        public Roles roles() {
                            return this.roles;
                        }

                        public Roles newRoles() {
                            this.roles = new Roles();
                            return this.roles;
                        }

                        public String toString() {
                            return " [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", roles=" + this.roles + "]";
                        }

                        @XmlRootElement(name="Roles")
                        public static class Roles {
                            @XmlElement(name="Role")
                            private List<Role> roles = new ArrayList<Role>();

                            public Group<Role> role() {
                                return new Group<Role>(this.roles, Role.class);
                            }

                            public String toString() {
                                return " [role=" + this.roles + "]";
                            }

                            @XmlRootElement(name="Role")
                            public static class Role {
                                @XmlAttribute(name="value")
                                private String value;

                                public String value() {
                                    return this.value;
                                }

                                public Role value(String value) {
                                    this.value = value;
                                    return this;
                                }

                                public String toString() {
                                    return " [value=" + this.value + "]";
                                }
                            }
                        }
                    }

                    @XmlRootElement(name="Descriptor")
                    public static class SecurityDescriptor
                    extends AnyWrapper {
                    }
                }
            }
        }

        @XmlRootElement(name="Software")
        @XmlType(propOrder={"type", "entryPoints", "files", "uri"})
        public static class GenericPackage
        extends SoftwarePackage<GenericPackage> {
            @XmlElement(name="EntryPoint")
            private Set<String> entryPoints = new LinkedHashSet<String>();
            @XmlElement(name="URI")
            private URI uri;
            @XmlElementWrapper(name="Files")
            @XmlElement(name="File")
            private Set<String> files = new LinkedHashSet<String>();
            @XmlElement(name="Type")
            private Type type;

            private void beforeMarshal(Marshaller marshaller) {
                super.beforeMarshal(marshaller);
                if (this.files.isEmpty()) {
                    this.files = null;
                }
            }

            private void afterMarshal(Marshaller marshaller) {
                super.afterMarshal(marshaller);
                if (this.files == null) {
                    this.files = new LinkedHashSet<String>();
                }
            }

            @Override
            protected GenericPackage _this() {
                return this;
            }

            public Collection<String> entryPoints() {
                return new Group<String>(this.entryPoints, String.class);
            }

            public Collection<String> files() {
                return new Group<String>(this.files, String.class);
            }

            public Type type() {
                return this.type;
            }

            public GenericPackage type(Type type) {
                this.type = type;
                return this;
            }

            public URI uri() {
                return this.uri;
            }

            public GenericPackage uri(URI uri) {
                this.uri = uri;
                return this;
            }

            @Override
            public String toString() {
                return "Software [entryPoint=" + this.entryPoints + ", uri=" + this.uri + ", files=" + this.files + ", type=" + this.type + "]";
            }

            @Override
            public int hashCode() {
                int prime = 31;
                int result = super.hashCode();
                result = 31 * result + (this.entryPoints == null ? 0 : this.entryPoints.hashCode());
                result = 31 * result + (this.files == null ? 0 : this.files.hashCode());
                result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
                result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (!super.equals(obj)) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                GenericPackage other = (GenericPackage)obj;
                if (this.entryPoints == null ? other.entryPoints != null : !this.entryPoints.equals(other.entryPoints)) {
                    return false;
                }
                if (this.files == null ? other.files != null : !this.files.equals(other.files)) {
                    return false;
                }
                if (this.type != other.type) {
                    return false;
                }
                return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
            }

            @XmlType(name="Type")
            @XmlEnum
            public static enum Type {
                library,
                application,
                plugin,
                webapplication;


                public String value() {
                    return this.name();
                }

                public static Type fromValue(String v) {
                    return Type.valueOf(v);
                }
            }
        }

        @XmlRootElement(name="Dependency")
        @XmlType(propOrder={"clazz", "name", "version"})
        public static class Dependency {
            @XmlElement(name="Class")
            private String clazz;
            @XmlElement(name="Name")
            private String name;
            @XmlElement(name="Version")
            private String version;

            public String serviceClass() {
                return this.clazz;
            }

            public Dependency serviceClass(String serviceClass) {
                this.clazz = serviceClass;
                return this;
            }

            public String serviceName() {
                return this.name;
            }

            public Dependency serviceName(String name) {
                this.name = name;
                return this;
            }

            public String version() {
                return this.version;
            }

            public Dependency version(String version) {
                this.version = version;
                return this;
            }

            public String toString() {
                return "[clazz=" + this.clazz + ", name=" + this.name + ", version=" + this.version + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
                result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Dependency other = (Dependency)obj;
                if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                    return false;
                }
                if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                    return false;
                }
                return !(this.version == null ? other.version != null : !this.version.equals(other.version));
            }
        }

        @XmlRootElement(name="Configuration")
        @XmlType(propOrder={"staticConfigurations"})
        public static class Configuration {
            @XmlElementRef
            private StaticConfigurations staticConfigurations;

            public StaticConfigurations staticConfiguration() {
                return this.staticConfigurations;
            }

            public boolean hasStaticConfigurations() {
                return this.staticConfigurations != null;
            }

            public StaticConfigurations newStaticConfiguration() {
                this.staticConfigurations = new StaticConfigurations();
                return this.staticConfigurations;
            }

            public String toString() {
                return " [static=" + this.staticConfigurations + "]";
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.staticConfigurations == null ? 0 : this.staticConfigurations.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Configuration other = (Configuration)obj;
                return !(this.staticConfigurations == null ? other.staticConfigurations != null : !this.staticConfigurations.equals(other.staticConfigurations));
            }

            @XmlRootElement(name="Static")
            @XmlType(propOrder={"configurations", "template"})
            public static class StaticConfigurations {
                @XmlElementWrapper(name="Configs")
                @XmlElementRef
                private List<StaticConfiguration> configurations = new ArrayList<StaticConfiguration>();
                @XmlElementRef
                private Template template;

                public Group<StaticConfiguration> configurations() {
                    return new Group<StaticConfiguration>(this.configurations, StaticConfiguration.class);
                }

                public Template template() {
                    return this.template;
                }

                public boolean hasTemplate() {
                    return this.template != null;
                }

                public Template newTemplate() {
                    this.template = new Template();
                    return this.template;
                }

                public String toString() {
                    return "[configurations=" + this.configurations + ", template=" + this.template + "]";
                }

                public int hashCode() {
                    int prime = 31;
                    int result = 1;
                    result = 31 * result + (this.configurations == null ? 0 : this.configurations.hashCode());
                    result = 31 * result + (this.template == null ? 0 : this.template.hashCode());
                    return result;
                }

                public boolean equals(Object obj) {
                    if (this == obj) {
                        return true;
                    }
                    if (obj == null) {
                        return false;
                    }
                    if (this.getClass() != obj.getClass()) {
                        return false;
                    }
                    StaticConfigurations other = (StaticConfigurations)obj;
                    if (this.configurations == null ? other.configurations != null : !this.configurations.equals(other.configurations)) {
                        return false;
                    }
                    return !(this.template == null ? other.template != null : !this.template.equals(other.template));
                }

                @XmlRootElement(name="Template")
                public static class Template {
                    @XmlElementWrapper(name="Params")
                    @XmlElementRef
                    private List<ConfigurationParameter> params = new ArrayList<ConfigurationParameter>();

                    public Group<ConfigurationParameter> params() {
                        return new Group<ConfigurationParameter>(this.params, ConfigurationParameter.class);
                    }

                    public Map<String, ConfigurationParameter> paramsMap() {
                        HashMap<String, ConfigurationParameter> map = new HashMap<String, ConfigurationParameter>();
                        for (ConfigurationParameter cp : this.params) {
                            if (cp.name() == null) continue;
                            map.put(cp.name(), cp);
                        }
                        return map;
                    }

                    public String toString() {
                        return "Template [params=" + this.params + "]";
                    }

                    public int hashCode() {
                        int prime = 31;
                        int result = 1;
                        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
                        return result;
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        Template other = (Template)obj;
                        return !(this.params == null ? other.params != null : !this.params.equals(other.params));
                    }

                    @XmlRootElement(name="Param")
                    public static class ConfigurationParameter {
                        @XmlElement(name="Name")
                        private String name;
                        @XmlElement(name="Description")
                        private String description;
                        @XmlElementWrapper(name="AllowedValues")
                        @XmlElementRef
                        private List<AllowedValue> allowedValues = new ArrayList<AllowedValue>();

                        public String name() {
                            return this.name;
                        }

                        public ConfigurationParameter name(String name) {
                            this.name = name;
                            return this;
                        }

                        public String description() {
                            return this.description;
                        }

                        public ConfigurationParameter description(String description) {
                            this.description = description;
                            return this;
                        }

                        public Group<AllowedValue> allowedValues() {
                            return new Group<AllowedValue>(this.allowedValues, AllowedValue.class);
                        }

                        public String toString() {
                            return "Parameter [name=" + this.name + ", description=" + this.description + ", allowedValues=" + this.allowedValues + "]";
                        }

                        public int hashCode() {
                            int prime = 31;
                            int result = 1;
                            result = 31 * result + (this.allowedValues == null ? 0 : this.allowedValues.hashCode());
                            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
                            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                            return result;
                        }

                        public boolean equals(Object obj) {
                            if (this == obj) {
                                return true;
                            }
                            if (obj == null) {
                                return false;
                            }
                            if (this.getClass() != obj.getClass()) {
                                return false;
                            }
                            ConfigurationParameter other = (ConfigurationParameter)obj;
                            if (this.allowedValues == null ? other.allowedValues != null : !this.allowedValues.equals(other.allowedValues)) {
                                return false;
                            }
                            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                                return false;
                            }
                            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
                        }

                        @XmlRootElement(name="Value")
                        public static class AllowedValue {
                            @XmlElement(name="Description")
                            private String description;
                            @XmlElement(name="Literal")
                            private String literal;
                            @XmlElement(name="Label")
                            private String label;
                            @XmlAttribute(name="default")
                            private boolean isDefault;

                            public String description() {
                                return this.description;
                            }

                            public AllowedValue description(String desc) {
                                this.description = desc;
                                return this;
                            }

                            public String literal() {
                                return this.literal;
                            }

                            public AllowedValue literal(String lit) {
                                this.literal = lit;
                                return this;
                            }

                            public String label() {
                                return this.label;
                            }

                            public AllowedValue label(String label) {
                                this.label = label;
                                return this;
                            }

                            public boolean isDefault() {
                                return this.isDefault;
                            }

                            public AllowedValue isDefault(boolean def) {
                                this.isDefault = def;
                                return this;
                            }

                            public String toString() {
                                return " [description=" + this.description + ", literal=" + this.literal + ", label=" + this.label + ", isDefault=" + this.isDefault + "]";
                            }

                            public int hashCode() {
                                int prime = 31;
                                int result = 1;
                                result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
                                result = 31 * result + (this.isDefault ? 1231 : 1237);
                                result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
                                result = 31 * result + (this.literal == null ? 0 : this.literal.hashCode());
                                return result;
                            }

                            public boolean equals(Object obj) {
                                if (this == obj) {
                                    return true;
                                }
                                if (obj == null) {
                                    return false;
                                }
                                if (this.getClass() != obj.getClass()) {
                                    return false;
                                }
                                AllowedValue other = (AllowedValue)obj;
                                if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                                    return false;
                                }
                                if (this.isDefault != other.isDefault) {
                                    return false;
                                }
                                if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
                                    return false;
                                }
                                return !(this.literal == null ? other.literal != null : !this.literal.equals(other.literal));
                            }
                        }
                    }
                }

                @XmlRootElement(name="Config")
                @XmlType(propOrder={"file", "description", "label"})
                public static class StaticConfiguration {
                    @XmlElement(name="File")
                    private String file;
                    @XmlElement(name="Description")
                    private String description;
                    @XmlElement(name="Label")
                    private String label;
                    @XmlAttribute(name="default")
                    private boolean default_;

                    public boolean isDefault() {
                        return this.default_;
                    }

                    public StaticConfiguration isDefault(boolean value) {
                        this.default_ = value;
                        return this;
                    }

                    public String file() {
                        return this.file;
                    }

                    public StaticConfiguration file(String file) {
                        this.file = file;
                        return this;
                    }

                    public String description() {
                        return this.description;
                    }

                    public StaticConfiguration description(String description) {
                        this.description = description;
                        return this;
                    }

                    public String label() {
                        return this.label;
                    }

                    public StaticConfiguration label(String label) {
                        this.label = label;
                        return this;
                    }

                    public String toString() {
                        return "Configuration [file=" + this.file + ", description=" + this.description + ", label=" + this.label + "]";
                    }

                    public int hashCode() {
                        int prime = 31;
                        int result = 1;
                        result = 31 * result + (this.default_ ? 1231 : 1237);
                        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
                        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
                        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
                        return result;
                    }

                    public boolean equals(Object obj) {
                        if (this == obj) {
                            return true;
                        }
                        if (obj == null) {
                            return false;
                        }
                        if (this.getClass() != obj.getClass()) {
                            return false;
                        }
                        StaticConfiguration other = (StaticConfiguration)obj;
                        if (this.default_ != other.default_) {
                            return false;
                        }
                        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                            return false;
                        }
                        if (this.file == null ? other.file != null : !this.file.equals(other.file)) {
                            return false;
                        }
                        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
                    }
                }
            }
        }

        @XmlRootElement(name="SpecificData")
        public static class SpecificData
        extends AnyMixedWrapper {
        }
    }
}

