/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.gxrest.response.inbound;

import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.gcube.common.gxrest.response.entity.StackTraceEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ExceptionDeserializer {
    private static final Logger logger = LoggerFactory.getLogger(ExceptionDeserializer.class);

    private ExceptionDeserializer() {
    }

    protected static <E extends Exception> E deserialize(String exceptionClass, String message) {
        try {
            Class[] ctorParams = new Class[]{String.class};
            return (E)((Exception)Class.forName(exceptionClass).getConstructor(ctorParams).newInstance(message));
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error("Failed to deserialize: " + exceptionClass);
            return null;
        }
    }

    protected static <E extends Exception> void addStackTrace(E exception, String joinedTrace) {
        if (Objects.nonNull(exception)) {
            exception.setStackTrace(StackTraceEncoder.decodeTrace(joinedTrace));
        }
    }
}

