/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.model.reference.properties;

import java.util.Date;
import org.gcube.com.fasterxml.jackson.annotation.JsonFormat;
import org.gcube.com.fasterxml.jackson.annotation.JsonInclude;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.model.impl.properties.EventImpl;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;

@JsonDeserialize(as=EventImpl.class)
@TypeMetadata(name="Event", description="This type provides information regarding an event using the Five Ws (checklist) https://en.wikipedia.org/wiki/Five_Ws", version="1.0.0")
@Change(version="1.0.0", description="First Version")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public interface Event
extends Property,
Comparable<Event> {
    public static final String NAME = "Event";
    public static final String WHAT_PROPERTY = "what";
    public static final String WHEN_PROPERTY = "when";
    public static final String WHO_PROPERTY = "who";
    public static final String WHERE_PROPERTY = "where";
    public static final String WHY_PROPERTY = "why";
    public static final String HOW_PROPERTY = "how";

    @ISProperty(name="what", description="WHAT happened.", readonly=true, mandatory=true, nullable=false)
    public String getWhat();

    public void setWhat(String var1);

    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss.SSS Z")
    @ISProperty(name="when", description="WHEN the event occured. It is represented in the format yyyy-MM-dd HH:mm:ss.SSS Z.", readonly=true, mandatory=true, nullable=false)
    public Date getWhen();

    public void setWhen(Date var1);

    @ISProperty(name="who", description="WHO triggered the event.", readonly=true, mandatory=false, nullable=false)
    public String getWho();

    public void setWho(String var1);

    @ISProperty(name="where", description="The location (can be virtual) WHERE the event occurred.", readonly=true, mandatory=false, nullable=false)
    public String getWhere();

    public void setWhere(String var1);

    @ISProperty(name="why", description="The reason WHY the event occurred.", readonly=true, mandatory=false, nullable=false)
    public String getWhy();

    public void setWhy(String var1);

    @ISProperty(name="how", description="How the event occurred.", readonly=true, mandatory=false, nullable=false)
    public String getHow();

    public void setHow(String var1);
}

