/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scope.impl;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ServiceMapAdapter
extends XmlAdapter<ValueServiceMap, Map<String, String>> {
    public Map<String, String> unmarshal(ValueServiceMap valueMap) throws Exception {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (ServiceEntry service : valueMap.services) {
            map.put(service.name, service.endpoint);
        }
        return map;
    }

    public ValueServiceMap marshal(Map<String, String> map) throws Exception {
        HashSet<ServiceEntry> entries = new HashSet<ServiceEntry>();
        ValueServiceMap valueMap = new ValueServiceMap();
        for (Map.Entry<String, String> e : map.entrySet()) {
            ServiceEntry entry = new ServiceEntry();
            entry.name = e.getKey();
            entry.endpoint = e.getValue();
            entries.add(entry);
        }
        valueMap.services = entries;
        return valueMap;
    }

    static class ServiceEntry {
        @XmlAttribute
        private String name;
        @XmlAttribute
        private String endpoint;

        ServiceEntry() {
        }
    }

    @XmlRootElement(name="services")
    static class ValueServiceMap {
        @XmlElement(name="service")
        Set<ServiceEntry> services;

        ValueServiceMap() {
        }
    }
}

