/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.keycloak.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.common.keycloak.model.IDToken;

public class AccessToken
extends IDToken {
    private static final long serialVersionUID = 6364784008775737335L;
    @JsonProperty(value="trusted-certs")
    protected Set<String> trustedCertificates;
    @JsonProperty(value="allowed-origins")
    protected Set<String> allowedOrigins;
    @JsonProperty(value="realm_access")
    protected Access realmAccess;
    @JsonProperty(value="resource_access")
    protected Map<String, Access> resourceAccess;
    @JsonProperty(value="scope")
    protected String scope;

    @JsonIgnore
    public Map<String, Access> getResourceAccess() {
        return this.resourceAccess == null ? Collections.emptyMap() : this.resourceAccess;
    }

    public void setResourceAccess(Map<String, Access> resourceAccess) {
        this.resourceAccess = resourceAccess;
    }

    public Access addAccess(String service) {
        Access access;
        if (this.resourceAccess == null) {
            this.resourceAccess = new HashMap<String, Access>();
        }
        if ((access = this.resourceAccess.get(service)) != null) {
            return access;
        }
        access = new Access();
        this.resourceAccess.put(service, access);
        return access;
    }

    @Override
    public AccessToken id(String id) {
        return (AccessToken)super.id(id);
    }

    @Override
    public AccessToken issuer(String issuer) {
        return (AccessToken)super.issuer(issuer);
    }

    @Override
    public AccessToken subject(String subject) {
        return (AccessToken)super.subject(subject);
    }

    @Override
    public AccessToken type(String type) {
        return (AccessToken)super.type(type);
    }

    public Set<String> getAllowedOrigins() {
        return this.allowedOrigins;
    }

    public void setAllowedOrigins(Set<String> allowedOrigins) {
        this.allowedOrigins = allowedOrigins;
    }

    public Access getRealmAccess() {
        return this.realmAccess;
    }

    public void setRealmAccess(Access realmAccess) {
        this.realmAccess = realmAccess;
    }

    public Set<String> getTrustedCertificates() {
        return this.trustedCertificates;
    }

    public void setTrustedCertificates(Set<String> trustedCertificates) {
        this.trustedCertificates = trustedCertificates;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public static class Access
    implements Serializable {
        private static final long serialVersionUID = 1634782115467850693L;
        @JsonProperty(value="roles")
        protected Set<String> roles;
        @JsonProperty(value="verify_caller")
        protected Boolean verifyCaller;

        public Access clone() {
            Access access = new Access();
            access.verifyCaller = this.verifyCaller;
            if (this.roles != null) {
                access.roles = new HashSet<String>();
                access.roles.addAll(this.roles);
            }
            return access;
        }

        public Set<String> getRoles() {
            return this.roles;
        }

        public Access roles(Set<String> roles) {
            this.roles = roles;
            return this;
        }

        @JsonIgnore
        public boolean isUserInRole(String role) {
            if (this.roles == null) {
                return false;
            }
            return this.roles.contains(role);
        }

        public Access addRole(String role) {
            if (this.roles == null) {
                this.roles = new HashSet<String>();
            }
            this.roles.add(role);
            return this;
        }

        public Boolean getVerifyCaller() {
            return this.verifyCaller;
        }

        public Access verifyCaller(Boolean required) {
            this.verifyCaller = required;
            return this;
        }

        public String toString() {
            return this.getRoles() != null ? this.getRoles().toString() : null;
        }
    }
}

