/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Collection;
import javax.crypto.SecretKey;
import org.gcube.io.jsonwebtoken.impl.lang.DefaultNestedCollection;
import org.gcube.io.jsonwebtoken.impl.lang.DelegatingMapMutator;
import org.gcube.io.jsonwebtoken.impl.lang.IdRegistry;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.impl.lang.Parameters;
import org.gcube.io.jsonwebtoken.impl.security.AbstractJwk;
import org.gcube.io.jsonwebtoken.impl.security.DefaultMacAlgorithm;
import org.gcube.io.jsonwebtoken.impl.security.DispatchingJwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.JwkContext;
import org.gcube.io.jsonwebtoken.impl.security.JwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.KeyOperationConverter;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.NestedCollection;
import org.gcube.io.jsonwebtoken.security.HashAlgorithm;
import org.gcube.io.jsonwebtoken.security.Jwk;
import org.gcube.io.jsonwebtoken.security.JwkBuilder;
import org.gcube.io.jsonwebtoken.security.Jwks;
import org.gcube.io.jsonwebtoken.security.KeyOperation;
import org.gcube.io.jsonwebtoken.security.KeyOperationPolicy;
import org.gcube.io.jsonwebtoken.security.MalformedKeyException;
import org.gcube.io.jsonwebtoken.security.SecretJwk;
import org.gcube.io.jsonwebtoken.security.SecretJwkBuilder;

abstract class AbstractJwkBuilder<K extends Key, J extends Jwk<K>, T extends JwkBuilder<K, J, T>>
extends DelegatingMapMutator<String, Object, JwkContext<K>, T>
implements JwkBuilder<K, J, T> {
    protected final JwkFactory<K, J> jwkFactory;
    static final KeyOperationPolicy DEFAULT_OPERATION_POLICY = (KeyOperationPolicy)Jwks.OP.policy().build();
    protected KeyOperationPolicy opsPolicy = DEFAULT_OPERATION_POLICY;

    protected AbstractJwkBuilder(JwkContext<K> jwkContext) {
        this(jwkContext, DispatchingJwkFactory.DEFAULT_INSTANCE);
    }

    protected AbstractJwkBuilder(JwkContext<K> context, JwkFactory<K, J> factory) {
        super(context);
        this.jwkFactory = (JwkFactory)Assert.notNull(factory, (String)"JwkFactory cannot be null.");
    }

    protected <A extends Key> JwkContext<A> newContext(A key) {
        return this.jwkFactory.newContext((JwkContext)this.DELEGATE, key);
    }

    public T provider(Provider provider) {
        ((JwkContext)this.DELEGATE).setProvider(provider);
        return (T)((JwkBuilder)this.self());
    }

    public T random(SecureRandom random) {
        ((JwkContext)this.DELEGATE).setRandom(random);
        return (T)((JwkBuilder)this.self());
    }

    public T algorithm(String alg) {
        Assert.hasText((CharSequence)alg, (String)"Algorithm cannot be null or empty.");
        ((JwkContext)this.DELEGATE).setAlgorithm(alg);
        return (T)((JwkBuilder)this.self());
    }

    public T id(String id) {
        Assert.hasText((CharSequence)id, (String)"Id cannot be null or empty.");
        ((JwkContext)this.DELEGATE).setIdThumbprintAlgorithm(null);
        ((JwkContext)this.DELEGATE).setId(id);
        return (T)((JwkBuilder)this.self());
    }

    public T idFromThumbprint() {
        return this.idFromThumbprint(Jwks.HASH.SHA256);
    }

    public T idFromThumbprint(HashAlgorithm alg) {
        Assert.notNull((Object)alg, (String)"Thumbprint HashAlgorithm cannot be null.");
        Assert.notNull((Object)alg.getId(), (String)"Thumbprint HashAlgorithm ID cannot be null.");
        ((JwkContext)this.DELEGATE).setId(null);
        ((JwkContext)this.DELEGATE).setIdThumbprintAlgorithm(alg);
        return (T)((JwkBuilder)this.self());
    }

    public NestedCollection<KeyOperation, T> operations() {
        return new DefaultNestedCollection<KeyOperation, T>((JwkBuilder)this.self(), ((JwkContext)this.DELEGATE).getOperations()){

            @Override
            protected void changed() {
                Collection c = this.getCollection();
                AbstractJwkBuilder.this.opsPolicy.validate(c);
                ((JwkContext)AbstractJwkBuilder.this.DELEGATE).setOperations(c);
            }
        };
    }

    public T operationPolicy(KeyOperationPolicy policy) throws IllegalArgumentException {
        Assert.notNull((Object)policy, (String)"Policy cannot be null.");
        Collection ops = policy.getOperations();
        Assert.notEmpty((Collection)ops, (String)"Policy operations cannot be null or empty.");
        this.opsPolicy = policy;
        IdRegistry<KeyOperation> registry = new IdRegistry<KeyOperation>("JSON Web Key Operation", ops);
        Parameter param = (Parameter)Parameters.builder(KeyOperation.class).setConverter(new KeyOperationConverter(registry)).set().setId(AbstractJwk.KEY_OPS.getId()).setName(AbstractJwk.KEY_OPS.getName()).build();
        this.setDelegate(((JwkContext)this.DELEGATE).parameter(param));
        return (T)((JwkBuilder)this.self());
    }

    public J build() {
        Assert.stateNotNull((Object)this.DELEGATE, (String)"JwkContext should always be non-null");
        Object key = ((JwkContext)this.DELEGATE).getKey();
        if (key == null && this.isEmpty()) {
            String msg = "A " + Key.class.getName() + " or one or more name/value pairs must be provided to create a JWK.";
            throw new IllegalStateException(msg);
        }
        try {
            this.opsPolicy.validate((Collection)((JwkContext)this.DELEGATE).get(AbstractJwk.KEY_OPS));
            return this.jwkFactory.createJwk((JwkContext)this.DELEGATE);
        }
        catch (IllegalArgumentException iae) {
            String msg = "Unable to create JWK: " + iae.getMessage();
            throw new MalformedKeyException(msg, (Throwable)iae);
        }
    }

    static class DefaultSecretJwkBuilder
    extends AbstractJwkBuilder<SecretKey, SecretJwk, SecretJwkBuilder>
    implements SecretJwkBuilder {
        public DefaultSecretJwkBuilder(JwkContext<SecretKey> ctx) {
            super(ctx);
            Key key = (Key)Assert.notNull((Object)ctx.getKey(), (String)"SecretKey cannot be null.");
            DefaultMacAlgorithm mac = DefaultMacAlgorithm.findByKey(key);
            if (mac != null) {
                this.algorithm(mac.getId());
            }
        }
    }
}

