/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.library.policies;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.authorization.library.policies.Role;
import org.gcube.common.authorization.library.policies.User;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlSeeAlso(value={User.class, Role.class})
public abstract class UserEntity {
    private String identifier = null;
    private List<String> excludes = new ArrayList<String>();

    protected UserEntity() {
    }

    protected UserEntity(String identifier) {
        this.identifier = identifier;
    }

    protected UserEntity(List<String> excludes) {
        if (excludes == null || excludes.isEmpty()) {
            throw new IllegalArgumentException("list of excludes cannot be empty");
        }
        this.excludes = excludes;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public abstract UserEntityType getType();

    public final String getAsString() {
        if (this.identifier != null) {
            return this.getType() + ":" + this.identifier;
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            return this.getType() + ":allExcept" + this.excludes;
        }
        return this.getType() + ":*";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.excludes == null ? 0 : this.excludes.hashCode());
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserEntity other = (UserEntity)obj;
        if (this.excludes == null ? other.excludes != null : !this.excludes.equals(other.excludes)) {
            return false;
        }
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }

    public String toString() {
        return "UserEntity [ " + this.getAsString() + " ]";
    }

    public abstract boolean isSubsetOf(UserEntity var1);

    public static enum UserEntityType {
        ROLE,
        USER,
        EXTERNALSERVICE;

    }
}

