/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import org.gcube.io.jsonwebtoken.impl.security.AbstractJwk;
import org.gcube.io.jsonwebtoken.impl.security.AsymmetricJwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.EcPrivateJwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.EcPublicJwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.FamilyJwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.JwkContext;
import org.gcube.io.jsonwebtoken.impl.security.JwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.OctetPrivateJwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.OctetPublicJwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.RsaPrivateJwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.RsaPublicJwkFactory;
import org.gcube.io.jsonwebtoken.impl.security.SecretJwkFactory;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Strings;
import org.gcube.io.jsonwebtoken.security.InvalidKeyException;
import org.gcube.io.jsonwebtoken.security.Jwk;
import org.gcube.io.jsonwebtoken.security.UnsupportedKeyException;

class DispatchingJwkFactory
implements JwkFactory<Key, Jwk<Key>> {
    private static final Collection<FamilyJwkFactory<Key, ?>> DEFAULT_FACTORIES = DispatchingJwkFactory.createDefaultFactories();
    static final JwkFactory<Key, Jwk<Key>> DEFAULT_INSTANCE = new DispatchingJwkFactory();
    private final Collection<FamilyJwkFactory<Key, ?>> factories;

    private static Collection<FamilyJwkFactory<Key, ?>> createDefaultFactories() {
        ArrayList families = new ArrayList(3);
        families.add(new SecretJwkFactory());
        families.add(new AsymmetricJwkFactory(EcPublicJwkFactory.INSTANCE, new EcPrivateJwkFactory()));
        families.add(new AsymmetricJwkFactory(RsaPublicJwkFactory.INSTANCE, new RsaPrivateJwkFactory()));
        families.add(new AsymmetricJwkFactory(OctetPublicJwkFactory.INSTANCE, new OctetPrivateJwkFactory()));
        return families;
    }

    DispatchingJwkFactory() {
        this(DEFAULT_FACTORIES);
    }

    DispatchingJwkFactory(Collection<? extends FamilyJwkFactory<?, ?>> factories) {
        Assert.notEmpty(factories, (String)"FamilyJwkFactory collection cannot be null or empty.");
        this.factories = new ArrayList(factories.size());
        for (FamilyJwkFactory<?, ?> factory : factories) {
            Assert.hasText((CharSequence)factory.getId(), (String)"FamilyJwkFactory.getFactoryId() cannot return null or empty.");
            this.factories.add(factory);
        }
    }

    @Override
    public JwkContext<Key> newContext(JwkContext<?> src, Key key) {
        Assert.notNull(src, (String)"JwkContext cannot be null.");
        String kty = src.getType();
        DispatchingJwkFactory.assertKeyOrKeyType(key, kty);
        for (FamilyJwkFactory<Key, ?> factory : this.factories) {
            if (!factory.supports(key) && !factory.supports(src)) continue;
            JwkContext<Key> ctx = factory.newContext(src, key);
            return (JwkContext)Assert.notNull(ctx, (String)"FamilyJwkFactory implementation cannot return null JwkContexts.");
        }
        throw DispatchingJwkFactory.noFamily(key, kty);
    }

    private static void assertKeyOrKeyType(Key key, String kty) {
        if (key == null && !Strings.hasText((String)kty)) {
            String msg = "Either a Key instance or a " + AbstractJwk.KTY + " value is required to create a JWK.";
            throw new InvalidKeyException(msg);
        }
    }

    @Override
    public Jwk<Key> createJwk(JwkContext<Key> ctx) {
        Assert.notNull(ctx, (String)"JwkContext cannot be null.");
        Key key = ctx.getKey();
        String kty = Strings.clean((String)ctx.getType());
        DispatchingJwkFactory.assertKeyOrKeyType(key, kty);
        for (FamilyJwkFactory<Key, ?> factory : this.factories) {
            if (!factory.supports(ctx)) continue;
            String algFamilyId = (String)Assert.hasText((CharSequence)factory.getId(), (String)"factory id cannot be null or empty.");
            if (kty == null) {
                ctx.setType(algFamilyId);
            }
            return factory.createJwk(ctx);
        }
        throw DispatchingJwkFactory.noFamily(key, kty);
    }

    private static UnsupportedKeyException noFamily(Key key, String kty) {
        String reason = key != null ? "key of type " + key.getClass().getName() : "kty value '" + kty + "'";
        String msg = "Unable to create JWK for unrecognized " + reason + ": there is no known JWK Factory capable of creating JWKs for this key type.";
        return new UnsupportedKeyException(msg);
    }
}

