/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.security.credentials;

import java.util.Base64;
import java.util.Set;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.security.secrets.Secret;
import org.gcube.common.validator.annotations.NotEmpty;
import org.gcube.common.validator.annotations.NotNull;
import org.gcube.documentstore.security.credentials.ClientIdCredentials;
import org.gcube.documentstore.security.credentials.DocumentStoreCredential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCredentials
implements DocumentStoreCredential {
    private static Logger logger = LoggerFactory.getLogger(UserCredentials.class);
    @NotNull
    @NotEmpty
    String username;
    @NotNull
    @NotEmpty
    String password;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String clientID) {
        this.username = clientID;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String secret) {
        this.password = secret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientIdCredentials other = (ClientIdCredentials)obj;
        if (this.username == null ? other.clientID != null : !this.username.equals(other.clientID)) {
            return false;
        }
        return !(this.password == null ? other.secret != null : !this.password.equals(other.secret));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [username=" + this.username + ", password=" + this.password + "]";
    }

    @Override
    public Set<String> getContexts(KeycloakClient client, String endpoint) {
        throw new UnsupportedOperationException("Unimplemented method 'getContexts'");
    }

    protected static String constructBasicAuthenticationHeader(String clientId, String clientSecret) {
        return "Basic " + Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes());
    }

    @Override
    public Secret getSecretForContext(KeycloakClient client, String endpoint, String context) {
        throw new UnsupportedOperationException("Unimplemented method 'getSecretForContext'");
    }
}

