/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.library.endpoints;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import org.gcube.common.authorization.library.endpoints.AuthorizationEndpoint;
import org.gcube.common.authorization.library.endpoints.EndpointsContainer;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationEndpointScanner {
    private static Logger log = LoggerFactory.getLogger(AuthorizationEndpointScanner.class);
    private static EndpointsContainer endpoints;
    static final String configurationPattern = ".*\\.authorization";

    public static synchronized EndpointsContainer endpoints() {
        if (endpoints == null || endpoints.getEndpoints().size() == 0) {
            log.trace("starting  authorization endpoint retrieving");
            HashMap<String, AuthorizationEndpoint> endpointsMap = new HashMap<String, AuthorizationEndpoint>();
            try {
                ConfigurationBuilder reflectionConf = new ConfigurationBuilder().addUrls(ClasspathHelper.forJavaClassPath()).addUrls(ClasspathHelper.forClassLoader()).addClassLoader(AuthorizationEndpointScanner.class.getClassLoader()).setScanners(new Scanner[]{new ResourcesScanner()});
                Reflections reflection = new Reflections((Configuration)reflectionConf);
                Set resources = reflection.getResources(input -> input.endsWith(".authorization"));
                log.info("loading resources {} ", (Object)resources);
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AuthorizationEndpoint.class});
                Unmarshaller um = context.createUnmarshaller();
                String defaultInfrastructure = null;
                int defaultInfraPriority = Integer.MAX_VALUE;
                for (String resource : resources) {
                    log.info("loading {} ", (Object)resource);
                    URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
                    AuthorizationEndpoint endpoint = (AuthorizationEndpoint)um.unmarshal(url);
                    if (defaultInfrastructure == null) {
                        defaultInfrastructure = endpoint.getInfrastructure();
                    }
                    if (!endpointsMap.containsKey(endpoint.getInfrastructure()) || ((AuthorizationEndpoint)endpointsMap.get(endpoint.getInfrastructure())).getPriority() > endpoint.getPriority()) {
                        if (resource.startsWith("default") && endpoint.getPriority() < defaultInfraPriority) {
                            defaultInfrastructure = endpoint.getInfrastructure();
                            defaultInfraPriority = endpoint.getPriority();
                        }
                        endpointsMap.put(endpoint.getInfrastructure(), endpoint);
                    }
                    log.info("loaded endpoint {} ", (Object)endpoint.toString());
                }
                if (endpointsMap.size() == 0) {
                    throw new Exception("no endpoints retreived");
                }
                endpoints = new EndpointsContainer(endpointsMap, defaultInfrastructure);
                log.trace("authorization endpoint retrieving finished");
            }
            catch (Throwable e) {
                log.error("error scanning auth endpoints", e);
                throw new RuntimeException("could not load auth endpoints", e);
            }
        }
        return endpoints;
    }
}

