/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.keycloak;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.gxhttp.util.ContentUtils;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.KeycloakClientException;
import org.gcube.common.keycloak.model.AccessToken;
import org.gcube.common.keycloak.model.JSONWebKeySet;
import org.gcube.common.keycloak.model.ModelUtils;
import org.gcube.common.keycloak.model.PublishedRealmRepresentation;
import org.gcube.common.keycloak.model.TokenIntrospectionResponse;
import org.gcube.common.keycloak.model.TokenResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKeycloakClient
implements KeycloakClient {
    protected static Logger logger = LoggerFactory.getLogger(KeycloakClient.class);
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String DEFAULT_BASE_URL = "https://url.d4science.org/auth/realms/";
    private String customBaseURL = null;
    private List<String> scopes = new ArrayList<String>();
    private boolean useDynamicScopeInsteadOfCustomHeaderForContextRestricion = false;

    public void setCustomBaseURL(String customBaseURL) {
        this.customBaseURL = customBaseURL == null || ((String)customBaseURL).endsWith("/") ? customBaseURL : (customBaseURL = (String)customBaseURL + "/");
    }

    @Override
    public KeycloakClient useScopes(List<String> scopes) {
        this.scopes.clear();
        this.scopes.addAll(scopes);
        return this;
    }

    @Override
    public KeycloakClient addScopes(List<String> scopes) {
        this.scopes.addAll(scopes);
        return this;
    }

    @Override
    public KeycloakClient removeScopes(List<String> scopes) {
        this.scopes.removeAll(scopes);
        return this;
    }

    @Override
    public KeycloakClient addDynamicScope(String dynamicScope, String value) {
        this.scopes.add(DefaultKeycloakClient.constructDynamicScope(dynamicScope, value));
        return this;
    }

    protected static String constructDynamicScope(String dynamicScope, String value) {
        return dynamicScope + ":" + value;
    }

    @Override
    public KeycloakClient removeAllScopes() {
        this.scopes.clear();
        return this;
    }

    @Override
    public KeycloakClient useDynamicScopeInsteadOfCustomHeaderForContextRestricion(boolean useDynamicScopeInsteadOfCustomHeaderForContextRestricion) {
        this.useDynamicScopeInsteadOfCustomHeaderForContextRestricion = useDynamicScopeInsteadOfCustomHeaderForContextRestricion;
        return this;
    }

    public String getCustomBaseURL() {
        return this.customBaseURL;
    }

    @Override
    public URL getRealmBaseURL(String context) throws KeycloakClientException {
        return this.getRealmBaseURL(context, "d4science");
    }

    @Override
    public URL getRealmBaseURL(String context, String realm) throws KeycloakClientException {
        Object realmBaseURLString = null;
        if (this.getCustomBaseURL() != null) {
            realmBaseURLString = this.getCustomBaseURL() + realm + "/";
        } else {
            realmBaseURLString = DEFAULT_BASE_URL + realm + "/";
            if (!context.startsWith("/d4science.research-infrastructures.eu")) {
                String root = DefaultKeycloakClient.checkContext(context).split("/")[1];
                realmBaseURLString = ((String)realmBaseURLString).replace("url", "url." + root.replaceAll("\\.", "-"));
            }
        }
        try {
            return new URL((String)realmBaseURLString);
        }
        catch (MalformedURLException e) {
            logger.error("Cannot create base URL from string: {}", realmBaseURLString, (Object)e);
            return null;
        }
    }

    private static String checkContext(String context) {
        if (!context.startsWith("/")) {
            try {
                logger.trace("Context was provided in URL encoded form, decoding it");
                return URLDecoder.decode(context, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Cannot URL decode 'context'", (Throwable)e);
            }
        }
        return context;
    }

    @Override
    public URL getTokenEndpointURL(URL realmBaseURL) throws KeycloakClientException {
        logger.debug("Constructing token endpoint URL starting from base URL: {}", (Object)realmBaseURL);
        try {
            URL tokenURL = null;
            tokenURL = realmBaseURL.getPath().endsWith("/") ? new URL(realmBaseURL, "protocol/openid-connect/token") : new URL(realmBaseURL.toString() + "/protocol/openid-connect/token");
            logger.debug("Constructed token URL is: {}", (Object)tokenURL);
            return tokenURL;
        }
        catch (MalformedURLException e) {
            throw new KeycloakClientException("Cannot constructs token URL from base URL: " + String.valueOf(realmBaseURL), e);
        }
    }

    @Override
    public URL getJWKEndpointURL(URL realmBaseURL) throws KeycloakClientException {
        logger.debug("Constructing JWK endpoint URL starting from base URL: {}", (Object)realmBaseURL);
        try {
            URL jwkURL = null;
            jwkURL = realmBaseURL.getPath().endsWith("/") ? new URL(realmBaseURL, "protocol/openid-connect/certs") : new URL(realmBaseURL.toString() + "/protocol/openid-connect/certs");
            logger.debug("Constructed JWK URL is: {}", (Object)jwkURL);
            return jwkURL;
        }
        catch (MalformedURLException e) {
            throw new KeycloakClientException("Cannot constructs JWK URL from base URL: " + String.valueOf(realmBaseURL), e);
        }
    }

    @Override
    public URL getIntrospectionEndpointURL(URL realmBaseURL) throws KeycloakClientException {
        logger.debug("Constructing introspection URL starting from base URL: {}", (Object)realmBaseURL);
        try {
            URL tokenURL = null;
            tokenURL = realmBaseURL.getPath().endsWith("/") ? new URL(realmBaseURL, "protocol/openid-connect/token/introspect") : new URL(realmBaseURL.toString() + "/protocol/openid-connect/token/introspect");
            logger.debug("Constructed introspection URL is: {}", (Object)tokenURL);
            return tokenURL;
        }
        catch (MalformedURLException e) {
            throw new KeycloakClientException("Cannot constructs introspection URL from base URL: " + String.valueOf(realmBaseURL), e);
        }
    }

    @Override
    public URL getAvatarEndpointURL(URL realmBaseURL) throws KeycloakClientException {
        logger.debug("Constructing token endpoint URL starting from base URL: {}", (Object)realmBaseURL);
        try {
            URL tokenURL = null;
            tokenURL = realmBaseURL.getPath().endsWith("/") ? new URL(realmBaseURL, "account-avatar") : new URL(realmBaseURL.toString() + "/account-avatar");
            logger.debug("Constructed avatar URL is: {}", (Object)tokenURL);
            return tokenURL;
        }
        catch (MalformedURLException e) {
            throw new KeycloakClientException("Cannot constructs avatar URL from base URL: " + String.valueOf(realmBaseURL), e);
        }
    }

    @Override
    public URL computeIntrospectionEndpointURL(URL tokenEndpointURL) throws KeycloakClientException {
        logger.debug("Computing introspection endpoint URL starting from token endpoint URL: {}", (Object)tokenEndpointURL);
        try {
            URL introspectionURL = null;
            introspectionURL = tokenEndpointURL.getPath().endsWith("token/") ? new URL(tokenEndpointURL, "introspect") : new URL(tokenEndpointURL, "token/introspect");
            logger.debug("Computed introspection URL is: {}", (Object)introspectionURL);
            return introspectionURL;
        }
        catch (MalformedURLException e) {
            throw new KeycloakClientException("Cannot compute introspection URL from token URL: " + String.valueOf(tokenEndpointURL), e);
        }
    }

    @Override
    public PublishedRealmRepresentation getRealmInfo(URL realmURL) throws KeycloakClientException {
        try {
            return (PublishedRealmRepresentation)new ObjectMapper().readValue(ContentUtils.toByteArray((InputStream)realmURL.openStream()), PublishedRealmRepresentation.class);
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot deserialize to the object getting realm's info", e);
        }
    }

    @Override
    public JSONWebKeySet getRealmJSONWebKeySet(URL jwkURL) throws KeycloakClientException {
        try {
            return (JSONWebKeySet)new ObjectMapper().readValue(ContentUtils.toByteArray((InputStream)jwkURL.openStream()), JSONWebKeySet.class);
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot deserialize to the object getting realm's JWK", e);
        }
    }

    @Override
    public TokenResponse queryOIDCToken(String context, String clientId, String clientSecret) throws KeycloakClientException {
        return this.queryOIDCToken(context, clientId, clientSecret, null);
    }

    @Override
    public TokenResponse queryOIDCToken(String context, String clientId, String clientSecret, Map<String, String> extraHeaders) throws KeycloakClientException {
        return this.queryOIDCToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, extraHeaders);
    }

    @Override
    public TokenResponse queryOIDCToken(URL tokenURL, String clientId, String clientSecret) throws KeycloakClientException {
        return this.queryOIDCToken(tokenURL, clientId, clientSecret, null);
    }

    @Override
    public TokenResponse queryOIDCToken(URL tokenURL, String clientId, String clientSecret, Map<String, String> extraHeaders) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(tokenURL, clientId, clientSecret, null, extraHeaders);
    }

    @Override
    public TokenResponse queryOIDCToken(String context, String authorization) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(context, authorization, null);
    }

    @Override
    public TokenResponse queryOIDCToken(URL tokenURL, String authorization) throws KeycloakClientException {
        return this.queryOIDCToken(tokenURL, authorization, (Map<String, String>)null);
    }

    @Override
    public TokenResponse queryOIDCToken(String context, String authorization, Map<String, String> extraHeaders) throws KeycloakClientException {
        return this.queryOIDCToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), authorization, extraHeaders);
    }

    @Override
    public TokenResponse queryOIDCToken(URL tokenURL, String authorization, Map<String, String> extraHeaders) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(tokenURL, authorization, null, extraHeaders);
    }

    @Override
    public TokenResponse queryOIDCTokenOfUser(String context, String clientId, String clientSecret, String username, String password) throws KeycloakClientException {
        return this.queryOIDCTokenOfUser(context, clientId, clientSecret, username, password, null);
    }

    @Override
    public TokenResponse queryOIDCTokenOfUser(String context, String clientId, String clientSecret, String username, String password, Map<String, String> extraHeaders) throws KeycloakClientException {
        return this.queryOIDCTokenOfUserWithContext(context, clientId, clientSecret, username, password, null, extraHeaders);
    }

    @Override
    public TokenResponse queryOIDCTokenWithContext(String context, String clientId, String clientSecret, String audience) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(this.getTokenEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, audience);
    }

    @Override
    public TokenResponse queryOIDCTokenWithContext(String context, String authorization, String audience) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(this.getTokenEndpointURL(this.getRealmBaseURL(context)), authorization, audience);
    }

    @Override
    public TokenResponse queryOIDCTokenWithContext(URL tokenURL, String clientId, String clientSecret, String audience) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(tokenURL, clientId, clientSecret, audience, null);
    }

    @Override
    public TokenResponse queryOIDCTokenWithContext(String context, String clientId, String clientSecret, String audience, Map<String, String> extraHeaders) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(this.getTokenEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, audience, extraHeaders);
    }

    @Override
    public TokenResponse queryOIDCTokenWithContext(URL tokenURL, String clientId, String clientSecret, String audience, Map<String, String> extraHeaders) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(tokenURL, DefaultKeycloakClient.constructBasicAuthenticationHeader(clientId, clientSecret), audience, extraHeaders);
    }

    @Override
    public TokenResponse queryOIDCTokenWithContext(String context, String authorization, String audience, Map<String, String> extraHeaders) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(this.getTokenEndpointURL(this.getRealmBaseURL(context)), authorization, audience, extraHeaders);
    }

    @Override
    public TokenResponse queryOIDCTokenWithContext(URL tokenURL, String authorization, String audience) throws KeycloakClientException {
        return this.queryOIDCTokenWithContext(tokenURL, authorization, audience, (Map<String, String>)null);
    }

    protected static String constructBasicAuthenticationHeader(String clientId, String clientSecret) {
        return "Basic " + Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes());
    }

    @Override
    public TokenResponse queryOIDCTokenOfUserWithContext(String context, String clientId, String clientSecret, String username, String password, String audience) throws KeycloakClientException {
        return this.queryOIDCTokenOfUserWithContext(context, clientId, clientSecret, username, password, audience, (Map<String, String>)null);
    }

    @Override
    public TokenResponse queryOIDCTokenOfUserWithContext(String context, String clientId, String clientSecret, String username, String password, String audience, Map<String, String> extraHeaders) throws KeycloakClientException {
        return this.queryOIDCTokenOfUserWithContext(this.getTokenEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, username, password, audience, extraHeaders);
    }

    @Override
    public TokenResponse queryOIDCTokenOfUserWithContext(String context, String authorization, String username, String password, String audience) throws KeycloakClientException {
        return this.queryOIDCTokenOfUserWithContext(this.getTokenEndpointURL(this.getRealmBaseURL(context)), authorization, username, password, audience);
    }

    @Override
    public TokenResponse queryOIDCTokenOfUserWithContext(String context, String authorization, String username, String password, String audience, Map<String, String> extraHeaders) throws KeycloakClientException {
        return this.queryOIDCTokenOfUserWithContext(this.getTokenEndpointURL(this.getRealmBaseURL(context)), authorization, username, password, audience, extraHeaders);
    }

    @Override
    public TokenResponse queryOIDCTokenOfUserWithContext(URL tokenURL, String clientId, String clientSecret, String username, String password, String audience) throws KeycloakClientException {
        return this.queryOIDCTokenOfUserWithContext(tokenURL, clientId, clientSecret, username, password, audience, (Map<String, String>)null);
    }

    @Override
    public TokenResponse queryOIDCTokenOfUserWithContext(URL tokenURL, String clientId, String clientSecret, String username, String password, String audience, Map<String, String> extraHeaders) throws KeycloakClientException {
        return this.queryOIDCTokenOfUserWithContext(tokenURL, DefaultKeycloakClient.constructBasicAuthenticationHeader(clientId, clientSecret), username, password, audience, extraHeaders);
    }

    @Override
    public TokenResponse queryOIDCTokenOfUserWithContext(URL tokenURL, String authorization, String username, String password, String audience) throws KeycloakClientException {
        return this.queryOIDCTokenOfUserWithContext(tokenURL, authorization, username, password, audience, (Map<String, String>)null);
    }

    @Override
    public TokenResponse queryOIDCTokenOfUserWithContext(URL tokenURL, String authorization, String username, String password, String audience, Map<String, String> extraHeaders) throws KeycloakClientException {
        logger.debug("Querying OIDC token for user '{}' from Keycloak server with URL: {}", (Object)username, (Object)tokenURL);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("grant_type", Arrays.asList("password"));
        params.put("username", Arrays.asList(username));
        params.put("password", Arrays.asList(password));
        if (this.scopes != null && this.scopes.size() > 0) {
            params.put("scope", new ArrayList<String>(this.scopes));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        logger.debug("Adding authorization header as: {}", (Object)authorization);
        headers.put(AUTHORIZATION_HEADER, authorization);
        if (extraHeaders != null) {
            logger.debug("Adding provided extra headers: {}", extraHeaders);
            headers.putAll(extraHeaders);
        }
        if (audience != null) {
            if (this.useDynamicScopeInsteadOfCustomHeaderForContextRestricion) {
                String dynamicScope = DefaultKeycloakClient.constructDynamicScope("d4s-context", audience);
                if (params.containsKey("scope")) {
                    logger.debug("Adding d4s dynamic scope to existing scopes param: {}", (Object)dynamicScope);
                    ((List)params.get("scope")).add(dynamicScope);
                } else {
                    logger.debug("Adding d4s dynamic scope as scopes param: {}", (Object)dynamicScope);
                    params.put("scope", Collections.singletonList(dynamicScope));
                }
            } else {
                logger.debug("Adding d4s context header as: {}", (Object)audience);
                headers.put("x-d4science-context", audience);
            }
        }
        return this.performRequest(tokenURL, headers, params);
    }

    @Override
    public TokenResponse queryOIDCTokenWithContext(URL tokenURL, String authorization, String audience, Map<String, String> extraHeaders) throws KeycloakClientException {
        logger.debug("Querying OIDC token from Keycloak server with URL: {}", (Object)tokenURL);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("grant_type", Arrays.asList("client_credentials"));
        if (this.scopes != null && this.scopes.size() > 0) {
            params.put("scope", new ArrayList<String>(this.scopes));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        logger.debug("Adding authorization header as: {}", (Object)authorization);
        headers.put(AUTHORIZATION_HEADER, authorization);
        if (audience != null) {
            if (this.useDynamicScopeInsteadOfCustomHeaderForContextRestricion) {
                String dynamicScope = DefaultKeycloakClient.constructDynamicScope("d4s-context", audience);
                if (params.containsKey("scope")) {
                    logger.debug("Adding d4s dynamic scope to existing scopes param: {}", (Object)dynamicScope);
                    ((List)params.get("scope")).add(dynamicScope);
                } else {
                    logger.debug("Adding d4s dynamic scope as scopes param: {}", (Object)dynamicScope);
                    params.put("scope", Collections.singletonList(dynamicScope));
                }
            } else {
                logger.debug("Adding d4s context header as: {}", (Object)audience);
                headers.put("x-d4science-context", audience);
            }
        }
        return this.performRequest(tokenURL, headers, params);
    }

    @Override
    public TokenResponse queryUMAToken(String context, TokenResponse oidcTokenResponse, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), oidcTokenResponse, audience, permissions);
    }

    @Override
    public TokenResponse queryUMAToken(URL tokenURL, TokenResponse oidcTokenResponse, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(tokenURL, DefaultKeycloakClient.constructBeareAuthenticationHeader(oidcTokenResponse), audience, permissions);
    }

    protected static String constructBeareAuthenticationHeader(TokenResponse oidcTokenResponse) {
        return "Bearer " + oidcTokenResponse.getAccessToken();
    }

    @Override
    public TokenResponse queryUMAToken(String context, String clientId, String clientSecret, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, audience, permissions);
    }

    @Override
    public TokenResponse queryUMAToken(URL tokenURL, String clientId, String clientSecret, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(tokenURL, DefaultKeycloakClient.constructBasicAuthenticationHeader(clientId, clientSecret), audience, permissions);
    }

    @Override
    public TokenResponse queryUMAToken(String context, String authorization, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), authorization, audience, permissions);
    }

    @Override
    public TokenResponse queryUMAToken(URL tokenURL, String authorization, String audience, List<String> permissions) throws KeycloakClientException {
        if (audience == null || "".equals(audience)) {
            throw new KeycloakClientException("Audience must be not null nor empty");
        }
        logger.debug("Querying UMA token from Keycloak server with URL: {}", (Object)tokenURL);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("grant_type", Arrays.asList("urn:ietf:params:oauth:grant-type:uma-ticket"));
        try {
            String audienceToSend = URLEncoder.encode(DefaultKeycloakClient.checkAudience(audience), "UTF-8");
            params.put("audience", Arrays.asList(audienceToSend));
            logger.trace("audience is {}", (Object)audienceToSend);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Can't URL encode audience: {}", (Object)audience, (Object)e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        logger.debug("Adding authorization header as: {}", (Object)authorization);
        headers.put(AUTHORIZATION_HEADER, authorization);
        if (permissions != null && !permissions.isEmpty()) {
            params.put("permission", permissions.stream().map(s -> {
                try {
                    return URLEncoder.encode(s, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    return "";
                }
            }).collect(Collectors.toList()));
        }
        return this.performRequest(tokenURL, headers, params);
    }

    protected TokenResponse performRequest(URL tokenURL, Map<String, String> headers, Map<String, List<String>> params) throws KeycloakClientException {
        return this.performRequest(TokenResponse.class, tokenURL, headers, params);
    }

    protected <T> T performRequest(Class<T> returnObjectClass, URL url, Map<String, String> headers, Map<String, List<String>> params) throws KeycloakClientException {
        HttpURLConnection httpURLConnection;
        GXHTTPStringRequest request;
        if (url == null) {
            throw new KeycloakClientException("Token URL must be not null");
        }
        try {
            String queryString = "";
            if (params != null) {
                queryString = params.entrySet().stream().flatMap(p -> ((List)p.getValue()).stream().map(v -> (String)p.getKey() + "=" + v)).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
            } else if (logger.isDebugEnabled()) {
                logger.debug("Params map is null");
            }
            logger.trace("Query string is: {}", (Object)queryString);
            request = GXHTTPStringRequest.newRequest((String)url.toString()).header("Content-Type", "application/x-www-form-urlencoded").withBody(queryString);
            this.safeSetAsExternalCallForOldAPI(request);
            if (headers != null) {
                logger.trace("Adding provided headers: {}", headers);
                for (String headerName : headers.keySet()) {
                    request.header(headerName, headers.get(headerName));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("HTTP headers map is null");
            }
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot construct the request object correctly", e);
        }
        try {
            httpURLConnection = request.post();
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot send request correctly", e);
        }
        try {
            StringBuilder sb = new StringBuilder();
            int httpResultCode = httpURLConnection.getResponseCode();
            logger.trace("HTTP Response code: {}", (Object)httpResultCode);
            String responseContentType = httpURLConnection.getContentType();
            if (responseContentType != null) {
                logger.debug("Response content type is: {}", (Object)responseContentType);
            } else {
                responseContentType = "";
            }
            if (httpResultCode != 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream(), "UTF-8"));
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
                throw KeycloakClientException.create("Unable to get token", httpResultCode, responseContentType, sb.toString());
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
            return (T)new ObjectMapper().readValue(sb.toString(), returnObjectClass);
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot construct token response object correctly", e);
        }
    }

    private static String checkAudience(String audience) {
        if (audience.startsWith("/")) {
            try {
                logger.trace("Audience was provided in non URL encoded form, encoding it");
                return URLEncoder.encode(audience, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Cannot URL encode 'audience'", (Throwable)e);
            }
        }
        return audience;
    }

    @Override
    public TokenResponse refreshToken(String context, TokenResponse tokenResponse) throws KeycloakClientException {
        return this.refreshToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), tokenResponse);
    }

    @Override
    public TokenResponse refreshToken(URL tokenURL, TokenResponse tokenResponse) throws KeycloakClientException {
        return this.refreshToken(tokenURL, null, null, tokenResponse);
    }

    @Override
    public TokenResponse refreshToken(String context, String clientId, String clientSecret, TokenResponse tokenResponse) throws KeycloakClientException {
        return this.refreshToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, tokenResponse);
    }

    @Override
    public TokenResponse refreshToken(URL tokenURL, String clientId, String clientSecret, TokenResponse tokenResponse) throws KeycloakClientException {
        if (clientId == null) {
            logger.debug("Client id not set, trying to get it from access token info");
            try {
                clientId = ModelUtils.getClientIdFromToken(ModelUtils.getAccessTokenFrom(tokenResponse));
            }
            catch (Exception e) {
                throw new KeycloakClientException("Cannot construct access token object from token response", e);
            }
        }
        return this.refreshToken(tokenURL, clientId, clientSecret, tokenResponse.getRefreshToken());
    }

    @Override
    public TokenResponse refreshToken(String context, String clientId, String clientSecret, String refreshTokenJWTString) throws KeycloakClientException {
        return this.refreshToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, refreshTokenJWTString);
    }

    @Override
    public TokenResponse refreshToken(URL tokenURL, String clientId, String clientSecret, String refreshTokenJWTString) throws KeycloakClientException {
        if (tokenURL == null) {
            throw new KeycloakClientException("Token URL must be not null");
        }
        if (clientId == null || "".equals(clientId)) {
            throw new KeycloakClientException("Client id must be not null nor empty");
        }
        if (refreshTokenJWTString == null || "".equals(clientId)) {
            throw new KeycloakClientException("Refresh token JWT encoded string must be not null nor empty");
        }
        logger.debug("Refreshing token from Keycloak server with URL: {}", (Object)tokenURL);
        try {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("grant_type", Collections.singletonList("refresh_token"));
            params.put("refresh_token", Collections.singletonList(refreshTokenJWTString));
            params.put("client_id", Collections.singletonList(URLEncoder.encode(clientId, "UTF-8")));
            if (clientSecret != null && !"".equals(clientSecret)) {
                params.put("client_secret", Collections.singletonList(URLEncoder.encode(clientSecret, "UTF-8")));
            }
            return this.performRequest(tokenURL, null, params);
        }
        catch (UnsupportedEncodingException e) {
            throw new KeycloakClientException("Cannot encode parameters", e);
        }
    }

    @Override
    public TokenResponse exchangeTokenForAccessToken(String context, String oidcAccessToken, String clientId, String clientSecret, String audience) throws KeycloakClientException {
        return this.exchangeTokenForAccessToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), oidcAccessToken, clientId, clientSecret, audience);
    }

    @Override
    public TokenResponse exchangeTokenForAccessToken(URL tokenURL, String oidcAccessToken, String clientId, String clientSecret, String audience) throws KeycloakClientException {
        return this.exchangeToken(tokenURL, oidcAccessToken, clientId, clientSecret, audience, "urn:ietf:params:oauth:token-type:access_token", null);
    }

    @Override
    public TokenResponse exchangeTokenForRefreshToken(String context, String oidcAccessToken, String clientId, String clientSecret, String audience) throws KeycloakClientException {
        return this.exchangeTokenForRefreshToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), oidcAccessToken, clientId, clientSecret, audience);
    }

    @Override
    public TokenResponse exchangeTokenForRefreshToken(URL tokenURL, String oidcAccessToken, String clientId, String clientSecret, String audience) throws KeycloakClientException {
        return this.exchangeToken(tokenURL, oidcAccessToken, clientId, clientSecret, audience, "urn:ietf:params:oauth:token-type:refresh_token", null);
    }

    @Override
    public TokenResponse exchangeTokenForOfflineToken(String context, String oidcAccessToken, String clientId, String clientSecret, String audience) throws IllegalArgumentException, KeycloakClientException {
        return this.exchangeTokenForOfflineToken(this.getTokenEndpointURL(this.getRealmBaseURL(context)), oidcAccessToken, clientId, clientSecret, audience);
    }

    @Override
    public TokenResponse exchangeTokenForOfflineToken(URL tokenURL, String oidcAccessToken, String clientId, String clientSecret, String audience) throws IllegalArgumentException, KeycloakClientException {
        AccessToken at = null;
        try {
            at = ModelUtils.getAccessTokenFrom(oidcAccessToken);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Impossible to parse the access token as JSON", e);
        }
        if (at.getScope().indexOf("offline_access") < 0) {
            logger.info("Token to be exchanged doesn't contain 'offline_token' within scopes");
            throw new IllegalArgumentException("Orignal access token doesn't contain the 'offline_token' scope");
        }
        return this.exchangeToken(tokenURL, oidcAccessToken, clientId, clientSecret, audience, "urn:ietf:params:oauth:token-type:refresh_token", "offline_access");
    }

    protected TokenResponse exchangeToken(URL tokenURL, String oidcAccessToken, String clientId, String clientSecret, String audience, String requestedTokenType, String scope) throws KeycloakClientException {
        if (audience == null || "".equals(audience)) {
            throw new KeycloakClientException("Audience must be not null nor empty");
        }
        logger.debug("Exchanging token from Keycloak server with URL: {}", (Object)tokenURL);
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("subject_token", Arrays.asList(oidcAccessToken));
        params.put("client_id", Arrays.asList(clientId));
        params.put("client_secret", Arrays.asList(clientSecret));
        params.put("grant_type", Arrays.asList("urn:ietf:params:oauth:grant-type:token-exchange"));
        params.put("subject_token_type", Arrays.asList("urn:ietf:params:oauth:token-type:access_token"));
        params.put("requested_token_type", Arrays.asList(requestedTokenType));
        if (scope != null) {
            params.put("scope", Arrays.asList(scope));
        }
        try {
            String audienceToSend = URLEncoder.encode(DefaultKeycloakClient.checkAudience(audience), "UTF-8");
            params.put("audience", Arrays.asList(audienceToSend));
            logger.trace("audience is {}", (Object)audienceToSend);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Can't URL encode audience: {}", (Object)audience, (Object)e);
        }
        return this.performRequest(tokenURL, null, params);
    }

    @Override
    public TokenIntrospectionResponse introspectAccessToken(String context, String clientId, String clientSecret, String accessTokenJWTString) throws KeycloakClientException {
        return this.introspectAccessToken(this.getIntrospectionEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, accessTokenJWTString);
    }

    @Override
    public TokenIntrospectionResponse introspectAccessToken(URL introspectionURL, String clientId, String clientSecret, String accessTokenJWTString) throws KeycloakClientException {
        if (introspectionURL == null) {
            throw new KeycloakClientException("Introspection URL must be not null");
        }
        if (clientId == null || "".equals(clientId)) {
            throw new KeycloakClientException("Client id must be not null nor empty");
        }
        if (clientSecret == null || "".equals(clientSecret)) {
            throw new KeycloakClientException("Client secret must be not null nor empty");
        }
        logger.debug("Verifying access token against Keycloak server with URL: {}", (Object)introspectionURL);
        return this.performRequest(TokenIntrospectionResponse.class, introspectionURL, Collections.singletonMap(AUTHORIZATION_HEADER, DefaultKeycloakClient.constructBasicAuthenticationHeader(clientId, clientSecret)), Collections.singletonMap("token", Collections.singletonList(accessTokenJWTString)));
    }

    @Override
    public boolean isAccessTokenVerified(String context, String clientId, String clientSecret, String accessTokenJWTString) throws KeycloakClientException {
        return this.isAccessTokenVerified(this.getIntrospectionEndpointURL(this.getRealmBaseURL(context)), clientId, clientSecret, accessTokenJWTString);
    }

    @Override
    public boolean isAccessTokenVerified(URL introspectionURL, String clientId, String clientSecret, String accessTokenJWTString) throws KeycloakClientException {
        return this.introspectAccessToken(introspectionURL, clientId, clientSecret, accessTokenJWTString).getActive();
    }

    protected void safeSetAsExternalCallForOldAPI(GXHTTPStringRequest request) {
        try {
            logger.trace("Looking for the 'isExternalCall' method in the 'GXHTTPStringRequest' class");
            Method isExetnalCallMethod = request.getClass().getMethod("isExternalCall", Boolean.TYPE);
            logger.trace("Method found, is the old gxHTTP API. Invoking it with 'true' argument");
            isExetnalCallMethod.invoke((Object)request, true);
        }
        catch (NoSuchMethodException e) {
            logger.trace("Method not found, is the new gxHTTP API");
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            logger.warn("Cannot invoke 'isExternalCall' method via reflection on 'GXHTTPStringRequest' class", (Throwable)e);
        }
    }

    @Override
    public byte[] getAvatarData(String context, TokenResponse tokenResponse) throws KeycloakClientException {
        return this.getAvatarData(this.getAvatarEndpointURL(this.getRealmBaseURL(context)), tokenResponse);
    }

    @Override
    public byte[] getAvatarData(URL avatarURL, TokenResponse tokenResponse) throws KeycloakClientException {
        return this.getAvatarData(avatarURL, DefaultKeycloakClient.constructBeareAuthenticationHeader(tokenResponse));
    }

    @Override
    public byte[] getAvatarData(URL avatarURL, String authorization) throws KeycloakClientException {
        logger.debug("Getting user's avatar from URL: {}", (Object)avatarURL);
        try {
            HttpURLConnection httpURLConnection;
            GXHTTPStringRequest request;
            try {
                request = GXHTTPStringRequest.newRequest((String)avatarURL.toString());
                this.safeSetAsExternalCallForOldAPI(request);
                logger.debug("Adding authorization header as: {}", (Object)authorization);
                request = request.header(AUTHORIZATION_HEADER, authorization);
                request = request.header("Accept", "image/png, image/gif");
            }
            catch (Exception e) {
                throw new KeycloakClientException("Cannot construct the request object correctly", e);
            }
            try {
                httpURLConnection = request.get();
            }
            catch (Exception e) {
                throw new KeycloakClientException("Cannot send request correctly", e);
            }
            if (httpURLConnection.getResponseCode() == 200) {
                int nRead;
                String contentType = httpURLConnection.getContentType();
                logger.debug("Getting the stream to the avatar resource with MIME: {}", (Object)contentType);
                InputStream is = httpURLConnection.getInputStream();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[1024];
                while ((nRead = is.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
                buffer.flush();
                return buffer.toByteArray();
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(httpURLConnection.getErrorStream(), "UTF-8"));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
            throw KeycloakClientException.create("Unable to get avatar image data", httpURLConnection.getResponseCode(), httpURLConnection.getContentType(), sb.toString());
        }
        catch (IOException e) {
            throw new KeycloakClientException("Error getting user's avatar data", e);
        }
    }
}

