/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.security.secrets;

import jakarta.servlet.http.HttpServletRequest;
import org.gcube.common.security.secrets.UmaTokenSecret;
import org.gcube.smartgears.security.secrets.SecretFactory;
import org.gcube.smartgears.security.secrets.exceptions.SecretNotFoundException;

public class GCubeKeyCloakSecretFactory
implements SecretFactory<UmaTokenSecret> {
    private static final String BEARER_AUTH_PREFIX = "Bearer";

    @Override
    public UmaTokenSecret create(HttpServletRequest request) throws SecretNotFoundException {
        String authHeader = request.getHeader("Authorization");
        String umaToken = null;
        if (authHeader != null && !authHeader.isEmpty() && authHeader.startsWith(BEARER_AUTH_PREFIX)) {
            umaToken = authHeader.substring(BEARER_AUTH_PREFIX.length()).trim();
            return new UmaTokenSecret(umaToken);
        }
        throw new SecretNotFoundException();
    }

    @Override
    public Class<UmaTokenSecret> getSecretClass() {
        return UmaTokenSecret.class;
    }
}

